/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl.rules;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.navigation.NavigationItem;
import com.intellij.navigation.NavigationItemFileStatus;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.ServerPageFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.FileTypeUtils;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageGroup;
import com.intellij.usages.UsageView;
import com.intellij.usages.impl.rules.FileGroupingRule;
import com.intellij.usages.rules.PsiElementUsage;
import com.intellij.usages.rules.UsageGroupingRule;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class ClassGroupingRule
implements UsageGroupingRule,
DumbAware {
    public UsageGroup groupUsage(@NotNull Usage usage) {
        PsiElement containingClass;
        if (!(usage instanceof PsiElementUsage)) {
            return null;
        }
        PsiElement psiElement = ((PsiElementUsage)usage).getElement();
        PsiFile containingFile = psiElement.getContainingFile();
        if (containingFile == null) {
            return null;
        }
        PsiFile topLevelFile = InjectedLanguageManager.getInstance((Project)containingFile.getProject()).getTopLevelFile((PsiElement)containingFile);
        if (!(topLevelFile instanceof PsiJavaFile) || topLevelFile instanceof ServerPageFile) {
            return null;
        }
        Object object = containingClass = topLevelFile == containingFile ? psiElement : InjectedLanguageManager.getInstance((Project)containingFile.getProject()).getInjectionHost((PsiElement)containingFile);
        while ((containingClass = PsiTreeUtil.getParentOfType((PsiElement)containingClass, PsiClass.class, (boolean)true)) != null && ((PsiClass)containingClass).getQualifiedName() == null) {
        }
        if (containingClass == null) {
            PsiImportList importList = (PsiImportList)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiImportList.class, (boolean)true);
            if (importList != null) {
                PsiClass[] classes;
                String fileName = ClassGroupingRule.getFileNameWithoutExtension(topLevelFile);
                for (PsiClass aClass : classes = ((PsiJavaFile)topLevelFile).getClasses()) {
                    if (!fileName.equals(aClass.getName())) continue;
                    containingClass = aClass;
                    break;
                }
            }
        } else if (containingClass.getParent() instanceof PsiFile && FileTypeUtils.isInServerPageFile((PsiElement)containingClass)) {
            containingClass = null;
        }
        if (containingClass != null) {
            return new ClassUsageGroup((PsiClass)containingClass);
        }
        VirtualFile virtualFile = topLevelFile.getVirtualFile();
        if (virtualFile != null) {
            return new FileGroupingRule.FileUsageGroup(topLevelFile.getProject(), virtualFile);
        }
        return null;
    }

    private static String getFileNameWithoutExtension(PsiFile file2) {
        String name = file2.getName();
        int index = name.lastIndexOf(46);
        return index < 0 ? name : name.substring(0, index);
    }

    private static class ClassUsageGroup
    implements UsageGroup,
    TypeSafeDataProvider {
        private final SmartPsiElementPointer myClassPointer;
        private final String myText;
        private final String myQName;
        private final Icon myIcon;

        public ClassUsageGroup(@NotNull PsiClass aClass) {
            this.myQName = aClass.getQualifiedName();
            this.myText = ClassUsageGroup.createText(aClass);
            this.myClassPointer = SmartPointerManager.getInstance((Project)aClass.getProject()).createSmartPsiElementPointer((PsiElement)aClass);
            this.myIcon = aClass.getIcon(3);
        }

        public void update() {
        }

        private static String createText(PsiClass aClass) {
            String text = aClass.getName();
            for (PsiClass containingClass = aClass.getContainingClass(); containingClass != null; containingClass = containingClass.getContainingClass()) {
                text = containingClass.getName() + '.' + text;
            }
            return text;
        }

        public Icon getIcon(boolean isOpen) {
            return this.myIcon;
        }

        @NotNull
        public String getText(UsageView view) {
            return this.myText;
        }

        public FileStatus getFileStatus() {
            return this.isValid() ? NavigationItemFileStatus.get((NavigationItem)this.getPsiClass()) : null;
        }

        private PsiClass getPsiClass() {
            return (PsiClass)this.myClassPointer.getElement();
        }

        public boolean isValid() {
            PsiClass psiClass = this.getPsiClass();
            return psiClass != null && psiClass.isValid();
        }

        public int hashCode() {
            return this.myQName.hashCode();
        }

        public boolean equals(Object object) {
            return object instanceof ClassUsageGroup && this.myQName.equals(((ClassUsageGroup)object).myQName);
        }

        public void navigate(boolean focus) throws UnsupportedOperationException {
            if (this.canNavigate()) {
                this.getPsiClass().navigate(focus);
            }
        }

        public boolean canNavigate() {
            return this.isValid();
        }

        public boolean canNavigateToSource() {
            return this.canNavigate();
        }

        public int compareTo(@NotNull UsageGroup usageGroup) {
            return this.getText(null).compareToIgnoreCase(usageGroup.getText(null));
        }

        public void calcData(DataKey key, DataSink sink) {
            PsiClass psiClass;
            if (!this.isValid()) {
                return;
            }
            if (CommonDataKeys.PSI_ELEMENT == key) {
                sink.put(CommonDataKeys.PSI_ELEMENT, (Object)this.getPsiClass());
            }
            if (UsageView.USAGE_INFO_KEY == key && (psiClass = this.getPsiClass()) != null) {
                sink.put(UsageView.USAGE_INFO_KEY, (Object)new UsageInfo((PsiElement)psiClass));
            }
        }
    }
}

