/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usageView;

import com.intellij.ide.TypePresentationService;
import com.intellij.lang.LangBundle;
import com.intellij.lang.Language;
import com.intellij.lang.findUsages.FindUsagesProvider;
import com.intellij.lang.findUsages.LanguageFindUsages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionProvider;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.meta.PsiPresentableMetaData;
import org.jetbrains.annotations.NotNull;

public class UsageViewTypeLocation
extends ElementDescriptionLocation {
    public static final UsageViewTypeLocation INSTANCE = new UsageViewTypeLocation();
    private static final ElementDescriptionProvider DEFAULT_PROVIDER = new ElementDescriptionProvider(){

        public String getElementDescription(@NotNull PsiElement psiElement, @NotNull ElementDescriptionLocation location) {
            PsiMetaData metaData;
            if (!(location instanceof UsageViewTypeLocation)) {
                return null;
            }
            if (psiElement instanceof PsiMetaOwner && (metaData = ((PsiMetaOwner)psiElement).getMetaData()) instanceof PsiPresentableMetaData) {
                return ((PsiPresentableMetaData)metaData).getTypeName();
            }
            if (psiElement instanceof PsiFile) {
                return LangBundle.message("terms.file", new Object[0]);
            }
            if (psiElement instanceof PsiDirectory) {
                return LangBundle.message("terms.directory", new Object[0]);
            }
            Language lang = psiElement.getLanguage();
            FindUsagesProvider provider = (FindUsagesProvider)LanguageFindUsages.INSTANCE.forLanguage(lang);
            String type = provider.getType(psiElement);
            if (StringUtil.isNotEmpty((String)type)) {
                return type;
            }
            return TypePresentationService.getService().getTypePresentableName(psiElement.getClass());
        }
    };

    private UsageViewTypeLocation() {
    }

    public ElementDescriptionProvider getDefaultProvider() {
        return DEFAULT_PROVIDER;
    }
}

