/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usageView;

import com.intellij.analysis.AnalysisScope;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiVariable;
import com.intellij.slicer.DuplicateMap;
import com.intellij.slicer.JavaSliceUsage;
import com.intellij.slicer.SliceAnalysisParams;
import com.intellij.slicer.SlicePanel;
import com.intellij.slicer.SliceRootNode;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usages.PsiElementUsageTarget;
import com.intellij.usages.UsageContextPanel;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.impl.UsageContextPanelBase;
import com.intellij.usages.impl.UsageViewImpl;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UsageContextDataflowToPanel
extends UsageContextPanelBase {
    @NotNull
    private final UsageViewPresentation myPresentation;
    private JComponent myPanel;

    public UsageContextDataflowToPanel(@NotNull Project project2, @NotNull UsageViewPresentation presentation) {
        super(project2, presentation);
        this.myPresentation = presentation;
    }

    public void dispose() {
        super.dispose();
        this.myPanel = null;
    }

    public void updateLayoutLater(@Nullable List<UsageInfo> infos) {
        if (infos == null) {
            this.removeAll();
            JLabel titleComp = new JLabel(UsageViewBundle.message((String)"select.the.usage.to.preview", (Object[])new Object[]{this.myPresentation.getUsagesWord()}), 0);
            this.add(titleComp, "Center");
            this.revalidate();
        } else {
            JComponent panel;
            PsiElement element = UsageContextDataflowToPanel.getElementToSliceOn(infos);
            if (element == null) {
                return;
            }
            if (this.myPanel != null) {
                Disposer.dispose((Disposable)((Disposable)this.myPanel));
            }
            this.myPanel = panel = this.createPanel(element, this.isDataflowToThis());
            Disposer.register((Disposable)this, (Disposable)((Disposable)panel));
            this.removeAll();
            this.add(panel, "Center");
            this.revalidate();
        }
    }

    protected boolean isDataflowToThis() {
        return true;
    }

    @NotNull
    private static SliceAnalysisParams createParams(PsiElement element, boolean dataFlowToThis) {
        SliceAnalysisParams params = new SliceAnalysisParams();
        params.scope = new AnalysisScope(element.getProject());
        params.dataFlowToThis = dataFlowToThis;
        params.showInstanceDereferences = true;
        return params;
    }

    @NotNull
    protected JComponent createPanel(@NotNull PsiElement element, boolean dataFlowToThis) {
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(ToolWindowId.FIND);
        SliceAnalysisParams params = UsageContextDataflowToPanel.createParams(element, dataFlowToThis);
        SliceRootNode rootNode = new SliceRootNode(this.myProject, new DuplicateMap(), JavaSliceUsage.createRootUsage(element, params));
        return new SlicePanel(this.myProject, dataFlowToThis, rootNode, false, toolWindow){

            @Override
            public boolean isToShowAutoScrollButton() {
                return false;
            }

            @Override
            public boolean isToShowPreviewButton() {
                return false;
            }

            @Override
            public boolean isToShowCloseButton() {
                return false;
            }

            @Override
            public boolean isAutoScroll() {
                return false;
            }

            @Override
            public void setAutoScroll(boolean autoScroll) {
            }

            @Override
            public boolean isPreview() {
                return false;
            }

            @Override
            public void setPreview(boolean preview) {
            }
        };
    }

    private static PsiElement getElementToSliceOn(@NotNull List<UsageInfo> infos) {
        UsageInfo info = infos.get(0);
        return info.getElement();
    }

    public static class Provider
    implements UsageContextPanel.Provider {
        @NotNull
        public UsageContextPanel create(@NotNull UsageView usageView) {
            return new UsageContextDataflowToPanel(((UsageViewImpl)usageView).getProject(), usageView.getPresentation());
        }

        public boolean isAvailableFor(@NotNull UsageView usageView) {
            UsageTarget[] targets = ((UsageViewImpl)usageView).getTargets();
            if (targets.length == 0) {
                return false;
            }
            UsageTarget target = targets[0];
            if (!(target instanceof PsiElementUsageTarget)) {
                return false;
            }
            PsiElement element = ((PsiElementUsageTarget)target).getElement();
            if (element == null || !element.isValid()) {
                return false;
            }
            if (!(element instanceof PsiVariable)) {
                return false;
            }
            PsiFile file2 = element.getContainingFile();
            return file2 instanceof PsiJavaFile;
        }

        @NotNull
        public String getTabTitle() {
            return "Dataflow to Here";
        }
    }
}

