/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageDependencies.DefaultScopesProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.scope.TestsScope;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PackageSetBase;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.tabs.FileColorConfiguration;
import com.intellij.ui.tabs.FileColorManagerImpl;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileColorsModel
implements Cloneable {
    public static final String FILE_COLOR = "fileColor";
    private final List<FileColorConfiguration> myApplicationLevelConfigurations;
    private final List<FileColorConfiguration> myProjectLevelConfigurations;
    private static final Map<String, String> predefinedScopeNameToPropertyKey = new THashMap();
    private static final Map<String, String> predefinedScopeNameToColor;
    @NotNull
    private final Project myProject;

    FileColorsModel(@NotNull Project project2) {
        this.myProject = project2;
        this.myApplicationLevelConfigurations = new ArrayList<FileColorConfiguration>();
        this.myProjectLevelConfigurations = new ArrayList<FileColorConfiguration>();
        if (predefinedScopeNameToColor.size() < predefinedScopeNameToPropertyKey.size()) {
            DefaultScopesProvider defaultScopesProvider = DefaultScopesProvider.getInstance(project2);
            for (String scopeName : predefinedScopeNameToPropertyKey.keySet()) {
                NamedScope scope = defaultScopesProvider.findCustomScope(scopeName);
                assert (scope != null) : "There is no custom scope with name " + scopeName;
                Color color = ColorUtil.getColor(scope.getClass());
                assert (color != null) : scope.getClass().getName() + " is not annotated with @Colored";
                String colorName = FileColorManagerImpl.getColorName(color);
                predefinedScopeNameToColor.put(scopeName, colorName == null ? ColorUtil.toHex((Color)color) : colorName);
            }
        }
        this.initGlobalScopes();
    }

    private FileColorsModel(@NotNull Project project2, @NotNull List<FileColorConfiguration> applicationLevel, @NotNull List<FileColorConfiguration> projectLevel) {
        this.myProject = project2;
        this.myApplicationLevelConfigurations = new ArrayList<FileColorConfiguration>();
        this.myProjectLevelConfigurations = new ArrayList<FileColorConfiguration>();
        this.myApplicationLevelConfigurations.addAll(applicationLevel);
        this.myProjectLevelConfigurations.addAll(projectLevel);
        this.initGlobalScopes();
    }

    private void initGlobalScopes() {
        PropertiesComponent propertyComponent = PropertiesComponent.getInstance();
        for (String scopeName : predefinedScopeNameToPropertyKey.keySet()) {
            if (this.findConfiguration(scopeName, false) != null) continue;
            String color = propertyComponent.getValue(predefinedScopeNameToPropertyKey.get(scopeName));
            if (color == null && (color = propertyComponent.getValue(scopeName)) == null) {
                color = predefinedScopeNameToColor.get(scopeName);
            }
            if (color.isEmpty()) continue;
            Color col = ColorUtil.fromHex((String)color, null);
            String name = col == null ? null : FileColorManagerImpl.getColorName(col);
            this.myApplicationLevelConfigurations.add(new FileColorConfiguration(scopeName, name == null ? color : name));
        }
    }

    public void save(@NotNull Element e, boolean isProjectLevel) {
        List<FileColorConfiguration> configurations = isProjectLevel ? this.myProjectLevelConfigurations : this.myApplicationLevelConfigurations;
        for (FileColorConfiguration configuration : configurations) {
            String propertyKey;
            String scopeName = configuration.getScopeName();
            String string = propertyKey = isProjectLevel ? null : predefinedScopeNameToPropertyKey.get(scopeName);
            if (propertyKey == null) {
                configuration.save(e);
                continue;
            }
            PropertiesComponent propertyComponent = PropertiesComponent.getInstance();
            propertyComponent.setValue(propertyKey, configuration.getColorName(), predefinedScopeNameToColor.get(scopeName));
            PropertiesComponent.getInstance().setValue(scopeName, null);
        }
    }

    public void load(@NotNull Element e, boolean isProjectLevel) {
        List<FileColorConfiguration> configurations = isProjectLevel ? this.myProjectLevelConfigurations : this.myApplicationLevelConfigurations;
        configurations.clear();
        THashMap predefinedScopeNameToPropertyKey = new THashMap(FileColorsModel.predefinedScopeNameToPropertyKey);
        for (Element child : e.getChildren(FILE_COLOR)) {
            FileColorConfiguration configuration = FileColorConfiguration.load(child);
            if (configuration == null) continue;
            if (!isProjectLevel) {
                predefinedScopeNameToPropertyKey.remove(configuration.getScopeName());
            }
            configurations.add(configuration);
        }
        if (!isProjectLevel) {
            PropertiesComponent properties = PropertiesComponent.getInstance();
            for (String scopeName : predefinedScopeNameToPropertyKey.keySet()) {
                String colorName = properties.getValue((String)predefinedScopeNameToPropertyKey.get(scopeName));
                if (colorName == null && (colorName = properties.getValue(scopeName)) == null) {
                    colorName = predefinedScopeNameToColor.get(scopeName);
                }
                if (StringUtil.isEmpty((String)colorName)) continue;
                configurations.add(new FileColorConfiguration(scopeName, colorName));
            }
        }
    }

    public FileColorsModel clone() throws CloneNotSupportedException {
        ArrayList<FileColorConfiguration> applicationLevel = new ArrayList<FileColorConfiguration>();
        for (FileColorConfiguration configuration : this.myApplicationLevelConfigurations) {
            applicationLevel.add(configuration.clone());
        }
        ArrayList<FileColorConfiguration> projectLevel = new ArrayList<FileColorConfiguration>();
        for (FileColorConfiguration configuration : this.myProjectLevelConfigurations) {
            projectLevel.add(configuration.clone());
        }
        return new FileColorsModel(this.myProject, applicationLevel, projectLevel);
    }

    public void add(@NotNull FileColorConfiguration configuration, boolean isProjectLevel) {
        List<FileColorConfiguration> configurations;
        List<FileColorConfiguration> list = configurations = isProjectLevel ? this.myProjectLevelConfigurations : this.myApplicationLevelConfigurations;
        if (!configurations.contains(configuration)) {
            configurations.add(configuration);
        }
    }

    public void add(@NotNull String scopeName, @NotNull String colorName, boolean isProjectLevel) {
        this.add(new FileColorConfiguration(scopeName, colorName), isProjectLevel);
    }

    @Nullable
    private FileColorConfiguration findConfiguration(@NotNull String scopeName, boolean isProjectLevel) {
        List<FileColorConfiguration> configurations = isProjectLevel ? this.myProjectLevelConfigurations : this.myApplicationLevelConfigurations;
        for (FileColorConfiguration configuration : configurations) {
            if (!scopeName.equals(configuration.getScopeName())) continue;
            return configuration;
        }
        return null;
    }

    public boolean isProjectLevel(@NotNull String scopeName) {
        return this.findConfiguration(scopeName, true) != null;
    }

    @Nullable
    public String getColor(@NotNull PsiFile psiFile) {
        if (!psiFile.isValid()) {
            return null;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        return virtualFile == null ? null : this.getColor(virtualFile, psiFile.getProject());
    }

    @Nullable
    public String getColor(@NotNull VirtualFile file2, Project project2) {
        if (!file2.isValid()) {
            return null;
        }
        FileColorConfiguration configuration = this.findConfiguration(file2);
        if (configuration != null && configuration.isValid(project2)) {
            return configuration.getColorName();
        }
        return null;
    }

    @Nullable
    private FileColorConfiguration findConfiguration(@NotNull VirtualFile colored) {
        for (FileColorConfiguration configuration : ContainerUtil.concat(this.myApplicationLevelConfigurations, this.myProjectLevelConfigurations)) {
            NamedScope scope = NamedScopesHolder.getScope((Project)this.myProject, (String)configuration.getScopeName());
            if (scope == null) continue;
            NamedScopesHolder namedScopesHolder = NamedScopesHolder.getHolder((Project)this.myProject, (String)configuration.getScopeName(), null);
            PackageSet packageSet = scope.getValue();
            if (!(packageSet instanceof PackageSetBase) || namedScopesHolder == null || !((PackageSetBase)packageSet).contains(colored, this.myProject, namedScopesHolder)) continue;
            return configuration;
        }
        return null;
    }

    public boolean isProjectLevel(@NotNull FileColorConfiguration configuration) {
        return this.myProjectLevelConfigurations.contains(configuration);
    }

    public void setConfigurations(@NotNull List<FileColorConfiguration> configurations, boolean isProjectLevel) {
        if (isProjectLevel) {
            this.myProjectLevelConfigurations.clear();
            this.myProjectLevelConfigurations.addAll(configurations);
        } else {
            this.myApplicationLevelConfigurations.clear();
            THashMap predefinedScopeNameToPropertyKey = new THashMap(FileColorsModel.predefinedScopeNameToPropertyKey);
            PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
            for (FileColorConfiguration configuration : configurations) {
                this.myApplicationLevelConfigurations.add(configuration);
                String propertyKey = (String)predefinedScopeNameToPropertyKey.remove(configuration.getScopeName());
                if (propertyKey == null) continue;
                propertiesComponent.setValue(propertyKey, configuration.getColorName());
            }
            for (String scopeName : predefinedScopeNameToPropertyKey.keySet()) {
                propertiesComponent.setValue((String)predefinedScopeNameToPropertyKey.get(scopeName), "");
                propertiesComponent.setValue(scopeName, null);
            }
        }
    }

    public boolean isColored(@NotNull String scopeName, boolean isProjectLevel) {
        return this.findConfiguration(scopeName, isProjectLevel) != null;
    }

    public List<FileColorConfiguration> getLocalConfigurations() {
        return this.myApplicationLevelConfigurations;
    }

    @NotNull
    public List<FileColorConfiguration> getProjectLevelConfigurations() {
        return this.myProjectLevelConfigurations;
    }

    static {
        predefinedScopeNameToPropertyKey.put("Non-Project Files", "file.colors.enable.non.project");
        predefinedScopeNameToPropertyKey.put(TestsScope.NAME, "file.colors.enable.tests");
        predefinedScopeNameToColor = new THashMap();
    }
}

