/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.switcher;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.SeparatorWithText;
import com.intellij.ui.components.panels.VerticalBox;
import com.intellij.ui.switcher.QuickAccessSettings;
import com.intellij.util.ui.AwtVisitor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class QuickAccessConfigurable
extends JPanel
implements SearchableConfigurable {
    private Set<String> myModifiers = new HashSet<String>();
    private boolean myQaEnabled;
    private int myDelay;
    private JCheckBox myEnabled;
    private ModifierBox myCtrl;
    private ModifierBox myAlt;
    private ModifierBox myShift;
    private ModifierBox myMeta;
    private JPanel myConflicts;
    private JFormattedTextField myHoldTime;
    private QuickAccessSettings myQuickAccessSettings;

    public QuickAccessConfigurable(QuickAccessSettings quickAccessSettings) {
        this.myQuickAccessSettings = quickAccessSettings;
        JPanel north = new JPanel(new BorderLayout());
        VerticalBox box = new VerticalBox();
        north.add((Component)box, "North");
        this.setLayout(new BorderLayout());
        this.add((Component)north, "West");
        this.myEnabled = new JCheckBox("Enable Quick Access");
        this.myEnabled.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                QuickAccessConfigurable.this.myQaEnabled = QuickAccessConfigurable.this.myEnabled.isSelected();
                QuickAccessConfigurable.this.processEnabled();
            }
        });
        box.add((Component)this.myEnabled);
        VerticalBox kbConfig = new VerticalBox();
        JPanel modifiers = new JPanel(new FlowLayout(1)){

            @Override
            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                size.width = (int)((double)size.width * 1.5);
                return size;
            }
        };
        this.myCtrl = new ModifierBox("control", KeyEvent.getKeyModifiersText(2));
        this.myAlt = new ModifierBox("alt", KeyEvent.getKeyModifiersText(8));
        this.myShift = new ModifierBox("shift", KeyEvent.getKeyModifiersText(1));
        this.myMeta = new ModifierBox("meta", KeyEvent.getKeyModifiersText(4));
        modifiers.add(new JLabel("Modifiers:"));
        modifiers.add(this.myCtrl);
        modifiers.add(this.myAlt);
        modifiers.add(this.myShift);
        if (SystemInfo.isMac) {
            modifiers.add(this.myMeta);
        }
        JPanel hold = new JPanel(new FlowLayout(1));
        hold.add(new JLabel("Hold time:"));
        this.myHoldTime = new JFormattedTextField(NumberFormat.getIntegerInstance());
        this.myHoldTime.setColumns(5);
        this.myHoldTime.setHorizontalAlignment(4);
        this.myHoldTime.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                String txt = QuickAccessConfigurable.this.myHoldTime.getText();
                if (txt != null) {
                    try {
                        Integer value = Integer.valueOf(txt);
                        QuickAccessConfigurable.this.myDelay = value;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        });
        hold.add(this.myHoldTime);
        hold.add(new JLabel("ms"));
        kbConfig.add((Component)modifiers);
        kbConfig.add((Component)hold);
        kbConfig.setBorder((Border)IdeBorderFactory.createTitledBorder((String)"Keyboard Configuration", (boolean)true));
        box.add((Component)kbConfig);
        this.myConflicts = new JPanel();
        box.add((Component)this.myConflicts);
        this.updateConflicts();
    }

    private Set<String> getModifierTexts() {
        HashSet<String> result = new HashSet<String>();
        for (Integer each : this.myQuickAccessSettings.getModiferCodes()) {
            if (each == 16) {
                result.add("shift");
                continue;
            }
            if (each == 17) {
                result.add("control");
                continue;
            }
            if (each == 18) {
                result.add("alt");
                continue;
            }
            if (each != 157) continue;
            result.add("meta");
        }
        return result;
    }

    private void updateConflicts() {
        this.myConflicts.removeAll();
        this.myConflicts.setBorder(null);
        if (!this.myQaEnabled) {
            return;
        }
        if (this.myModifiers.size() == 0) {
            this.myConflicts.setLayout(new BorderLayout());
            this.myConflicts.add((Component)QuickAccessConfigurable.getSmallLabel("Without assigning modifier keys Quick Access will not function"), "North");
            return;
        }
        this.myConflicts.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(0, 4, 0, 4);
        boolean hasConflicts = this.printConflict(c, 38, "SwitchUp");
        hasConflicts |= this.printConflict(c, 40, "SwitchDown");
        hasConflicts |= this.printConflict(c, 37, "SwitchLeft");
        hasConflicts |= this.printConflict(c, 39, "SwitchRight");
        if (hasConflicts |= this.printConflict(c, 10, "SwitchApply")) {
            this.myConflicts.setBorder((Border)IdeBorderFactory.createTitledBorder((String)"Conflicts", (boolean)true));
            c.gridx = 0;
            ++c.gridy;
            c.gridwidth = 2;
            this.myConflicts.add((Component)new SeparatorWithText(), c);
            c.gridx = 0;
            ++c.gridy;
            this.myConflicts.add((Component)QuickAccessConfigurable.getSmallLabel("These conflicting actions may be not what you use a lot"), c);
        }
    }

    private static JLabel getSmallLabel(String text) {
        JLabel message = new JLabel(text, null, 0);
        message.setFont(message.getFont().deriveFont(message.getFont().getStyle(), message.getFont().getSize() - 2));
        return message;
    }

    private boolean printConflict(GridBagConstraints c, int actionKey, String actionId) {
        boolean hasConflicts = false;
        int mask = this.myQuickAccessSettings.getModifierMask(this.myModifiers);
        KeyboardShortcut sc = new KeyboardShortcut(KeyStroke.getKeyStroke(actionKey, mask), null);
        Map conflictMap = this.myQuickAccessSettings.getKeymap().getConflicts(actionId, sc);
        if (conflictMap.size() > 0) {
            hasConflicts = true;
            JLabel scText = new JLabel(sc.toString());
            ++c.gridy;
            c.gridx = 0;
            this.myConflicts.add((Component)scText, c);
            for (String each : conflictMap.keySet()) {
                AnAction eachAnAction = ActionManager.getInstance().getAction(each);
                if (eachAnAction == null) continue;
                String text = eachAnAction.getTemplatePresentation().getText();
                JLabel eachAction = new JLabel(text != null && text.length() > 0 ? text : each);
                c.gridx = 1;
                this.myConflicts.add((Component)eachAction, c);
                ++c.gridy;
            }
        }
        c.gridx = 0;
        c.gridwidth = 2;
        ++c.gridy;
        this.myConflicts.add((Component)new SeparatorWithText(), c);
        c.gridwidth = 1;
        return hasConflicts;
    }

    @Nls
    public String getDisplayName() {
        return "Quick Access";
    }

    public String getHelpTopic() {
        return null;
    }

    public JComponent createComponent() {
        return this;
    }

    @NotNull
    public String getId() {
        return "QuickAccess";
    }

    public Runnable enableSearch(String option) {
        return null;
    }

    public boolean isModified() {
        return !this.myModifiers.equals(this.getModifierTexts()) || this.myQuickAccessSettings.isEnabled() != this.myEnabled.isSelected() || QuickAccessConfigurable.getHoldTime() != this.myDelay;
    }

    public void apply() throws ConfigurationException {
        Registry.get((String)"actionSystem.quickAccessEnabled").setValue(this.myEnabled.isSelected());
        this.myQuickAccessSettings.saveModifiersToRegistry(this.myModifiers);
        Registry.get((String)"actionSystem.keyGestureHoldTime").setValue(this.myDelay);
    }

    public void reset() {
        int delay = QuickAccessConfigurable.getHoldTime();
        this.myQaEnabled = this.myQuickAccessSettings.isEnabled();
        this.myModifiers.clear();
        this.myModifiers.addAll(this.getModifierTexts());
        this.myDelay = delay;
        this.myEnabled.setSelected(this.myQaEnabled);
        this.myCtrl.readMask();
        this.myAlt.readMask();
        this.myShift.readMask();
        this.myMeta.readMask();
        this.myHoldTime.setText(String.valueOf(delay));
        this.processEnabled();
        this.updateConflicts();
    }

    private static int getHoldTime() {
        return Registry.intValue((String)"actionSystem.keyGestureHoldTime");
    }

    public void disposeUIResources() {
    }

    private void processEnabled() {
        new AwtVisitor(this){

            public boolean visit(Component component) {
                if (component != QuickAccessConfigurable.this.myEnabled) {
                    component.setEnabled(QuickAccessConfigurable.this.myQaEnabled);
                }
                return false;
            }
        };
    }

    private class ModifierBox
    extends JCheckBox {
        private String myModifierText;

        private ModifierBox(String modifierText, String text) {
            this.setText(text);
            this.myModifierText = modifierText;
            this.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    ModifierBox.this.applyMask();
                    QuickAccessConfigurable.this.updateConflicts();
                }
            });
        }

        private void applyMask() {
            if (this.isSelected()) {
                QuickAccessConfigurable.this.myModifiers.add(this.myModifierText);
            } else {
                QuickAccessConfigurable.this.myModifiers.remove(this.myModifierText);
            }
        }

        public boolean readMask() {
            boolean selected = QuickAccessConfigurable.this.myModifiers.contains(this.myModifierText);
            this.setSelected(selected);
            return selected;
        }
    }
}

