/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup.list;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListPopupStepEx;
import com.intellij.openapi.ui.popup.MultiSelectionListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.statistics.StatisticsInfo;
import com.intellij.psi.statistics.StatisticsManager;
import com.intellij.ui.JBListWithHintProvider;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SeparatorWithText;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.popup.ClosableByLeftArrow;
import com.intellij.ui.popup.WizardPopup;
import com.intellij.ui.popup.list.ListPopupModel;
import com.intellij.ui.popup.list.PopupListElementRenderer;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ListPopupImpl
extends WizardPopup
implements ListPopup {
    private MyList myList;
    private MyMouseMotionListener myMouseMotionListener;
    private MyMouseListener myMouseListener;
    private ListPopupModel myListModel;
    private int myIndexForShowingChild = -1;
    private int myMaxRowCount = 20;
    private boolean myAutoHandleBeforeShow;

    public ListPopupImpl(@NotNull ListPopupStep aStep, int maxRowCount) {
        super((PopupStep<Object>)aStep);
        if (maxRowCount != -1) {
            this.myMaxRowCount = maxRowCount;
        }
    }

    public ListPopupImpl(@NotNull ListPopupStep aStep) {
        this(aStep, -1);
    }

    public ListPopupImpl(WizardPopup aParent, @NotNull ListPopupStep aStep, Object parentValue) {
        this(aParent, aStep, parentValue, -1);
    }

    public ListPopupImpl(WizardPopup aParent, @NotNull ListPopupStep aStep, Object parentValue, int maxRowCount) {
        super(aParent, (PopupStep<Object>)aStep);
        this.setParentValue(parentValue);
        if (maxRowCount != -1) {
            this.myMaxRowCount = maxRowCount;
        }
    }

    public void showUnderneathOfLabel(@NotNull JLabel label) {
        int offset = -UIUtil.getListCellHPadding() - UIUtil.getListViewportPadding().left;
        if (label.getIcon() != null) {
            offset += label.getIcon().getIconWidth() + label.getIconTextGap();
        }
        this.show(new RelativePoint((Component)label, new Point(offset, label.getHeight() + 1)));
    }

    protected ListPopupModel getListModel() {
        return this.myListModel;
    }

    @Override
    protected boolean beforeShow() {
        this.myList.addMouseMotionListener(this.myMouseMotionListener);
        this.myList.addMouseListener(this.myMouseListener);
        this.myList.setVisibleRowCount(Math.min(this.myMaxRowCount, this.myListModel.getSize()));
        boolean shouldShow = super.beforeShow();
        if (this.myAutoHandleBeforeShow) {
            boolean toDispose = this.tryToAutoSelect(true);
            shouldShow &= !toDispose;
        }
        return shouldShow;
    }

    @Override
    public void goBack() {
        this.myList.clearSelection();
        super.goBack();
    }

    @Override
    protected void afterShow() {
        this.tryToAutoSelect(false);
    }

    private boolean tryToAutoSelect(boolean handleFinalChoices) {
        ListPopupStep<Object> listStep = this.getListStep();
        boolean selected = false;
        if (listStep instanceof MultiSelectionListPopupStep) {
            int[] indices = ((MultiSelectionListPopupStep)listStep).getDefaultOptionIndices();
            if (indices.length > 0) {
                ScrollingUtil.ensureIndexIsVisible((JList)((Object)this.myList), (int)indices[0], (int)0);
                this.myList.setSelectedIndices(indices);
                selected = true;
            }
        } else {
            int defaultIndex = listStep.getDefaultOptionIndex();
            if (defaultIndex >= 0 && defaultIndex < this.myList.getModel().getSize()) {
                ScrollingUtil.selectItem((JList)((Object)this.myList), (int)defaultIndex);
                selected = true;
            }
        }
        if (!selected) {
            this.selectFirstSelectableItem();
        }
        if (listStep.isAutoSelectionEnabled()) {
            if (!this.isVisible() && this.getSelectableCount() == 1) {
                return this._handleSelect(handleFinalChoices, null);
            }
            if (this.isVisible() && this.hasSingleSelectableItemWithSubmenu()) {
                return this._handleSelect(handleFinalChoices, null);
            }
        }
        return false;
    }

    private boolean autoSelectUsingStatistics() {
        String filter = this.getSpeedSearch().getFilter();
        if (!StringUtil.isEmpty((String)filter)) {
            int maxUseCount = -1;
            int mostUsedValue = -1;
            int elementsCount = this.myListModel.getSize();
            for (int i = 0; i < elementsCount; ++i) {
                Object value = this.myListModel.getElementAt(i);
                String text = this.getListStep().getTextFor(value);
                int count = StatisticsManager.getInstance().getUseCount(new StatisticsInfo("#list_popup:" + this.myStep.getTitle() + "#" + filter, text));
                if (count <= maxUseCount) continue;
                maxUseCount = count;
                mostUsedValue = i;
            }
            if (mostUsedValue > 0) {
                ScrollingUtil.selectItem((JList)((Object)this.myList), (int)mostUsedValue);
                return true;
            }
        }
        return false;
    }

    private void selectFirstSelectableItem() {
        for (int i = 0; i < this.myListModel.getSize(); ++i) {
            if (!this.getListStep().isSelectable(this.myListModel.getElementAt(i))) continue;
            this.myList.setSelectedIndex(i);
            break;
        }
    }

    private boolean hasSingleSelectableItemWithSubmenu() {
        boolean oneSubmenuFound = false;
        int countSelectables = 0;
        for (int i = 0; i < this.myListModel.getSize(); ++i) {
            Object elementAt = this.myListModel.getElementAt(i);
            if (!this.getListStep().isSelectable(elementAt)) continue;
            ++countSelectables;
            if (!this.getStep().hasSubstep(elementAt)) continue;
            if (oneSubmenuFound) {
                return false;
            }
            oneSubmenuFound = true;
        }
        return oneSubmenuFound && countSelectables == 1;
    }

    private int getSelectableCount() {
        int count = 0;
        for (int i = 0; i < this.myListModel.getSize(); ++i) {
            Object each = this.myListModel.getElementAt(i);
            if (!this.getListStep().isSelectable(each)) continue;
            ++count;
        }
        return count;
    }

    public JList getList() {
        return this.myList;
    }

    @Override
    protected JComponent createContent() {
        this.myMouseMotionListener = new MyMouseMotionListener();
        this.myMouseListener = new MyMouseListener();
        ListPopupStep<Object> step = this.getListStep();
        this.myListModel = new ListPopupModel(this, this.getSpeedSearch(), step);
        this.myList = new MyList();
        if (this.myStep.getTitle() != null) {
            this.myList.getAccessibleContext().setAccessibleName(this.myStep.getTitle());
        }
        if (step instanceof ListPopupStepEx) {
            ((ListPopupStepEx)step).setEmptyText(this.myList.getEmptyText());
        }
        this.myList.setSelectionMode(this.isMultiSelectionEnabled() ? 2 : 0);
        this.myList.setSelectedIndex(0);
        Insets padding = UIUtil.getListViewportPadding();
        this.myList.setBorder(new EmptyBorder(padding));
        ScrollingUtil.installActions((JList)((Object)this.myList));
        this.myList.setCellRenderer(this.getListElementRenderer());
        this.myList.getActionMap().get("selectNextColumn").setEnabled(false);
        this.myList.getActionMap().get("selectPreviousColumn").setEnabled(false);
        this.registerAction("handleSelection1", 10, 0, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListPopupImpl.this.handleSelect(true);
            }
        });
        this.registerAction("handleSelection2", 39, 0, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListPopupImpl.this.handleSelect(false);
            }
        });
        this.registerAction("goBack2", 37, 0, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ListPopupImpl.this.isClosableByLeftArrow()) {
                    ListPopupImpl.this.goBack();
                }
            }
        });
        this.myList.setCursor(Cursor.getPredefinedCursor(12));
        return this.myList;
    }

    private boolean isMultiSelectionEnabled() {
        return this.getListStep() instanceof MultiSelectionListPopupStep;
    }

    private boolean isClosableByLeftArrow() {
        return this.getParent() != null || this.myStep instanceof ClosableByLeftArrow;
    }

    @Override
    protected ActionMap getActionMap() {
        return this.myList.getActionMap();
    }

    @Override
    protected InputMap getInputMap() {
        return this.myList.getInputMap();
    }

    protected ListCellRenderer getListElementRenderer() {
        return new PopupListElementRenderer(this);
    }

    public ListPopupStep<Object> getListStep() {
        return (ListPopupStep)this.myStep;
    }

    @Override
    public void dispose() {
        this.myList.removeMouseMotionListener(this.myMouseMotionListener);
        this.myList.removeMouseListener(this.myMouseListener);
        super.dispose();
    }

    protected int getSelectedIndex() {
        return this.myList.getSelectedIndex();
    }

    protected Rectangle getCellBounds(int i) {
        return this.myList.getCellBounds(i, i);
    }

    @Override
    public void disposeChildren() {
        this.setIndexForShowingChild(-1);
        super.disposeChildren();
    }

    @Override
    protected void onAutoSelectionTimer() {
        if (this.myList.getModel().getSize() > 0 && !this.myList.isSelectionEmpty()) {
            this.handleSelect(false);
        } else {
            this.disposeChildren();
            this.setIndexForShowingChild(-1);
        }
    }

    public void handleSelect(boolean handleFinalChoices) {
        this._handleSelect(handleFinalChoices, null);
    }

    public void handleSelect(boolean handleFinalChoices, InputEvent e) {
        this._handleSelect(handleFinalChoices, e);
    }

    private boolean _handleSelect(boolean handleFinalChoices, @Nullable InputEvent e) {
        if (this.myList.getSelectedIndex() == -1) {
            return false;
        }
        if (this.getSpeedSearch().isHoldingFilter() && this.myList.getModel().getSize() == 0) {
            return false;
        }
        if (this.myList.getSelectedIndex() == this.getIndexForShowingChild()) {
            if (this.myChild != null && !this.myChild.isVisible()) {
                this.setIndexForShowingChild(-1);
            }
            return false;
        }
        Object[] selectedValues = this.myList.getSelectedValues();
        ListPopupStep<Object> listStep = this.getListStep();
        if (!listStep.isSelectable(selectedValues[0])) {
            return false;
        }
        if ((listStep instanceof MultiSelectionListPopupStep && !((MultiSelectionListPopupStep)listStep).hasSubstep(Arrays.asList(selectedValues)) || !listStep.hasSubstep(selectedValues[0])) && !handleFinalChoices) {
            return false;
        }
        this.disposeChildren();
        if (this.myListModel.getSize() == 0) {
            this.setFinalRunnable(this.myStep.getFinalRunnable());
            this.setOk(true);
            this.disposeAllParents(e);
            this.setIndexForShowingChild(-1);
            return true;
        }
        this.valuesSelected(selectedValues);
        PopupStep nextStep = listStep instanceof MultiSelectionListPopupStep ? ((MultiSelectionListPopupStep)listStep).onChosen(Arrays.asList(selectedValues), handleFinalChoices) : (e != null && listStep instanceof ListPopupStepEx ? ((ListPopupStepEx)listStep).onChosen(selectedValues[0], handleFinalChoices, e.getModifiers()) : listStep.onChosen(selectedValues[0], handleFinalChoices));
        return this.handleNextStep(nextStep, selectedValues.length == 1 ? selectedValues[0] : null, e);
    }

    private void valuesSelected(Object[] values) {
        String filter = this.getSpeedSearch().getFilter();
        if (!StringUtil.isEmpty((String)filter)) {
            for (Object value : values) {
                String text = this.getListStep().getTextFor(value);
                StatisticsManager.getInstance().incUseCount(new StatisticsInfo("#list_popup:" + this.getListStep().getTitle() + "#" + filter, text));
            }
        }
    }

    private boolean handleNextStep(PopupStep nextStep, Object parentValue, InputEvent e) {
        if (nextStep != PopupStep.FINAL_CHOICE) {
            Point point = this.myList.indexToLocation(this.myList.getSelectedIndex());
            SwingUtilities.convertPointToScreen(point, (Component)((Object)this.myList));
            this.myChild = this.createPopup(this, nextStep, parentValue);
            if (this.myChild instanceof ListPopupImpl) {
                for (ListSelectionListener listener2 : this.myList.getListSelectionListeners()) {
                    ((ListPopupImpl)this.myChild).addListSelectionListener(listener2);
                }
            }
            JComponent container = this.getContent();
            assert (container != null) : "container == null";
            int y = point.y;
            if (parentValue != null && this.getListModel().isSeparatorAboveOf(parentValue)) {
                SeparatorWithText swt = new SeparatorWithText();
                swt.setCaption(this.getListModel().getCaptionAboveOf(parentValue));
                y += swt.getPreferredSize().height - 1;
            }
            this.myChild.show(container, point.x + container.getWidth() - 2, y, true);
            this.setIndexForShowingChild(this.myList.getSelectedIndex());
            return false;
        }
        this.setOk(true);
        this.setFinalRunnable(this.myStep.getFinalRunnable());
        this.disposeAllParents(e);
        this.setIndexForShowingChild(-1);
        return true;
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.myList.addListSelectionListener(listSelectionListener);
    }

    protected boolean isActionClick(MouseEvent e) {
        return UIUtil.isActionClick((MouseEvent)e, (int)502, (boolean)true);
    }

    public Object[] getSelectedValues() {
        return this.myList.getSelectedValues();
    }

    protected boolean handleFinalChoices(MouseEvent e, Object selectedValue, ListPopupStep<Object> listStep) {
        return selectedValue == null || !listStep.hasSubstep(selectedValue) || !listStep.isSelectable(selectedValue) || !this.isOnNextStepButton(e);
    }

    private boolean isOnNextStepButton(MouseEvent e) {
        int index = this.myList.getSelectedIndex();
        Rectangle bounds = this.myList.getCellBounds(index, index);
        Point point = e.getPoint();
        return bounds != null && point.getX() > (double)bounds.width + bounds.getX() - (double)AllIcons.Icons.Ide.NextStep.getIconWidth();
    }

    @Override
    protected void process(KeyEvent aEvent) {
        this.myList.processKeyEvent(aEvent);
    }

    private int getIndexForShowingChild() {
        return this.myIndexForShowingChild;
    }

    private void setIndexForShowingChild(int aIndexForShowingChild) {
        this.myIndexForShowingChild = aIndexForShowingChild;
    }

    @Override
    protected void onSpeedSearchPatternChanged() {
        this.myListModel.refilter();
        if (this.myListModel.getSize() > 0 && !this.autoSelectUsingStatistics()) {
            int fullMatchIndex = this.myListModel.getClosestMatchIndex();
            if (fullMatchIndex != -1) {
                this.myList.setSelectedIndex(fullMatchIndex);
            }
            if (this.myListModel.getSize() <= this.myList.getSelectedIndex() || !this.myListModel.isVisible(this.myList.getSelectedValue())) {
                this.myList.setSelectedIndex(0);
            }
        }
    }

    @Override
    protected void onSelectByMnemonic(Object value) {
        if (this.myListModel.isVisible(value)) {
            this.myList.setSelectedValue(value, true);
            this.myList.repaint();
            this.handleSelect(true);
        }
    }

    @Override
    protected JComponent getPreferredFocusableComponent() {
        return this.myList;
    }

    @Override
    protected void onChildSelectedFor(Object value) {
        if (this.myList.getSelectedValue() != value) {
            this.myList.setSelectedValue(value, false);
        }
    }

    public void setHandleAutoSelectionBeforeShow(boolean autoHandle) {
        this.myAutoHandleBeforeShow = autoHandle;
    }

    @Override
    public boolean isModalContext() {
        return true;
    }

    @Override
    public void showInBestPositionFor(@NotNull Editor editor) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.handleSelect(true);
        } else {
            super.showInBestPositionFor(editor);
        }
    }

    private class MyList
    extends JBListWithHintProvider
    implements DataProvider {
        public MyList() {
            super((ListModel)ListPopupImpl.this.myListModel);
        }

        protected PsiElement getPsiElementForHint(Object selectedValue) {
            return selectedValue instanceof PsiElement ? (PsiElement)selectedValue : null;
        }

        public Dimension getPreferredScrollableViewportSize() {
            int size;
            int rowCount = this.getVisibleRowCount();
            if (rowCount < (size = this.getModel().getSize())) {
                return super.getPreferredScrollableViewportSize();
            }
            return new Dimension(super.getPreferredScrollableViewportSize().width, this.getPreferredSize().height);
        }

        public void processKeyEvent(KeyEvent e) {
            e.setSource((Object)this);
            super.processKeyEvent(e);
        }

        protected void processMouseEvent(MouseEvent e) {
            if (!ListPopupImpl.this.isMultiSelectionEnabled() && (e.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0) {
                e.consume();
            }
            if (UIUtil.isActionClick((MouseEvent)e, (int)501) && ListPopupImpl.this.isOnNextStepButton(e)) {
                e.consume();
            }
            super.processMouseEvent(e);
        }

        public Object getData(String dataId) {
            if (PlatformDataKeys.SELECTED_ITEM.is(dataId)) {
                return ListPopupImpl.this.myList.getSelectedValue();
            }
            if (PlatformDataKeys.SELECTED_ITEMS.is(dataId)) {
                return ListPopupImpl.this.myList.getSelectedValues();
            }
            return null;
        }
    }

    private class MyMouseListener
    extends MouseAdapter {
        private MyMouseListener() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!ListPopupImpl.this.isActionClick(e) || ListPopupImpl.this.isMultiSelectionEnabled() && UIUtil.isSelectionButtonDown((MouseEvent)e)) {
                return;
            }
            IdeEventQueue.getInstance().blockNextEvents(e);
            Object selectedValue = ListPopupImpl.this.myList.getSelectedValue();
            ListPopupStep<Object> listStep = ListPopupImpl.this.getListStep();
            ListPopupImpl.this.handleSelect(ListPopupImpl.this.handleFinalChoices(e, selectedValue, listStep), e);
            ListPopupImpl.this.stopTimer();
        }
    }

    private class MyMouseMotionListener
    extends MouseMotionAdapter {
        private int myLastSelectedIndex = -2;

        private MyMouseMotionListener() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            Point point = e.getPoint();
            int index = ListPopupImpl.this.myList.locationToIndex(point);
            if (index != this.myLastSelectedIndex) {
                if (!ListPopupImpl.this.isMultiSelectionEnabled() || !UIUtil.isSelectionButtonDown((MouseEvent)e) && ListPopupImpl.this.myList.getSelectedIndices().length <= 1) {
                    ListPopupImpl.this.myList.setSelectedIndex(index);
                }
                ListPopupImpl.this.restartTimer();
                this.myLastSelectedIndex = index;
            }
            ListPopupImpl.this.notifyParentOnChildSelection();
        }
    }
}

