/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.plaf.beg;

import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.text.JTextComponent;

public class BegBorders {
    private static Border ourButtonBorder;
    private static Border ourTextFieldBorder;
    private static Border ourScrollPaneBorder;

    public static Border getButtonBorder() {
        if (ourButtonBorder == null) {
            ourButtonBorder = new BorderUIResource.CompoundBorderUIResource(new ButtonBorder(), new BasicBorders.MarginBorder());
        }
        return ourButtonBorder;
    }

    public static Border getTextFieldBorder() {
        if (ourTextFieldBorder == null) {
            ourTextFieldBorder = new BorderUIResource.CompoundBorderUIResource(new TextFieldBorder(), BorderFactory.createEmptyBorder(2, 2, 2, 2));
        }
        return ourTextFieldBorder;
    }

    public static Border getScrollPaneBorder() {
        if (ourScrollPaneBorder == null) {
            ourScrollPaneBorder = new BorderUIResource.LineBorderUIResource(MetalLookAndFeel.getControlDarkShadow());
        }
        return ourScrollPaneBorder;
    }

    static void drawLineBorder(Graphics g, int x, int y, int w, int h) {
        g.translate(x, y);
        g.setColor(MetalLookAndFeel.getControlDarkShadow());
        g.drawRect(0, 0, w - 1, h - 1);
        g.translate(-x, -y);
    }

    static void drawFlush3DBorder(Graphics g, int x, int y, int w, int h) {
        g.translate(x, y);
        g.setColor(MetalLookAndFeel.getControlHighlight());
        g.drawRect(1, 1, w - 2, h - 2);
        g.setColor(MetalLookAndFeel.getControlDarkShadow());
        g.drawRect(0, 0, w - 2, h - 2);
        g.translate(-x, -y);
    }

    static void drawDisabledBorder(Graphics g, int x, int y, int w, int h) {
        g.translate(x, y);
        g.setColor(MetalLookAndFeel.getControlShadow());
        g.drawRect(0, 0, w - 1, h - 1);
        g.translate(-x, -y);
    }

    static void drawDefaultButtonPressedBorder(Graphics g, int x, int y, int w, int h) {
        BegBorders.drawPressed3DBorder(g, x + 1, y + 1, w - 1, h - 1);
        g.translate(x, y);
        g.setColor(MetalLookAndFeel.getControlDarkShadow());
        g.drawRect(0, 0, w - 3, h - 3);
        UIUtil.drawLine((Graphics)g, (int)(w - 2), (int)0, (int)(w - 2), (int)0);
        UIUtil.drawLine((Graphics)g, (int)0, (int)(h - 2), (int)0, (int)(h - 2));
        g.translate(-x, -y);
    }

    static void drawPressed3DBorder(Graphics g, int x, int y, int w, int h) {
        g.translate(x, y);
        BegBorders.drawFlush3DBorder(g, 0, 0, w, h);
        g.setColor(MetalLookAndFeel.getControlShadow());
        UIUtil.drawLine((Graphics)g, (int)1, (int)1, (int)1, (int)(h - 1));
        UIUtil.drawLine((Graphics)g, (int)1, (int)1, (int)(w - 1), (int)1);
        g.translate(-x, -y);
    }

    static void drawDefaultButtonBorder(Graphics g, int x, int y, int w, int h, boolean active) {
        BegBorders.drawButtonBorder(g, x + 1, y + 1, w - 1, h - 1, active);
        g.translate(x, y);
        g.setColor(MetalLookAndFeel.getControlDarkShadow());
        g.drawRect(0, 0, w - 3, h - 3);
        UIUtil.drawLine((Graphics)g, (int)(w - 2), (int)0, (int)(w - 2), (int)0);
        UIUtil.drawLine((Graphics)g, (int)0, (int)(h - 2), (int)0, (int)(h - 2));
        g.translate(-x, -y);
    }

    static void drawButtonBorder(Graphics g, int x, int y, int w, int h, boolean active) {
        if (active) {
            BegBorders.drawActiveButtonBorder(g, x, y, w, h);
        } else {
            BegBorders.drawFlush3DBorder(g, x, y, w, h);
        }
    }

    static void drawActiveButtonBorder(Graphics g, int x, int y, int w, int h) {
        BegBorders.drawFlush3DBorder(g, x, y, w, h);
        g.setColor(MetalLookAndFeel.getPrimaryControl());
        UIUtil.drawLine((Graphics)g, (int)(x + 1), (int)(y + 1), (int)(x + 1), (int)(h - 3));
        UIUtil.drawLine((Graphics)g, (int)(x + 1), (int)(y + 1), (int)(w - 3), (int)(x + 1));
        g.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
        UIUtil.drawLine((Graphics)g, (int)(x + 2), (int)(h - 2), (int)(w - 2), (int)(h - 2));
        UIUtil.drawLine((Graphics)g, (int)(w - 2), (int)(y + 2), (int)(w - 2), (int)(h - 2));
    }

    public static class TextFieldBorder
    extends LineBorder
    implements UIResource {
        public TextFieldBorder() {
            super(null, 1);
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            if (!(c instanceof JTextComponent)) {
                if (c.isEnabled()) {
                    BegBorders.drawFlush3DBorder(g, x, y, w, h);
                } else {
                    BegBorders.drawDisabledBorder(g, x, y, w, h);
                }
                return;
            }
            if (c.isEnabled() && ((JTextComponent)c).isEditable()) {
                BegBorders.drawLineBorder(g, x, y, w, h);
            } else {
                BegBorders.drawDisabledBorder(g, x, y, w, h);
            }
        }
    }

    public static class ScrollPaneBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets insets = new Insets(1, 1, 2, 2);

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            JScrollPane scroll = (JScrollPane)c;
            JViewport colHeader = scroll.getColumnHeader();
            int colHeaderHeight = 0;
            if (colHeader != null) {
                colHeaderHeight = colHeader.getHeight();
            }
            JViewport rowHeader = scroll.getRowHeader();
            int rowHeaderWidth = 0;
            if (rowHeader != null) {
                rowHeaderWidth = rowHeader.getWidth();
            }
            BegBorders.drawLineBorder(g, x, y, w, h);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return (Insets)insets.clone();
        }
    }

    public static class ButtonBorder
    extends AbstractBorder
    implements UIResource {
        protected static Insets borderInsets = new Insets(3, 3, 3, 3);

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            AbstractButton button = (AbstractButton)c;
            ButtonModel model = button.getModel();
            if (model.isEnabled()) {
                boolean isDefault;
                boolean isPressed = model.isPressed() && model.isArmed();
                boolean bl = isDefault = button instanceof JButton && ((JButton)button).isDefaultButton();
                if (isPressed && isDefault) {
                    BegBorders.drawDefaultButtonPressedBorder(g, x, y, w, h);
                } else if (isPressed) {
                    BegBorders.drawPressed3DBorder(g, x, y, w, h);
                } else if (isDefault) {
                    BegBorders.drawDefaultButtonBorder(g, x, y, w, h, false);
                } else {
                    BegBorders.drawButtonBorder(g, x, y, w, h, false);
                }
            } else {
                BegBorders.drawDisabledBorder(g, x, y, w - 1, h - 1);
            }
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return (Insets)borderInsets.clone();
        }

        @Override
        public Insets getBorderInsets(Component c, Insets newInsets) {
            newInsets.top = ButtonBorder.borderInsets.top;
            newInsets.left = ButtonBorder.borderInsets.left;
            newInsets.bottom = ButtonBorder.borderInsets.bottom;
            newInsets.right = ButtonBorder.borderInsets.right;
            return newInsets;
        }
    }

    public static class FlatLineBorder
    extends LineBorder
    implements UIResource {
        public FlatLineBorder() {
            super(new Color(127, 157, 185), 1, true);
        }
    }
}

