/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.picker;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.picker.ColorListener;
import com.intellij.ui.picker.ColorPipette;
import com.intellij.util.Alarm;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Image;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Robot;
import java.awt.Window;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ColorPipetteBase
implements ColorPipette {
    private final Alarm myColorListenersNotifier = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)this);
    protected final JComponent myParent;
    private final ColorListener myColorListener;
    protected final Robot myRobot;
    private JDialog myPickerFrame;
    private Color myCurrentColor;
    private Color myInitialColor;

    public ColorPipetteBase(@NotNull JComponent parent, @NotNull ColorListener colorListener) {
        this.myParent = parent;
        this.myColorListener = colorListener;
        this.myRobot = ColorPipetteBase.createRobot();
    }

    public static boolean canUseMacPipette() {
        return SystemInfo.isMac && Registry.is((String)"ide.mac.new.color.picker");
    }

    @Override
    public void pickAndClose() {
        PointerInfo pointerInfo = MouseInfo.getPointerInfo();
        Point location = pointerInfo.getLocation();
        Color pixelColor = this.myRobot.getPixelColor(location.x, location.y);
        this.cancelPipette();
        this.notifyListener(pixelColor, 0);
        this.setInitialColor(pixelColor);
    }

    @Nullable
    protected Color getInitialColor() {
        return this.myInitialColor;
    }

    @Override
    public void setInitialColor(@Nullable Color initialColor) {
        this.myInitialColor = initialColor;
        this.setColor(initialColor);
    }

    protected void setColor(@Nullable Color color) {
        this.myCurrentColor = color;
    }

    @Override
    @Nullable
    public Color getColor() {
        return this.myCurrentColor;
    }

    @Override
    public Dialog show() {
        Dialog picker = this.getOrCreatePickerDialog();
        this.updateLocation();
        picker.setVisible(true);
        return picker;
    }

    @Nullable
    protected Point updateLocation() {
        PointerInfo pointerInfo = MouseInfo.getPointerInfo();
        if (pointerInfo == null) {
            return null;
        }
        Point mouseLoc = pointerInfo.getLocation();
        Dialog pickerDialog = this.getPickerDialog();
        if (pickerDialog != null) {
            pickerDialog.setLocation(mouseLoc.x - pickerDialog.getWidth() / 2, mouseLoc.y - pickerDialog.getHeight() / 2);
        }
        return mouseLoc;
    }

    @Nullable
    protected Dialog getPickerDialog() {
        return this.myPickerFrame;
    }

    @NotNull
    protected Dialog getOrCreatePickerDialog() {
        if (this.myPickerFrame == null) {
            Window owner = SwingUtilities.getWindowAncestor(this.myParent);
            this.myPickerFrame = owner instanceof Dialog ? new JDialog((Dialog)owner) : (owner instanceof Frame ? new JDialog((Frame)owner) : new JDialog(new JFrame()));
            this.myPickerFrame.setTitle("intellijPickerDialog");
        }
        this.myPickerFrame.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                e.consume();
                ColorPipetteBase.this.pickAndClose();
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                e.consume();
            }
        });
        this.myPickerFrame.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 27: {
                        ColorPipetteBase.this.cancelPipette();
                        break;
                    }
                    case 10: {
                        ColorPipetteBase.this.pickAndClose();
                    }
                }
            }
        });
        this.myPickerFrame.setUndecorated(true);
        this.myPickerFrame.setAlwaysOnTop(!SystemInfo.isJavaVersionAtLeast((String)"1.8.0") || ColorPipetteBase.canUseMacPipette());
        JRootPane rootPane = this.myPickerFrame.getRootPane();
        rootPane.putClientProperty("Window.shadow", Boolean.FALSE);
        return this.myPickerFrame;
    }

    protected void notifyListener(final @NotNull Color c, int delayMillis) {
        if (!this.myColorListenersNotifier.isDisposed()) {
            this.myColorListenersNotifier.cancelAllRequests();
            this.myColorListenersNotifier.addRequest(new Runnable(){

                @Override
                public void run() {
                    ColorPipetteBase.this.myColorListener.colorChanged(c, ColorPipetteBase.this);
                }
            }, delayMillis);
        }
    }

    @Override
    public boolean imageUpdate(Image image, int i, int i1, int i2, int i3, int i4) {
        return false;
    }

    @Override
    public void cancelPipette() {
        Color initialColor;
        Dialog pickerDialog = this.getPickerDialog();
        if (pickerDialog != null) {
            pickerDialog.setVisible(false);
        }
        if ((initialColor = this.getInitialColor()) != null) {
            this.notifyListener(initialColor, 0);
        }
    }

    public void dispose() {
        UIUtil.dispose((Component)this.myPickerFrame);
        this.myPickerFrame = null;
        this.setInitialColor(null);
        this.setColor(null);
    }

    @Nullable
    private static Robot createRobot() {
        try {
            return new Robot();
        }
        catch (AWTException e) {
            return null;
        }
    }
}

