/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.PlainPrefixMatcher;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TextFieldWithAutoCompletionListProvider<T>
implements Comparator<T> {
    @NotNull
    protected Collection<T> myVariants;
    @Nullable
    private String myCompletionAdvertisement;

    @Nullable
    protected abstract Icon getIcon(@NotNull T var1);

    @NotNull
    protected abstract String getLookupString(@NotNull T var1);

    @Nullable
    protected abstract String getTailText(@NotNull T var1);

    @Nullable
    protected abstract String getTypeText(@NotNull T var1);

    @Override
    public abstract int compare(T var1, T var2);

    protected TextFieldWithAutoCompletionListProvider(@Nullable Collection<T> variants) {
        this.setItems(variants);
        this.myCompletionAdvertisement = null;
    }

    public void setItems(@Nullable Collection<T> variants) {
        this.myVariants = variants != null ? variants : Collections.emptyList();
    }

    @NotNull
    public Collection<T> getItems(String prefix, boolean cached, CompletionParameters parameters) {
        if (prefix == null) {
            return Collections.emptyList();
        }
        ArrayList<T> items = new ArrayList<T>(this.myVariants);
        Collections.sort(items, this);
        return items;
    }

    @Nullable
    public String getQuickDocHotKeyAdvertisement(@NotNull String shortcut) {
        String advertisementTail = this.getQuickDocHotKeyAdvertisementTail(shortcut);
        if (advertisementTail == null) {
            return null;
        }
        return "Pressing " + shortcut + " would show " + advertisementTail;
    }

    @Nullable
    public String getAdvertisement() {
        return this.myCompletionAdvertisement;
    }

    public void setAdvertisement(@Nullable String completionAdvertisement) {
        this.myCompletionAdvertisement = completionAdvertisement;
    }

    @Nullable
    public PrefixMatcher createPrefixMatcher(@NotNull String prefix) {
        return new PlainPrefixMatcher(prefix);
    }

    public LookupElementBuilder createLookupBuilder(@NotNull T item) {
        String typeText;
        String tailText;
        LookupElementBuilder builder = LookupElementBuilder.create(item, (String)this.getLookupString(item)).withIcon(this.getIcon(item));
        InsertHandler<LookupElement> handler2 = this.createInsertHandler(item);
        if (handler2 != null) {
            builder = builder.withInsertHandler(handler2);
        }
        if ((tailText = this.getTailText(item)) != null) {
            builder = builder.withTailText(tailText, true);
        }
        if ((typeText = this.getTypeText(item)) != null) {
            builder = builder.withTypeText(typeText);
        }
        return builder;
    }

    @Nullable
    public String getPrefix(@NotNull CompletionParameters parameters) {
        return TextFieldWithAutoCompletionListProvider.getCompletionPrefix(parameters);
    }

    public static String getCompletionPrefix(CompletionParameters parameters) {
        String text = parameters.getOriginalFile().getText();
        int offset = parameters.getOffset();
        int i = text.lastIndexOf(32, offset - 1) + 1;
        int j = text.lastIndexOf(10, offset - 1) + 1;
        return text.substring(Math.max(i, j), offset);
    }

    @Nullable
    protected String getQuickDocHotKeyAdvertisementTail(@NotNull String shortcut) {
        return null;
    }

    @Nullable
    protected InsertHandler<LookupElement> createInsertHandler(@NotNull T item) {
        return null;
    }
}

