/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.find.FindManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.ui.JBColor;
import com.intellij.ui.UIBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReplacePromptDialog
extends DialogWrapper {
    private final boolean myIsMultiple;
    @Nullable
    private final FindManager.MalformedReplacementStringException myException;

    public ReplacePromptDialog(boolean isMultipleFiles, String title, Project project2) {
        this(isMultipleFiles, title, project2, null);
    }

    public ReplacePromptDialog(boolean isMultipleFiles, String title, Project project2, @Nullable FindManager.MalformedReplacementStringException exception) {
        super(project2, true);
        this.myIsMultiple = isMultipleFiles;
        this.myException = exception;
        this.setButtonsAlignment(0);
        this.setTitle(title);
        this.init();
    }

    @NotNull
    protected Action[] createActions() {
        DoAction replaceAction = new DoAction(UIBundle.message((String)"replace.prompt.replace.button", (Object[])new Object[0]), 0);
        replaceAction.putValue("DefaultAction", Boolean.TRUE);
        if (this.myException == null) {
            if (this.myIsMultiple) {
                this.setCancelButtonText(UIBundle.message((String)"replace.prompt.review.action", (Object[])new Object[0]));
                return new Action[]{replaceAction, this.createSkipAction(), new DoAction(UIBundle.message((String)"replace.prompt.all.in.this.file.button", (Object[])new Object[0]), 4), new DoAction(UIBundle.message((String)"replace.prompt.skip.all.in.file.button", (Object[])new Object[0]), 6), new DoAction(UIBundle.message((String)"replace.prompt.all.files.action", (Object[])new Object[0]), 5), this.getCancelAction()};
            }
            return new Action[]{replaceAction, this.createSkipAction(), new DoAction(UIBundle.message((String)"replace.prompt.all.button", (Object[])new Object[0]), 3), this.getCancelAction()};
        }
        return new Action[]{this.createSkipAction(), this.getCancelAction()};
    }

    private DoAction createSkipAction() {
        return new DoAction(UIBundle.message((String)"replace.prompt.skip.button", (Object[])new Object[0]), 2);
    }

    public JComponent createNorthPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        Icon icon = Messages.getQuestionIcon();
        JLabel iconLabel = new JLabel(icon);
        panel.add((Component)iconLabel, "West");
        JLabel label = new JLabel(this.getMessage());
        label.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 10));
        label.setForeground(JBColor.foreground());
        panel.add((Component)label, "Center");
        return panel;
    }

    protected String getMessage() {
        return this.myException == null ? UIBundle.message((String)"replace.prompt.replace.occurrence.label", (Object[])new Object[0]) : this.myException.getMessage();
    }

    public JComponent createCenterPanel() {
        return null;
    }

    protected String getDimensionServiceKey() {
        return "ReplaceDuplicatesPrompt";
    }

    private class DoAction
    extends AbstractAction {
        private final int myExitCode;

        public DoAction(String name, int exitCode) {
            this.putValue("Name", name);
            this.myExitCode = exitCode;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ReplacePromptDialog.this.close(this.myExitCode);
        }
    }
}

