/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.PrevNextActionsDescriptor;
import com.intellij.ui.TabbedPane;
import com.intellij.ui.tabs.JBTabs;
import com.intellij.ui.tabs.JBTabsPosition;
import com.intellij.ui.tabs.JBTabsPresentation;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.TabsListener;
import com.intellij.ui.tabs.impl.JBEditorTabs;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.event.MouseListener;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBTabsPaneImpl
implements TabbedPane,
SwingConstants {
    private final JBTabsImpl myTabs;
    private final CopyOnWriteArraySet<ChangeListener> myListeners = new CopyOnWriteArraySet();

    public JBTabsPaneImpl(@Nullable Project project2, int tabPlacement, @NotNull Disposable parent) {
        this.myTabs = new JBEditorTabs(project2, ActionManager.getInstance(), project2 == null ? null : IdeFocusManager.getInstance((Project)project2), parent){

            public boolean isAlphabeticalMode() {
                return false;
            }

            public boolean supportsCompression() {
                return false;
            }

            protected Color getEmptySpaceColor() {
                return UIUtil.getBgFillColor((Component)this.getParent());
            }

            protected void paintSelectionAndBorder(Graphics2D g2d) {
                super.paintSelectionAndBorder(g2d);
            }
        };
        this.myTabs.setFirstTabOffset(10);
        this.myTabs.addListener((TabsListener)new TabsListener.Adapter(){

            public void selectionChanged(TabInfo oldSelection, TabInfo newSelection) {
                JBTabsPaneImpl.this.fireChanged(new ChangeEvent(JBTabsPaneImpl.this.myTabs));
            }
        }).getPresentation().setPaintBorder(1, 1, 1, 1).setTabSidePaintBorder(2).setPaintFocus(UIUtil.isUnderDarcula() || UIUtil.isUnderIntelliJLaF()).setAlwaysPaintSelectedTab(UIUtil.isUnderDarcula() || UIUtil.isUnderIntelliJLaF()).setGhostsAlwaysVisible(true);
        this.setTabPlacement(tabPlacement);
    }

    private void fireChanged(ChangeEvent event) {
        for (ChangeListener each : this.myListeners) {
            each.stateChanged(event);
        }
    }

    @Override
    public JComponent getComponent() {
        return this.myTabs.getComponent();
    }

    @Override
    public void putClientProperty(Object key, Object value) {
        this.myTabs.getComponent().putClientProperty(key, value);
    }

    @Override
    public void setKeyboardNavigation(PrevNextActionsDescriptor installKeyboardNavigation) {
        this.myTabs.setNavigationActionBinding(installKeyboardNavigation.getPrevActionId(), installKeyboardNavigation.getNextActionId());
    }

    @Override
    public void addChangeListener(ChangeListener listener2) {
        this.myListeners.add(listener2);
    }

    @Override
    public int getTabCount() {
        return this.myTabs.getTabCount();
    }

    @Override
    public void insertTab(String title, Icon icon, Component c, String tip, int index) {
        assert (c instanceof JComponent);
        this.myTabs.addTab(new TabInfo((JComponent)c).setText(title).setTooltipText(tip).setIcon(icon), index);
    }

    @Override
    public void setTabPlacement(int tabPlacement) {
        JBTabsPresentation presentation = this.myTabs.getPresentation();
        switch (tabPlacement) {
            case 1: {
                presentation.setTabsPosition(JBTabsPosition.top);
                break;
            }
            case 3: {
                presentation.setTabsPosition(JBTabsPosition.bottom);
                break;
            }
            case 2: {
                presentation.setTabsPosition(JBTabsPosition.left);
                break;
            }
            case 4: {
                presentation.setTabsPosition(JBTabsPosition.right);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid tab placement code=" + tabPlacement);
            }
        }
    }

    @Override
    public void addMouseListener(MouseListener listener2) {
        this.myTabs.getComponent().addMouseListener(listener2);
    }

    @Override
    public int getSelectedIndex() {
        return this.myTabs.getIndexOf(this.myTabs.getSelectedInfo());
    }

    @Override
    public Component getSelectedComponent() {
        TabInfo selected = this.myTabs.getSelectedInfo();
        return selected != null ? selected.getComponent() : null;
    }

    @Override
    public void setSelectedIndex(int index) {
        this.myTabs.select(this.getTabAt(index), false);
    }

    @Override
    public void removeTabAt(int index) {
        this.myTabs.removeTab(this.getTabAt(index));
    }

    private TabInfo getTabAt(int index) {
        this.checkIndex(index);
        return this.myTabs.getTabAt(index);
    }

    private void checkIndex(int index) {
        if (index < 0 || index >= this.getTabCount()) {
            throw new ArrayIndexOutOfBoundsException("tabCount=" + this.getTabCount() + " index=" + index);
        }
    }

    @Override
    public void revalidate() {
        this.myTabs.getComponent().revalidate();
    }

    @Override
    public Color getForegroundAt(int index) {
        return this.getTabAt(index).getDefaultForeground();
    }

    @Override
    public void setForegroundAt(int index, Color color) {
        this.getTabAt(index).setDefaultForeground(color);
    }

    @Override
    public Component getComponentAt(int i) {
        return this.getTabAt(i).getComponent();
    }

    @Override
    public void setTitleAt(int index, String title) {
        this.getTabAt(index).setText(title);
    }

    @Override
    public void setToolTipTextAt(int index, String toolTipText) {
        this.getTabAt(index).setTooltipText(toolTipText);
    }

    @Override
    public void setComponentAt(int index, Component c) {
        this.getTabAt(index).setComponent(c);
    }

    @Override
    public void setIconAt(int index, Icon icon) {
        this.getTabAt(index).setIcon(icon);
    }

    @Override
    public void setEnabledAt(int index, boolean enabled) {
        this.getTabAt(index).setEnabled(enabled);
    }

    @Override
    public int getTabLayoutPolicy() {
        return this.myTabs.getPresentation().isSingleRow() ? 1 : 0;
    }

    @Override
    public void setTabLayoutPolicy(int policy) {
        switch (policy) {
            case 1: {
                this.myTabs.getPresentation().setSingleRow(true);
                break;
            }
            case 0: {
                this.myTabs.getPresentation().setSingleRow(false);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported tab layout policy: " + policy);
            }
        }
    }

    @Override
    public void scrollTabToVisible(int index) {
    }

    @Override
    public String getTitleAt(int i) {
        return this.getTabAt(i).getText();
    }

    @Override
    public void removeAll() {
        this.myTabs.removeAllTabs();
    }

    @Override
    public void updateUI() {
        this.myTabs.getComponent().updateUI();
    }

    @Override
    public void removeChangeListener(ChangeListener listener2) {
        this.myListeners.remove(listener2);
    }

    public JBTabs getTabs() {
        return this.myTabs;
    }

    @Override
    public boolean isDisposed() {
        return this.myTabs.isDisposed();
    }
}

