/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerAdapter;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.progress.util.ReadTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.reference.SoftReference;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.concurrency.BoundedTaskExecutor;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;

public class EditorNotificationsImpl
extends EditorNotifications {
    private static final ExtensionPointName<EditorNotifications.Provider> EXTENSION_POINT_NAME = ExtensionPointName.create((String)"com.intellij.editorNotificationProvider");
    private static final Key<WeakReference<ProgressIndicator>> CURRENT_UPDATES = Key.create((String)"CURRENT_UPDATES");
    private static final BoundedTaskExecutor ourExecutor = new SequentialTaskExecutor((Executor)PooledThreadExecutor.INSTANCE);
    private final MergingUpdateQueue myUpdateMerger;

    public EditorNotificationsImpl(Project project2) {
        super(project2);
        this.myUpdateMerger = new MergingUpdateQueue("EditorNotifications update merger", 100, true, null, (Disposable)project2);
        MessageBusConnection connection = project2.getMessageBus().connect((Disposable)project2);
        connection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerAdapter(){

            public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
                EditorNotificationsImpl.this.updateNotifications(file2);
            }
        });
        connection.subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

            public void enteredDumbMode() {
                EditorNotificationsImpl.this.updateAllNotifications();
            }

            public void exitDumbMode() {
                EditorNotificationsImpl.this.updateAllNotifications();
            }
        });
    }

    public void updateNotifications(final @NotNull VirtualFile file2) {
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                ProgressIndicator indicator = EditorNotificationsImpl.getCurrentProgress(file2);
                if (indicator != null) {
                    indicator.cancel();
                }
                file2.putUserData(CURRENT_UPDATES, null);
                if (EditorNotificationsImpl.this.myProject.isDisposed() || !file2.isValid()) {
                    return;
                }
                indicator = new ProgressIndicatorBase();
                ReadTask task = EditorNotificationsImpl.this.createTask(indicator, file2);
                if (task == null) {
                    return;
                }
                file2.putUserData(CURRENT_UPDATES, new WeakReference<ProgressIndicator>(indicator));
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    ReadTask.Continuation continuation = task.performInReadAction(indicator);
                    if (continuation != null) {
                        continuation.getAction().run();
                    }
                } else {
                    ProgressIndicatorUtils.scheduleWithWriteActionPriority(indicator, (Executor)ourExecutor, task);
                }
            }
        });
    }

    @Nullable
    private ReadTask createTask(final ProgressIndicator indicator, final @NotNull VirtualFile file2) {
        final FileEditor[] editors = FileEditorManager.getInstance((Project)this.myProject).getAllEditors(file2);
        if (editors.length == 0) {
            return null;
        }
        return new ReadTask(){

            private boolean isOutdated() {
                if (EditorNotificationsImpl.this.myProject.isDisposed() || !file2.isValid() || indicator != EditorNotificationsImpl.getCurrentProgress(file2)) {
                    return true;
                }
                for (FileEditor editor : editors) {
                    if (editor.isValid()) continue;
                    return true;
                }
                return false;
            }

            @Override
            @Nullable
            public ReadTask.Continuation performInReadAction(@NotNull ProgressIndicator indicator2) throws ProcessCanceledException {
                if (this.isOutdated()) {
                    return null;
                }
                List providers = DumbService.getInstance((Project)EditorNotificationsImpl.this.myProject).filterByDumbAwareness(EXTENSION_POINT_NAME.getExtensions((AreaInstance)EditorNotificationsImpl.this.myProject));
                final ArrayList updates = ContainerUtil.newArrayList();
                for (final FileEditor editor : editors) {
                    for (final EditorNotifications.Provider provider : providers) {
                        final JComponent component = provider.createNotificationPanel(file2, editor);
                        updates.add(new Runnable(){

                            @Override
                            public void run() {
                                EditorNotificationsImpl.this.updateNotification(editor, (Key<? extends JComponent>)provider.getKey(), component);
                            }
                        });
                    }
                }
                return new ReadTask.Continuation(new Runnable(){

                    @Override
                    public void run() {
                        if (!this.isOutdated()) {
                            file2.putUserData(CURRENT_UPDATES, null);
                            for (Runnable update : updates) {
                                update.run();
                            }
                        }
                    }
                });
            }

            @Override
            public void onCanceled(@NotNull ProgressIndicator ignored) {
                if (EditorNotificationsImpl.getCurrentProgress(file2) == indicator) {
                    EditorNotificationsImpl.this.updateNotifications(file2);
                }
            }
        };
    }

    private static ProgressIndicator getCurrentProgress(VirtualFile file2) {
        return (ProgressIndicator)SoftReference.dereference((Reference)((Reference)file2.getUserData(CURRENT_UPDATES)));
    }

    private void updateNotification(@NotNull FileEditor editor, @NotNull Key<? extends JComponent> key, @Nullable JComponent component) {
        JComponent old = (JComponent)editor.getUserData(key);
        if (old != null) {
            FileEditorManager.getInstance((Project)this.myProject).removeTopComponent(editor, old);
        }
        if (component != null) {
            FileEditorManager.getInstance((Project)this.myProject).addTopComponent(editor, component);
            Key<? extends JComponent> _key = key;
            editor.putUserData(_key, (Object)component);
        } else {
            editor.putUserData(key, null);
        }
    }

    public void updateAllNotifications() {
        this.myUpdateMerger.queue(new Update("update"){

            public void run() {
                for (VirtualFile file2 : FileEditorManager.getInstance((Project)EditorNotificationsImpl.this.myProject).getOpenFiles()) {
                    EditorNotificationsImpl.this.updateNotifications(file2);
                }
            }
        });
    }
}

