/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.CommandLineProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.io.URLUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CustomProtocolHandler {
    public static final String LINE_NUMBER_ARG_NAME = "--line";
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ui.CustomProtocolHandler");

    public boolean openLink(@NotNull URI uri) {
        LOG.info("CustomProtocolHandler.openLink");
        List<String> args = this.getOpenArgs(uri);
        return !args.isEmpty() && CommandLineProcessor.processExternalCommandLine(args, null) != null;
    }

    @NotNull
    public List<String> getOpenArgs(URI uri) {
        ArrayList<String> args = new ArrayList<String>();
        String query = uri.getQuery();
        String file2 = null;
        String line = null;
        if (query != null) {
            for (String param : query.split("&")) {
                String[] pair = param.split("=");
                String key = URLUtil.unescapePercentSequences((String)pair[0]);
                if (pair.length <= 1) continue;
                if ("file".equals(key)) {
                    file2 = URLUtil.unescapePercentSequences((String)pair[1]);
                    continue;
                }
                if (!"line".equals(key)) continue;
                line = URLUtil.unescapePercentSequences((String)pair[1]);
            }
        }
        if (file2 != null) {
            if (line != null) {
                args.add(LINE_NUMBER_ARG_NAME);
                args.add(line);
            }
            args.add(file2);
        }
        return args;
    }
}

