/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tools;

import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.tools.FilterDialog;
import com.intellij.tools.FilterInfo;
import com.intellij.tools.ToolsBundle;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ListUtil;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import java.awt.Component;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListModel;
import org.jetbrains.annotations.NotNull;

public class OutputFiltersDialog
extends DialogWrapper {
    private final DefaultListModel myFiltersModel = new DefaultListModel();
    private final JList myFiltersList = new JBList((ListModel)this.myFiltersModel);
    private boolean myModified = false;
    private FilterInfo[] myFilters;

    public OutputFiltersDialog(Component parent, FilterInfo[] filters) {
        super(parent, true);
        this.myFilters = filters;
        this.setTitle(ToolsBundle.message("tools.filters.title", new Object[0]));
        this.init();
        this.initGui();
    }

    @NotNull
    protected Action[] createActions() {
        return new Action[]{this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp("reference.settings.ide.settings.external.tools.output.filters");
    }

    private void initGui() {
        this.myFiltersList.setSelectionMode(0);
        this.myFiltersList.setCellRenderer(new ColoredListCellRenderer(){

            protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                FilterInfo info = (FilterInfo)value;
                this.append(info.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
        });
        ScrollingUtil.ensureSelectionExists((JList)this.myFiltersList);
    }

    private String suggestFilterName() {
        String prefix = ToolsBundle.message("tools.filters.name.template", new Object[0]) + " ";
        int number = 1;
        for (int i = 0; i < this.myFiltersModel.getSize(); ++i) {
            FilterInfo wrapper = (FilterInfo)this.myFiltersModel.getElementAt(i);
            String name = wrapper.getName();
            if (!name.startsWith(prefix)) continue;
            try {
                int n = Integer.valueOf(name.substring(prefix.length()).trim());
                number = Math.max(number, n + 1);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return prefix + number;
    }

    protected void doOKAction() {
        if (this.myModified) {
            this.myFilters = new FilterInfo[this.myFiltersModel.getSize()];
            for (int i = 0; i < this.myFiltersModel.getSize(); ++i) {
                this.myFilters[i] = (FilterInfo)this.myFiltersModel.get(i);
            }
        }
        super.doOKAction();
    }

    protected JComponent createCenterPanel() {
        for (FilterInfo myFilter : this.myFilters) {
            this.myFiltersModel.addElement(myFilter.createCopy());
        }
        JPanel panel = ToolbarDecorator.createDecorator((JList)this.myFiltersList).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.setName(OutputFiltersDialog.this.suggestFilterName());
                boolean wasCreated = FilterDialog.editFilter(filterInfo, OutputFiltersDialog.this.myFiltersList, ToolsBundle.message("tools.filters.add.title", new Object[0]));
                if (wasCreated) {
                    OutputFiltersDialog.this.myFiltersModel.addElement(filterInfo);
                    OutputFiltersDialog.this.setModified(true);
                }
                OutputFiltersDialog.this.myFiltersList.requestFocus();
            }
        }).setEditAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                int index = OutputFiltersDialog.this.myFiltersList.getSelectedIndex();
                FilterInfo filterInfo = (FilterInfo)OutputFiltersDialog.this.myFiltersModel.getElementAt(index);
                boolean wasEdited = FilterDialog.editFilter(filterInfo, OutputFiltersDialog.this.myFiltersList, ToolsBundle.message("tools.filters.edit.title", new Object[0]));
                if (wasEdited) {
                    OutputFiltersDialog.this.setModified(true);
                }
                OutputFiltersDialog.this.myFiltersList.requestFocus();
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                if (OutputFiltersDialog.this.myFiltersList.getSelectedIndex() >= 0) {
                    OutputFiltersDialog.this.myFiltersModel.removeElementAt(OutputFiltersDialog.this.myFiltersList.getSelectedIndex());
                    OutputFiltersDialog.this.setModified(true);
                }
                OutputFiltersDialog.this.myFiltersList.requestFocus();
            }
        }).setMoveUpAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                int movedCount = ListUtil.moveSelectedItemsUp((JList)OutputFiltersDialog.this.myFiltersList);
                if (movedCount > 0) {
                    OutputFiltersDialog.this.setModified(true);
                }
                OutputFiltersDialog.this.myFiltersList.requestFocus();
            }
        }).setMoveDownAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                int movedCount = ListUtil.moveSelectedItemsDown((JList)OutputFiltersDialog.this.myFiltersList);
                if (movedCount > 0) {
                    OutputFiltersDialog.this.setModified(true);
                }
                OutputFiltersDialog.this.myFiltersList.requestFocus();
            }
        }).createPanel();
        return panel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myFiltersList;
    }

    private void setModified(boolean modified) {
        this.myModified = modified;
    }

    public FilterInfo[] getData() {
        return this.myFilters;
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.tools.OutputFiltersDialog";
    }
}

