/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tools;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.options.SchemeProcessor;
import com.intellij.openapi.options.SchemesManager;
import com.intellij.openapi.options.SchemesManagerFactory;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tools.Tool;
import com.intellij.tools.ToolAction;
import com.intellij.tools.ToolsGroup;
import com.intellij.util.SmartList;
import gnu.trove.THashSet;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseToolManager<T extends Tool> {
    @NotNull
    private final ActionManagerEx myActionManager;
    private final SchemesManager<ToolsGroup<T>, ToolsGroup<T>> mySchemesManager;

    public BaseToolManager(@NotNull ActionManagerEx actionManagerEx, @NotNull SchemesManagerFactory factory, @NotNull String schemePath, @NotNull String presentableName) {
        this.myActionManager = actionManagerEx;
        this.mySchemesManager = factory.create(schemePath, this.createProcessor(), presentableName);
        this.mySchemesManager.loadSchemes();
        this.registerActions();
    }

    protected abstract SchemeProcessor<ToolsGroup<T>> createProcessor();

    @Nullable
    public static String convertString(String s) {
        return StringUtil.nullize((String)s, (boolean)true);
    }

    public List<T> getTools() {
        SmartList result = new SmartList();
        for (ToolsGroup group : this.mySchemesManager.getAllSchemes()) {
            result.addAll(group.getElements());
        }
        return result;
    }

    @NotNull
    public List<T> getTools(@NotNull String group) {
        ToolsGroup groupByName = (ToolsGroup)this.mySchemesManager.findSchemeByName(group);
        if (groupByName == null) {
            return Collections.emptyList();
        }
        return groupByName.getElements();
    }

    public String getGroupByActionId(String actionId) {
        for (Tool tool : this.getTools()) {
            if (!Comparing.equal((String)actionId, (String)tool.getActionId())) continue;
            return tool.getGroup();
        }
        return null;
    }

    public List<ToolsGroup<T>> getGroups() {
        return this.mySchemesManager.getAllSchemes();
    }

    public void setTools(@NotNull List<ToolsGroup<T>> tools) {
        this.mySchemesManager.setSchemes(tools);
        this.registerActions();
    }

    void registerActions() {
        this.unregisterActions();
        THashSet registeredIds = new THashSet();
        for (Tool tool : this.getTools()) {
            String actionId = tool.getActionId();
            if (!registeredIds.add(actionId)) continue;
            this.myActionManager.registerAction(actionId, (AnAction)this.createToolAction(tool));
        }
    }

    @NotNull
    protected ToolAction createToolAction(@NotNull T tool) {
        return new ToolAction((Tool)tool);
    }

    protected abstract String getActionIdPrefix();

    private void unregisterActions() {
        for (String oldId : this.myActionManager.getActionIds(this.getActionIdPrefix())) {
            this.myActionManager.unregisterAction(oldId);
        }
    }
}

