/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testIntegration.intention;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.TestFrameworks;
import com.intellij.codeInsight.intention.impl.BaseMoveInitializerToMethodAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JVMElementFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testIntegration.JavaTestFramework;
import com.intellij.testIntegration.TestFramework;
import com.intellij.testIntegration.TestIntegrationUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class MoveInitializerToSetUpMethodAction
extends BaseMoveInitializerToMethodAction {
    private static final Logger LOG = Logger.getInstance((String)("#" + MoveInitializerToSetUpMethodAction.class.getName()));

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @NotNull
    public String getText() {
        return CodeInsightBundle.message((String)"intention.move.initializer.to.set.up", (Object[])new Object[0]);
    }

    @Override
    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
        boolean isAvailable;
        boolean bl = isAvailable = super.isAvailable(project2, editor, element) && TestIntegrationUtils.isTest(element);
        if (isAvailable) {
            PsiField field = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)element, PsiField.class);
            LOG.assertTrue(field != null);
            PsiClass aClass = field.getContainingClass();
            LOG.assertTrue(aClass != null);
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project2);
            for (TestFramework framework : (TestFramework[])Extensions.getExtensions((ExtensionPointName)TestFramework.EXTENSION_NAME)) {
                if (!(framework instanceof JavaTestFramework) || !framework.isTestClass((PsiElement)aClass)) continue;
                try {
                    ((JavaTestFramework)framework).createSetUpPatternMethod((JVMElementFactory)elementFactory);
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    protected Collection<String> getUnsuitableModifiers() {
        return Arrays.asList("static", "final");
    }

    @Override
    @NotNull
    protected Collection<PsiMethod> getOrCreateMethods(@NotNull Project project2, @NotNull Editor editor, PsiFile file2, @NotNull PsiClass aClass) {
        PsiMethod setUpMethod = TestFrameworks.getInstance().findOrCreateSetUpMethod(aClass);
        return setUpMethod == null ? Collections.emptyList() : Arrays.asList(setUpMethod);
    }
}

