/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testIntegration;

import com.intellij.execution.Location;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.testIntegration.RecentTestRunner;
import com.intellij.testIntegration.TestLocator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class SelectTestStep
extends BaseListPopupStep<String> {
    private final RecentTestRunner myRunner;
    private final TestLocator myTestLocator;
    private final Map<String, Icon> myIcons;

    public SelectTestStep(List<String> urls, Map<String, Icon> icons, RecentTestRunner runner, TestLocator locator) {
        super("Debug Recent Tests", urls);
        this.myRunner = runner;
        this.myIcons = icons;
        this.myTestLocator = locator;
    }

    public Icon getIconFor(String value) {
        return this.myIcons.get(value);
    }

    @NotNull
    public String getTextFor(String value) {
        return VirtualFileManager.extractPath((String)value);
    }

    public boolean isSpeedSearchEnabled() {
        return true;
    }

    public PopupStep onChosen(String url, boolean finalChoice) {
        Location location = this.myTestLocator.getLocation(url);
        this.myRunner.run(location);
        return null;
    }
}

