/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testIntegration;

import com.intellij.execution.TestStateStorage;
import com.intellij.execution.testframework.sm.runner.states.TestStateInfo;
import com.intellij.testIntegration.RecentTestsData;
import com.intellij.testIntegration.TestLocator;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Map;

public class RecentTestsListProvider {
    private final Map<String, TestStateStorage.Record> myRecords;

    public RecentTestsListProvider(Map<String, TestStateStorage.Record> records) {
        this.myRecords = records;
    }

    public List<String> getUrlsToShowFromHistory() {
        if (this.myRecords == null) {
            return ContainerUtil.emptyList();
        }
        RecentTestsData data = new RecentTestsData();
        for (Map.Entry<String, TestStateStorage.Record> entry : this.myRecords.entrySet()) {
            String url = entry.getKey();
            TestStateStorage.Record record = entry.getValue();
            if (!TestLocator.canLocate(url)) continue;
            data.addTest(url, RecentTestsListProvider.getMagnitude(record.magnitude), record.date);
        }
        return data.getSortedTestsList();
    }

    private static TestStateInfo.Magnitude getMagnitude(int magnitude) {
        for (TestStateInfo.Magnitude m : TestStateInfo.Magnitude.values()) {
            if (m.getValue() != magnitude) continue;
            return m;
        }
        return null;
    }
}

