/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.testFramework.fixtures.TempDirTestFixture;
import com.intellij.testFramework.fixtures.impl.BaseFixture;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;

public class TempDirTestFixtureImpl
extends BaseFixture
implements TempDirTestFixture {
    private File myTempDir;

    @Override
    @NotNull
    public VirtualFile copyAll(@NotNull String dataDir, @NotNull String targetDir) {
        return this.copyAll(dataDir, targetDir, VirtualFileFilter.ALL);
    }

    @Override
    @NotNull
    public VirtualFile copyAll(final @NotNull String dataDir, final @NotNull String targetDir, final @NotNull VirtualFileFilter filter) {
        this.createTempDirectory();
        return (VirtualFile)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<VirtualFile>(){

            public VirtualFile compute() {
                try {
                    VirtualFile tempDir = LocalFileSystem.getInstance().refreshAndFindFileByPath(TempDirTestFixtureImpl.this.myTempDir.getCanonicalPath().replace(File.separatorChar, '/'));
                    Assert.assertNotNull((Object)tempDir);
                    if (targetDir.length() > 0) {
                        Assert.assertFalse((String)"nested directories not implemented", (boolean)targetDir.contains("/"));
                        VirtualFile child = tempDir.findChild(targetDir);
                        if (child == null) {
                            child = tempDir.createChildDirectory((Object)this, targetDir);
                        }
                        tempDir = child;
                    }
                    VirtualFile from = LocalFileSystem.getInstance().refreshAndFindFileByPath(dataDir);
                    Assert.assertNotNull((String)(dataDir + " not found"), (Object)from);
                    VfsUtil.copyDirectory(null, (VirtualFile)from, (VirtualFile)tempDir, (VirtualFileFilter)filter);
                    return tempDir;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @Override
    @NotNull
    public String getTempDirPath() {
        return this.createTempDirectory().getAbsolutePath();
    }

    public File createTempFile(String fileName) throws IOException {
        String prefix = StringUtil.getPackageName((String)fileName);
        if (prefix.length() < 3) {
            prefix = prefix + "___";
        }
        String suffix = "." + StringUtil.getShortName((String)fileName);
        return FileUtil.createTempFile((File)new File(this.getTempDirPath()), (String)prefix, (String)suffix, (boolean)true);
    }

    @Override
    public VirtualFile getFile(final @NotNull String path) {
        return (VirtualFile)new WriteAction<VirtualFile>(){

            protected void run(@NotNull Result<VirtualFile> result) throws IOException {
                String fullPath = TempDirTestFixtureImpl.this.myTempDir.getCanonicalPath() + '/' + path;
                VirtualFile file2 = LocalFileSystem.getInstance().refreshAndFindFileByPath(fullPath);
                result.setResult((Object)file2);
            }
        }.execute().getResultObject();
    }

    @Override
    @NotNull
    public VirtualFile createFile(@NotNull String name) {
        File file2 = new File(this.createTempDirectory(), name);
        return (VirtualFile)ApplicationManager.getApplication().runWriteAction(() -> {
            FileUtil.createIfDoesntExist((File)file2);
            return LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file2);
        });
    }

    @Override
    @NotNull
    public VirtualFile findOrCreateDir(@NotNull String name) throws IOException {
        return VfsUtil.createDirectories((String)new File(this.createTempDirectory(), name).getPath());
    }

    @Override
    @NotNull
    public VirtualFile createFile(@NotNull String name, final @NotNull String text) throws IOException {
        final VirtualFile file2 = this.createFile(name);
        new WriteAction(){

            protected void run(@NotNull Result result) throws IOException {
                VfsUtil.saveText((VirtualFile)file2, (String)text);
            }
        }.execute();
        return file2;
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.createTempDirectory();
    }

    @Override
    public void tearDown() throws Exception {
        try {
            if (this.myTempDir != null) {
                new WriteAction(){

                    protected void run(@NotNull Result result) throws IOException {
                        TempDirTestFixtureImpl.this.findOrCreateDir("").delete((Object)this);
                    }
                }.execute();
            }
        }
        finally {
            super.tearDown();
        }
    }

    protected File getTempHome() {
        return null;
    }

    @NotNull
    protected File createTempDirectory() {
        try {
            if (this.myTempDir == null) {
                File tempHome = this.getTempHome();
                this.myTempDir = tempHome == null ? FileUtil.createTempDirectory((String)"unitTest", null, (boolean)false) : FileUtil.createTempDirectory((File)tempHome, (String)"unitTest", null, (boolean)false);
            }
            return this.myTempDir;
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot create temp dir", e);
        }
    }
}

