/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures;

import com.intellij.openapi.Disposable;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.fixtures.BareTestFixture;
import com.intellij.testFramework.fixtures.IdeaTestFixtureFactory;
import org.jetbrains.annotations.NotNull;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TestName;

public abstract class BareTestFixtureTestCase {
    @Rule
    public final TestName myNameRule = new TestName();
    private BareTestFixture myFixture;

    @Before
    public final void setupFixture() throws Exception {
        this.myFixture = IdeaTestFixtureFactory.getFixtureFactory().createBareFixture();
        this.myFixture.setUp();
    }

    @After
    public final void tearDownFixture() throws Exception {
        this.myFixture.tearDown();
        this.myFixture = null;
    }

    @NotNull
    protected final String getTestName(boolean lowercaseFirstLetter) {
        return PlatformTestUtil.getTestName(this.myNameRule.getMethodName(), lowercaseFirstLetter);
    }

    @NotNull
    public final Disposable getTestRootDisposable() {
        return this.myFixture.getTestRootDisposable();
    }
}

