/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.UtilKt;
import com.intellij.util.PathUtil;
import com.intellij.util.text.StringTokenizer;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;

public class VfsTestUtil {
    public static final Key<String> TEST_DATA_FILE_PATH = Key.create((String)"TEST_DATA_FILE_PATH");

    private VfsTestUtil() {
    }

    public static VirtualFile createFile(VirtualFile root, String relativePath) {
        return VfsTestUtil.createFile(root, relativePath, "");
    }

    public static VirtualFile createFile(VirtualFile root, String relativePath, String text) {
        return VfsTestUtil.createFileOrDir(root, relativePath, text, false);
    }

    public static VirtualFile createDir(VirtualFile root, String relativePath) {
        return VfsTestUtil.createFileOrDir(root, relativePath, "", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static VirtualFile createFileOrDir(VirtualFile root, String relativePath, String text, boolean dir) {
        VirtualFile virtualFile;
        AccessToken token = WriteAction.start();
        try {
            VirtualFile file2;
            VirtualFile parent = root;
            Assert.assertNotNull((Object)parent);
            StringTokenizer parents = new StringTokenizer(PathUtil.getParentPath((String)relativePath), "/");
            while (parents.hasMoreTokens()) {
                String name = parents.nextToken();
                VirtualFile child = parent.findChild(name);
                if (child == null || !child.isValid()) {
                    child = parent.createChildDirectory(VfsTestUtil.class, name);
                }
                parent = child;
            }
            parent.getChildren();
            if (dir) {
                file2 = parent.createChildDirectory(VfsTestUtil.class, PathUtil.getFileName((String)relativePath));
            } else {
                file2 = parent.findFileByRelativePath(relativePath);
                if (file2 == null) {
                    file2 = parent.createChildData(VfsTestUtil.class, PathUtil.getFileName((String)relativePath));
                }
                VfsUtil.saveText((VirtualFile)file2, (String)text);
            }
            virtualFile = file2;
        }
        catch (Throwable throwable) {
            try {
                token.finish();
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        token.finish();
        return virtualFile;
    }

    public static void deleteFile(@NotNull VirtualFile file2) {
        UtilKt.deleteFile(file2);
    }

    public static void clearContent(final @NotNull VirtualFile file2) {
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                try {
                    VfsUtil.saveText((VirtualFile)file2, (String)"");
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public static void overwriteTestData(String filePath, String actual) {
        try {
            FileUtil.writeToFile((File)new File(filePath), (String)actual);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    @NotNull
    public static VirtualFile findFileByCaseSensitivePath(@NotNull String absolutePath) {
        String vfsPath = FileUtil.toSystemIndependentName((String)absolutePath);
        VirtualFile vFile = LocalFileSystem.getInstance().findFileByPath(vfsPath);
        Assert.assertNotNull((String)("file " + absolutePath + " not found"), (Object)vFile);
        String realVfsPath = vFile.getPath();
        if (!SystemInfo.isFileSystemCaseSensitive && !vfsPath.equals(realVfsPath) && vfsPath.equalsIgnoreCase(realVfsPath)) {
            Assert.fail((String)("Please correct case-sensitivity of path to prevent test failure on case-sensitive file systems:\n     path " + vfsPath + "\n" + "real path " + realVfsPath));
        }
        return vFile;
    }

    public static void assertFilePathEndsWithCaseSensitivePath(@NotNull VirtualFile file2, @NotNull String suffixPath) {
        String vfsSuffixPath = FileUtil.toSystemIndependentName((String)suffixPath);
        String vfsPath = file2.getPath();
        if (!SystemInfo.isFileSystemCaseSensitive && !vfsPath.endsWith(vfsSuffixPath) && StringUtil.endsWithIgnoreCase((String)vfsPath, (String)vfsSuffixPath)) {
            String realSuffixPath = vfsPath.substring(vfsPath.length() - vfsSuffixPath.length());
            Assert.fail((String)("Please correct case-sensitivity of path to prevent test failure on case-sensitive file systems:\n     path " + suffixPath + "\n" + "real path " + realSuffixPath));
        }
    }
}

