/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.PlatformTestCase;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TempFiles {
    private final Collection<File> myFilesToDelete;

    public TempFiles(@NotNull Collection<File> filesToDelete) {
        this.myFilesToDelete = filesToDelete;
    }

    @Nullable
    public VirtualFile createVFile(@NotNull String prefix) {
        return TempFiles.getVFileByFile(this.createTempFile(prefix));
    }

    @Nullable
    public VirtualFile createVFile(@NotNull String prefix, String postfix) {
        return TempFiles.getVFileByFile(this.createTempFile(prefix, postfix));
    }

    @NotNull
    public File createTempFile(@NotNull String prefix) {
        return this.createTempFile(prefix, null);
    }

    @NotNull
    public File createTempFile(@NotNull String prefix, String suffix) {
        try {
            File tempFile2 = FileUtil.createTempFile((String)prefix, (String)suffix);
            this.tempFileCreated(tempFile2);
            TempFiles.getVFileByFile(tempFile2);
            return tempFile2;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void tempFileCreated(@NotNull File tempFile2) {
        this.myFilesToDelete.add(tempFile2);
    }

    @Nullable
    public static VirtualFile getVFileByFile(@NotNull File tempFile2) {
        return LocalFileSystem.getInstance().refreshAndFindFileByIoFile(tempFile2);
    }

    @NotNull
    public File createTempDir() {
        return this.createTempDir("dir");
    }

    @NotNull
    private File createTempDir(@NotNull String prefix) {
        try {
            File dir = FileUtil.createTempDirectory((String)prefix, (String)"test", (boolean)false);
            this.tempFileCreated(dir);
            PlatformTestCase.synchronizeTempDirVfs(TempFiles.getVFileByFile(dir));
            return dir;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    public VirtualFile createTempVDir() {
        return this.createTempVDir("dir");
    }

    @Nullable
    public VirtualFile createTempVDir(@NotNull String prefix) {
        return TempFiles.getVFileByFile(this.createTempDir(prefix));
    }

    public void deleteAll() {
        for (File file2 : this.myFilesToDelete) {
            if (FileUtil.delete((File)file2)) continue;
            file2.deleteOnExit();
        }
    }

    public VirtualFile createVFile(final @NotNull VirtualFile parentDir, final @NotNull String name, final @NotNull String text) {
        return (VirtualFile)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<VirtualFile>(){

            public VirtualFile compute() {
                try {
                    VirtualFile virtualFile = parentDir.createChildData((Object)this, name);
                    VfsUtil.saveText((VirtualFile)virtualFile, (String)(text + "\n"));
                    return virtualFile;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }
}

