/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.concurrency.JobSchedulerImpl;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.idea.Bombed;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.ex.temp.TempFileSystem;
import com.intellij.testFramework.PlatformTestCase;
import com.intellij.testFramework.SkipInHeadlessEnvironment;
import com.intellij.testFramework.SkipSlowTestLocally;
import com.intellij.testFramework.TeamCityLogger;
import com.intellij.testFramework.Timings;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.GCUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.HashMap;
import com.intellij.util.io.ZipUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.event.InvocationEvent;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import javax.swing.JTree;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import junit.framework.AssertionFailedError;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

public class PlatformTestUtil {
    public static final boolean COVERAGE_ENABLED_BUILD = "true".equals(System.getProperty("idea.coverage.enabled.build"));
    private static final boolean SKIP_HEADLESS = GraphicsEnvironment.isHeadless();
    private static final boolean SKIP_SLOW = Boolean.getBoolean("skip.slow.tests.locally");
    private static final OutputStream NULL = new OutputStream(){

        @Override
        public void write(int b) throws IOException {
        }
    };

    @NotNull
    public static String getTestName(@NotNull String name, boolean lowercaseFirstLetter) {
        return StringUtil.isEmpty((String)(name = StringUtil.trimStart((String)name, (String)"test"))) ? "" : PlatformTestUtil.lowercaseFirstLetter(name, lowercaseFirstLetter);
    }

    @NotNull
    public static String lowercaseFirstLetter(@NotNull String name, boolean lowercaseFirstLetter) {
        if (lowercaseFirstLetter && !PlatformTestUtil.isAllUppercaseName(name)) {
            name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
        }
        return name;
    }

    public static boolean isAllUppercaseName(@NotNull String name) {
        int uppercaseChars = 0;
        for (int i = 0; i < name.length(); ++i) {
            if (Character.isLowerCase(name.charAt(i))) {
                return false;
            }
            if (!Character.isUpperCase(name.charAt(i))) continue;
            ++uppercaseChars;
        }
        return uppercaseChars >= 3;
    }

    public static <T> void registerExtension(@NotNull ExtensionPointName<T> name, @NotNull T t, @NotNull Disposable parentDisposable) {
        PlatformTestUtil.registerExtension(Extensions.getRootArea(), name, t, parentDisposable);
    }

    public static <T> void registerExtension(@NotNull ExtensionsArea area, @NotNull ExtensionPointName<T> name, final @NotNull T t, @NotNull Disposable parentDisposable) {
        final ExtensionPoint extensionPoint = area.getExtensionPoint(name.getName());
        extensionPoint.registerExtension(t);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                extensionPoint.unregisterExtension(t);
            }
        });
    }

    @Nullable
    protected static String toString(@Nullable Object node, @Nullable Queryable.PrintInfo printInfo) {
        if (node instanceof AbstractTreeNode) {
            if (printInfo != null) {
                return ((AbstractTreeNode)node).toTestString(printInfo);
            }
            String presentation = ((AbstractTreeNode)node).getTestPresentation();
            return presentation;
        }
        if (node == null) {
            return "NULL";
        }
        return node.toString();
    }

    public static String print(JTree tree, boolean withSelection) {
        return PlatformTestUtil.print(tree, tree.getModel().getRoot(), withSelection, null, null);
    }

    public static String print(JTree tree, Object root, @Nullable Queryable.PrintInfo printInfo, boolean withSelection) {
        return PlatformTestUtil.print(tree, root, withSelection, printInfo, null);
    }

    public static String print(JTree tree, boolean withSelection, @Nullable Condition<String> nodePrintCondition) {
        return PlatformTestUtil.print(tree, tree.getModel().getRoot(), withSelection, null, nodePrintCondition);
    }

    public static String print(JTree tree, Object root, boolean withSelection, @Nullable Queryable.PrintInfo printInfo, @Nullable Condition<String> nodePrintCondition) {
        StringBuilder buffer = new StringBuilder();
        Collection<String> strings = PlatformTestUtil.printAsList(tree, root, withSelection, printInfo, nodePrintCondition);
        for (String string : strings) {
            buffer.append(string).append("\n");
        }
        return buffer.toString();
    }

    public static Collection<String> printAsList(JTree tree, boolean withSelection, @Nullable Condition<String> nodePrintCondition) {
        return PlatformTestUtil.printAsList(tree, tree.getModel().getRoot(), withSelection, null, nodePrintCondition);
    }

    private static Collection<String> printAsList(JTree tree, Object root, boolean withSelection, @Nullable Queryable.PrintInfo printInfo, Condition<String> nodePrintCondition) {
        ArrayList<String> strings = new ArrayList<String>();
        PlatformTestUtil.printImpl(tree, root, strings, 0, withSelection, printInfo, nodePrintCondition);
        return strings;
    }

    private static void printImpl(JTree tree, Object root, Collection<String> strings, int level, boolean withSelection, @Nullable Queryable.PrintInfo printInfo, @Nullable Condition<String> nodePrintCondition) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)root;
        Object userObject = defaultMutableTreeNode.getUserObject();
        String nodeText = userObject != null ? PlatformTestUtil.toString(userObject, printInfo) : "null";
        if (nodePrintCondition != null && !nodePrintCondition.value((Object)nodeText)) {
            return;
        }
        StringBuilder buff = new StringBuilder();
        StringUtil.repeatSymbol((Appendable)buff, (char)' ', (int)level);
        boolean expanded = tree.isExpanded(new TreePath(defaultMutableTreeNode.getPath()));
        if (!defaultMutableTreeNode.isLeaf()) {
            buff.append(expanded ? "-" : "+");
        }
        boolean selected = tree.getSelectionModel().isPathSelected(new TreePath(defaultMutableTreeNode.getPath()));
        if (withSelection && selected) {
            buff.append("[");
        }
        buff.append(nodeText);
        if (withSelection && selected) {
            buff.append("]");
        }
        strings.add(buff.toString());
        int childCount = tree.getModel().getChildCount(root);
        if (expanded) {
            for (int i = 0; i < childCount; ++i) {
                PlatformTestUtil.printImpl(tree, tree.getModel().getChild(root, i), strings, level + 1, withSelection, printInfo, nodePrintCondition);
            }
        }
    }

    public static void assertTreeEqual(JTree tree, @NonNls String expected) {
        PlatformTestUtil.assertTreeEqual(tree, expected, false);
    }

    public static void assertTreeEqualIgnoringNodesOrder(JTree tree, @NonNls String expected) {
        PlatformTestUtil.assertTreeEqualIgnoringNodesOrder(tree, expected, false);
    }

    public static void assertTreeEqual(JTree tree, String expected, boolean checkSelected) {
        String treeStringPresentation = PlatformTestUtil.print(tree, checkSelected);
        Assert.assertEquals((Object)expected, (Object)treeStringPresentation);
    }

    public static void assertTreeEqualIgnoringNodesOrder(JTree tree, String expected, boolean checkSelected) {
        Collection<String> actualNodesPresentation = PlatformTestUtil.printAsList(tree, checkSelected, null);
        List expectedNodes = StringUtil.split((String)expected, (String)"\n");
        UsefulTestCase.assertSameElements(actualNodesPresentation, expectedNodes);
    }

    public static void waitForAlarm(final int delay) throws InterruptedException {
        assert (!ApplicationManager.getApplication().isWriteAccessAllowed()) : "It's a bad idea to wait for an alarm under the write action. Somebody creates an alarm which requires read action and you are deadlocked.";
        assert (ApplicationManager.getApplication().isDispatchThread());
        final AtomicBoolean invoked = new AtomicBoolean();
        final Alarm alarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
        alarm.addRequest(new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        alarm.addRequest(new Runnable(){

                            @Override
                            public void run() {
                                invoked.set(true);
                            }
                        }, delay);
                    }
                });
            }
        }, delay);
        UIUtil.dispatchAllInvocationEvents();
        boolean sleptAlready = false;
        while (!invoked.get()) {
            UIUtil.dispatchAllInvocationEvents();
            Thread.sleep(sleptAlready ? 10L : (long)delay);
            sleptAlready = true;
        }
        UIUtil.dispatchAllInvocationEvents();
    }

    public static void dispatchAllInvocationEventsInIdeEventQueue() throws InterruptedException {
        AWTEvent event;
        assert (SwingUtilities.isEventDispatchThread()) : Thread.currentThread();
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        while ((event = eventQueue.peekEvent()) != null) {
            AWTEvent event1 = eventQueue.getNextEvent();
            if (!(event1 instanceof InvocationEvent)) continue;
            IdeEventQueue.getInstance().dispatchEvent(event1);
        }
    }

    private static Date raidDate(Bombed bombed) {
        Calendar instance = Calendar.getInstance();
        instance.set(1, bombed.year());
        instance.set(2, bombed.month());
        instance.set(5, bombed.day());
        instance.set(11, bombed.time());
        instance.set(12, 0);
        return instance.getTime();
    }

    public static boolean bombExplodes(Bombed bombedAnnotation) {
        Date now = new Date();
        return now.after(PlatformTestUtil.raidDate(bombedAnnotation));
    }

    public static StringBuilder print(AbstractTreeStructure structure, Object node, int currentLevel, @Nullable Comparator comparator2, int maxRowCount, char paddingChar, @Nullable Queryable.PrintInfo printInfo) {
        StringBuilder buffer = new StringBuilder();
        PlatformTestUtil.doPrint(buffer, currentLevel, node, structure, comparator2, maxRowCount, 0, paddingChar, printInfo);
        return buffer;
    }

    private static int doPrint(StringBuilder buffer, int currentLevel, Object node, AbstractTreeStructure structure, @Nullable Comparator comparator2, int maxRowCount, int currentLine, char paddingChar, @Nullable Queryable.PrintInfo printInfo) {
        if (currentLine >= maxRowCount && maxRowCount != -1) {
            return currentLine;
        }
        StringUtil.repeatSymbol((Appendable)buffer, (char)paddingChar, (int)currentLevel);
        buffer.append(PlatformTestUtil.toString(node, printInfo)).append("\n");
        ++currentLine;
        Object[] children2 = structure.getChildElements(node);
        if (comparator2 != null) {
            ArrayList<Object> list = new ArrayList<Object>(Arrays.asList(children2));
            Comparator c = comparator2;
            Collections.sort(list, c);
            children2 = ArrayUtil.toObjectArray(list);
        }
        for (Object child : children2) {
            currentLine = PlatformTestUtil.doPrint(buffer, currentLevel + 1, child, structure, comparator2, maxRowCount, currentLine, paddingChar, printInfo);
        }
        return currentLine;
    }

    public static String print(Object[] objects) {
        return PlatformTestUtil.print(Arrays.asList(objects));
    }

    public static String print(Collection c) {
        StringBuilder result = new StringBuilder();
        Iterator iterator = c.iterator();
        while (iterator.hasNext()) {
            Object each = iterator.next();
            result.append(PlatformTestUtil.toString(each, null));
            if (!iterator.hasNext()) continue;
            result.append("\n");
        }
        return result.toString();
    }

    public static String print(ListModel model) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < model.getSize(); ++i) {
            result.append(PlatformTestUtil.toString(model.getElementAt(i), null));
            result.append("\n");
        }
        return result.toString();
    }

    public static String print(JTree tree) {
        return PlatformTestUtil.print(tree, false);
    }

    public static void assertTreeStructureEquals(AbstractTreeStructure treeStructure, String expected) {
        Assert.assertEquals((Object)expected, (Object)PlatformTestUtil.print(treeStructure, treeStructure.getRootElement(), 0, null, -1, ' ', null).toString());
    }

    public static void invokeNamedAction(String actionId) {
        AnAction action = ActionManager.getInstance().getAction(actionId);
        Assert.assertNotNull((Object)action);
        Presentation presentation = new Presentation();
        DataContext context = DataManager.getInstance().getDataContext();
        AnActionEvent event = AnActionEvent.createFromAnAction((AnAction)action, null, (String)"", (DataContext)context);
        action.update(event);
        Assert.assertTrue((boolean)presentation.isEnabled());
        action.actionPerformed(event);
    }

    public static void assertTiming(String message, long expectedMs, long actual) {
        if (COVERAGE_ENABLED_BUILD) {
            return;
        }
        long expectedOnMyMachine = Math.max(1L, expectedMs * Timings.MACHINE_TIMING / 438L);
        String logMessage = message;
        if (actual > expectedOnMyMachine) {
            int percentage = (int)(100.0 * (double)(actual - expectedOnMyMachine) / (double)expectedOnMyMachine);
            logMessage = logMessage + ". Operation took " + percentage + "% longer than expected";
        }
        logMessage = logMessage + ". Expected on my machine: " + expectedOnMyMachine + "." + " Actual: " + actual + "." + " Expected on Standard machine: " + expectedMs + ";" + " Actual on Standard: " + actual * 438L / Timings.MACHINE_TIMING + ";" + " Timings: CPU=" + Timings.CPU_TIMING + ", I/O=" + Timings.IO_TIMING + "." + " (" + (int)((double)Timings.MACHINE_TIMING * 1.0 / 438.0 * 100.0) + "% of the Standard)" + ".";
        double acceptableChangeFactor = 1.1;
        if (actual < expectedOnMyMachine) {
            System.out.println(logMessage);
            TeamCityLogger.info(logMessage);
        } else if ((double)actual < (double)expectedOnMyMachine * 1.1) {
            TeamCityLogger.warning(logMessage, null);
        } else {
            throw new AssertionFailedError(logMessage);
        }
    }

    @Contract(pure=true)
    public static TestInfo startPerformanceTest(@NonNls @NotNull String message, int expectedMs, @NotNull ThrowableRunnable test) {
        return new TestInfo(test, expectedMs, message);
    }

    public static boolean canRunTest(@NotNull Class testCaseClass) {
        if (!SKIP_SLOW && !SKIP_HEADLESS) {
            return true;
        }
        for (Class clazz = testCaseClass; clazz != null; clazz = clazz.getSuperclass()) {
            if (SKIP_HEADLESS && clazz.getAnnotation(SkipInHeadlessEnvironment.class) != null) {
                System.out.println("Class '" + testCaseClass.getName() + "' is skipped because it requires working UI environment");
                return false;
            }
            if (!SKIP_SLOW || clazz.getAnnotation(SkipSlowTestLocally.class) == null) continue;
            System.out.println("Class '" + testCaseClass.getName() + "' is skipped because it is dog slow");
            return false;
        }
        return true;
    }

    public static void assertPathsEqual(@Nullable String expected, @Nullable String actual) {
        if (expected != null) {
            expected = FileUtil.toSystemIndependentName((String)expected);
        }
        if (actual != null) {
            actual = FileUtil.toSystemIndependentName((String)actual);
        }
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @NotNull
    public static String getRtJarPath() {
        String home = System.getProperty("java.home");
        return SystemInfo.isAppleJvm ? FileUtil.toCanonicalPath((String)(home + "/../Classes/classes.jar")) : home + "/lib/rt.jar";
    }

    public static void saveProject(Project project2) {
        ApplicationEx application = ApplicationManagerEx.getApplicationEx();
        boolean oldValue = application.isDoNotSave();
        try {
            application.doNotSave(false);
            project2.save();
        }
        finally {
            application.doNotSave(oldValue);
        }
    }

    public static void assertTiming(String message, long expected, @NotNull Runnable actionToMeasure) {
        PlatformTestUtil.assertTiming(message, expected, 4, actionToMeasure);
    }

    public static long measure(@NotNull Runnable actionToMeasure) {
        long start = System.currentTimeMillis();
        actionToMeasure.run();
        long finish = System.currentTimeMillis();
        return finish - start;
    }

    public static void assertTiming(String message, long expected, int attempts, @NotNull Runnable actionToMeasure) {
        while (true) {
            --attempts;
            long duration = PlatformTestUtil.measure(actionToMeasure);
            try {
                PlatformTestUtil.assertTiming(message, expected, duration);
            }
            catch (AssertionFailedError e) {
                if (attempts == 0) {
                    throw e;
                }
                System.gc();
                System.gc();
                System.gc();
                String s = "Another epic fail (remaining attempts: " + attempts + "): " + e.getMessage();
                TeamCityLogger.warning(s, null);
                System.err.println(s);
                continue;
            }
            break;
        }
    }

    private static HashMap<String, VirtualFile> buildNameToFileMap(VirtualFile[] files, @Nullable VirtualFileFilter filter) {
        HashMap map = new HashMap();
        for (VirtualFile file2 : files) {
            if (filter != null && !filter.accept(file2)) continue;
            map.put((Object)file2.getName(), (Object)file2);
        }
        return map;
    }

    public static void assertDirectoriesEqual(VirtualFile dirAfter, VirtualFile dirBefore) throws IOException {
        PlatformTestUtil.assertDirectoriesEqual(dirAfter, dirBefore, null);
    }

    public static void assertDirectoriesEqual(VirtualFile dirAfter, VirtualFile dirBefore, @Nullable VirtualFileFilter fileFilter) throws IOException {
        FileDocumentManager.getInstance().saveAllDocuments();
        VirtualFile[] childrenAfter = dirAfter.getChildren();
        if (dirAfter.isInLocalFileSystem() && dirAfter.getFileSystem() != TempFileSystem.getInstance()) {
            File[] ioAfter = new File(dirAfter.getPath()).listFiles();
            PlatformTestUtil.shallowCompare(childrenAfter, ioAfter);
        }
        VirtualFile[] childrenBefore = dirBefore.getChildren();
        if (dirBefore.isInLocalFileSystem() && dirBefore.getFileSystem() != TempFileSystem.getInstance()) {
            File[] ioBefore = new File(dirBefore.getPath()).listFiles();
            PlatformTestUtil.shallowCompare(childrenBefore, ioBefore);
        }
        HashMap<String, VirtualFile> mapAfter = PlatformTestUtil.buildNameToFileMap(childrenAfter, fileFilter);
        HashMap<String, VirtualFile> mapBefore = PlatformTestUtil.buildNameToFileMap(childrenBefore, fileFilter);
        Set keySetAfter = mapAfter.keySet();
        Set keySetBefore = mapBefore.keySet();
        Assert.assertEquals((String)dirAfter.getPath(), (Object)keySetAfter, (Object)keySetBefore);
        for (String name : keySetAfter) {
            VirtualFile fileAfter = (VirtualFile)mapAfter.get((Object)name);
            VirtualFile fileBefore = (VirtualFile)mapBefore.get((Object)name);
            if (fileAfter.isDirectory()) {
                PlatformTestUtil.assertDirectoriesEqual(fileAfter, fileBefore, fileFilter);
                continue;
            }
            PlatformTestUtil.assertFilesEqual(fileAfter, fileBefore);
        }
    }

    private static void shallowCompare(VirtualFile[] vfs, @Nullable File[] io) {
        ArrayList<String> vfsPaths = new ArrayList<String>();
        for (VirtualFile file2 : vfs) {
            vfsPaths.add(file2.getPath());
        }
        ArrayList<String> ioPaths = new ArrayList<String>();
        if (io != null) {
            for (File file3 : io) {
                ioPaths.add(file3.getPath().replace(File.separatorChar, '/'));
            }
        }
        Assert.assertEquals((Object)PlatformTestUtil.sortAndJoin(vfsPaths), (Object)PlatformTestUtil.sortAndJoin(ioPaths));
    }

    private static String sortAndJoin(List<String> strings) {
        Collections.sort(strings);
        StringBuilder buf = new StringBuilder();
        for (String string : strings) {
            buf.append(string);
            buf.append('\n');
        }
        return buf.toString();
    }

    public static void assertFilesEqual(VirtualFile fileAfter, VirtualFile fileBefore) throws IOException {
        try {
            PlatformTestUtil.assertJarFilesEqual(VfsUtilCore.virtualToIoFile((VirtualFile)fileAfter), VfsUtilCore.virtualToIoFile((VirtualFile)fileBefore));
        }
        catch (IOException e) {
            String textA;
            boolean canLoadAfterText;
            boolean canLoadBeforeText;
            FileDocumentManager manager = FileDocumentManager.getInstance();
            Document docBefore = manager.getDocument(fileBefore);
            boolean bl = canLoadBeforeText = !fileBefore.getFileType().isBinary() || fileBefore.getFileType() == FileTypes.UNKNOWN;
            String textB = docBefore != null ? docBefore.getText() : (!canLoadBeforeText ? null : LoadTextUtil.getTextByBinaryPresentation(fileBefore.contentsToByteArray(false), fileBefore).toString());
            Document docAfter = manager.getDocument(fileAfter);
            boolean bl2 = canLoadAfterText = !fileBefore.getFileType().isBinary() || fileBefore.getFileType() == FileTypes.UNKNOWN;
            String string = docAfter != null ? docAfter.getText() : (textA = !canLoadAfterText ? null : LoadTextUtil.getTextByBinaryPresentation(fileAfter.contentsToByteArray(false), fileAfter).toString());
            if (textA != null && textB != null) {
                Assert.assertEquals((String)fileAfter.getPath(), (Object)textA, (Object)textB);
            }
            Assert.assertArrayEquals((String)fileAfter.getPath(), (byte[])fileAfter.contentsToByteArray(), (byte[])fileBefore.contentsToByteArray());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assertJarFilesEqual(File file1, File file2) throws IOException {
        File tempDirectory2;
        File tempDirectory1;
        try (JarFile jarFile1 = new JarFile(file1);
             JarFile jarFile2 = new JarFile(file2);){
            tempDirectory1 = PlatformTestCase.createTempDir("tmp1");
            tempDirectory2 = PlatformTestCase.createTempDir("tmp2");
            ZipUtil.extract((ZipFile)jarFile1, (File)tempDirectory1, null);
            ZipUtil.extract((ZipFile)jarFile2, (File)tempDirectory2, null);
        }
        final VirtualFile dirAfter = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(tempDirectory1);
        Assert.assertNotNull((String)tempDirectory1.toString(), (Object)dirAfter);
        final VirtualFile dirBefore = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(tempDirectory2);
        Assert.assertNotNull((String)tempDirectory2.toString(), (Object)dirBefore);
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                dirAfter.refresh(false, true);
                dirBefore.refresh(false, true);
            }
        });
        PlatformTestUtil.assertDirectoriesEqual(dirAfter, dirBefore);
    }

    public static void assertElementsEqual(Element expected, Element actual) throws IOException {
        if (!JDOMUtil.areElementsEqual((Element)expected, (Element)actual)) {
            Assert.assertEquals((Object)PlatformTestUtil.printElement(expected), (Object)PlatformTestUtil.printElement(actual));
        }
    }

    public static void assertElementEquals(String expected, Element actual) {
        try {
            PlatformTestUtil.assertElementsEqual(JDOMUtil.loadDocument((CharSequence)expected).getRootElement(), actual);
        }
        catch (IOException | JDOMException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static String printElement(Element element) throws IOException {
        StringWriter writer = new StringWriter();
        JDOMUtil.writeElement((Element)element, (Writer)writer, (String)"\n");
        return writer.getBuffer().toString();
    }

    public static String getCommunityPath() {
        String homePath = PathManager.getHomePath();
        if (new File(homePath, "community/.idea").isDirectory()) {
            return homePath + File.separatorChar + "community";
        }
        return homePath;
    }

    public static String getPlatformTestDataPath() {
        return PlatformTestUtil.getCommunityPath().replace(File.separatorChar, '/') + "/platform/platform-tests/testData/";
    }

    public static Comparator<AbstractTreeNode> createComparator(final Queryable.PrintInfo printInfo) {
        return new Comparator<AbstractTreeNode>(){

            @Override
            public int compare(AbstractTreeNode o1, AbstractTreeNode o2) {
                String displayText1 = o1.toTestString(printInfo);
                String displayText2 = o2.toTestString(printInfo);
                return Comparing.compare((Comparable)((Object)displayText1), (Comparable)((Object)displayText2));
            }
        };
    }

    @NotNull
    public static <T> T notNull(@Nullable T t) {
        Assert.assertNotNull(t);
        return t;
    }

    @NotNull
    public static String loadFileText(@NotNull String fileName) throws IOException {
        return StringUtil.convertLineSeparators((String)FileUtil.loadFile((File)new File(fileName)));
    }

    public static void tryGcSoftlyReachableObjects() {
        GCUtil.tryGcSoftlyReachableObjects();
    }

    public static void withEncoding(@NotNull String encoding, final @NotNull Runnable r) {
        PlatformTestUtil.withEncoding(encoding, new ThrowableRunnable(){

            public void run() throws Throwable {
                r.run();
            }
        });
    }

    public static void withEncoding(@NotNull String encoding, @NotNull ThrowableRunnable r) {
        Charset oldCharset = Charset.defaultCharset();
        try {
            try {
                PlatformTestUtil.patchSystemFileEncoding(encoding);
                r.run();
            }
            finally {
                PlatformTestUtil.patchSystemFileEncoding(oldCharset.name());
            }
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private static void patchSystemFileEncoding(String encoding) {
        ReflectionUtil.resetField(Charset.class, Charset.class, (String)"defaultCharset");
        System.setProperty("file.encoding", encoding);
    }

    public static void withStdErrSuppressed(@NotNull Runnable r) {
        PrintStream std = System.err;
        System.setErr(new PrintStream(NULL));
        try {
            r.run();
        }
        finally {
            System.setErr(std);
        }
    }

    public static void assertSuccessful(@NotNull GeneralCommandLine command) {
        try {
            ProcessOutput output = ExecUtil.execAndGetOutput((GeneralCommandLine)command.withRedirectErrorStream(true));
            Assert.assertEquals((String)output.getStdout(), (long)0L, (long)output.getExitCode());
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public static class TestInfo {
        private final ThrowableRunnable test;
        private final int expectedMs;
        private ThrowableRunnable setup;
        private boolean usesAllCPUCores;
        private int attempts = 4;
        private final String message;
        private boolean adjustForIO = true;
        private boolean adjustForCPU = true;
        private boolean useLegacyScaling;

        private TestInfo(@NotNull ThrowableRunnable test, int expectedMs, String message) {
            this.test = test;
            this.expectedMs = expectedMs;
            assert (expectedMs > 0) : "Expected must be > 0. Was: " + expectedMs;
            this.message = message;
        }

        @Contract(pure=true)
        public TestInfo setup(@NotNull ThrowableRunnable setup) {
            assert (this.setup == null);
            this.setup = setup;
            return this;
        }

        @Contract(pure=true)
        public TestInfo usesAllCPUCores() {
            assert (this.adjustForCPU) : "This test configured to be io-bound, it cannot use all cores";
            this.usesAllCPUCores = true;
            return this;
        }

        @Contract(pure=true)
        public TestInfo cpuBound() {
            this.adjustForIO = false;
            this.adjustForCPU = true;
            return this;
        }

        @Contract(pure=true)
        public TestInfo ioBound() {
            this.adjustForIO = true;
            this.adjustForCPU = false;
            return this;
        }

        @Contract(pure=true)
        public TestInfo attempts(int attempts) {
            this.attempts = attempts;
            return this;
        }

        @Contract(pure=true)
        public TestInfo useLegacyScaling() {
            this.useLegacyScaling = true;
            return this;
        }

        public void assertTiming() {
            assert (this.expectedMs != 0) : "Must call .expect() before run test";
            if (COVERAGE_ENABLED_BUILD) {
                return;
            }
            Timings.getStatistics();
            while (true) {
                long start;
                --this.attempts;
                try {
                    if (this.setup != null) {
                        this.setup.run();
                    }
                    start = System.currentTimeMillis();
                    this.test.run();
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable);
                }
                long finish = System.currentTimeMillis();
                long duration = finish - start;
                int expectedOnMyMachine = this.expectedMs;
                if (this.adjustForCPU) {
                    expectedOnMyMachine = TestInfo.adjust(expectedOnMyMachine, Timings.CPU_TIMING, 200L, this.useLegacyScaling);
                    int n = expectedOnMyMachine = this.usesAllCPUCores ? expectedOnMyMachine * 8 / JobSchedulerImpl.CORES_COUNT : expectedOnMyMachine;
                }
                if (this.adjustForIO) {
                    expectedOnMyMachine = TestInfo.adjust(expectedOnMyMachine, Timings.IO_TIMING, 100L, this.useLegacyScaling);
                }
                String logMessage = this.message;
                if (duration > (long)expectedOnMyMachine) {
                    int percentage = (int)(100.0 * (double)(duration - (long)expectedOnMyMachine) / (double)expectedOnMyMachine);
                    logMessage = logMessage + ": " + percentage + "% longer";
                }
                logMessage = logMessage + ". Expected: " + TestInfo.formatTime(expectedOnMyMachine) + ". Actual: " + TestInfo.formatTime(duration) + "." + Timings.getStatistics();
                double acceptableChangeFactor = 1.1;
                if (duration < (long)expectedOnMyMachine) {
                    int percentage = (int)(100.0 * (double)((long)expectedOnMyMachine - duration) / (double)expectedOnMyMachine);
                    logMessage = percentage + "% faster. " + logMessage;
                    TeamCityLogger.info(logMessage);
                    System.out.println("SUCCESS: " + logMessage);
                    break;
                }
                if ((double)duration < (double)expectedOnMyMachine * 1.1) {
                    TeamCityLogger.warning(logMessage, null);
                    System.out.println("WARNING: " + logMessage);
                    break;
                }
                if (this.attempts == 0) {
                    throw new AssertionFailedError(logMessage);
                }
                System.gc();
                System.gc();
                System.gc();
                String s = "Another epic fail (remaining attempts: " + this.attempts + "): " + logMessage;
                TeamCityLogger.warning(s, null);
                System.err.println(s);
            }
        }

        private static String formatTime(long millis) {
            String hint = "";
            DecimalFormat format = new DecimalFormat("#.0", DecimalFormatSymbols.getInstance(Locale.US));
            if (millis >= 60000L) {
                hint = format.format((float)(millis / 60L) / 1000.0f) + "m";
            }
            if (millis >= 1000L) {
                hint = hint + (hint.isEmpty() ? "" : " ") + format.format((float)millis / 1000.0f) + "s";
            }
            String result = millis + "ms";
            if (!hint.isEmpty()) {
                result = result + " (" + hint + ")";
            }
            return result;
        }

        private static int adjust(int expectedOnMyMachine, long thisTiming, long etalonTiming, boolean useLegacyScaling) {
            if (useLegacyScaling) {
                double speed = 1.0 * (double)thisTiming / (double)etalonTiming;
                double delta = speed < 1.0 ? 0.9 + Math.pow(speed - 0.7, 2.0) : 0.45 + Math.pow(speed - 0.25, 2.0);
                expectedOnMyMachine = (int)((double)expectedOnMyMachine * delta);
                return expectedOnMyMachine;
            }
            return (int)((long)expectedOnMyMachine * thisTiming / etalonTiming);
        }
    }
}

