/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.editor.impl.view.FontLayoutService;
import com.intellij.testFramework.AbstractMockGlyphVector;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.Point2D;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class MockFontLayoutService
extends FontLayoutService {
    private final int myCharWidth;
    private final int myLineHeight;
    private final int myDescent;

    public MockFontLayoutService(int charWidth, int lineHeight, int descent) {
        this.myCharWidth = charWidth;
        this.myLineHeight = lineHeight;
        this.myDescent = descent;
    }

    @Override
    @NotNull
    public GlyphVector layoutGlyphVector(@NotNull Font font, @NotNull FontRenderContext fontRenderContext, @NotNull char[] chars, int start, int end, boolean isRtl) {
        return new MockGlyphVector(Arrays.copyOfRange(chars, start, end), isRtl);
    }

    @Override
    public int charWidth(@NotNull FontMetrics fontMetrics, char c) {
        return this.myCharWidth;
    }

    @Override
    public int getHeight(@NotNull FontMetrics fontMetrics) {
        return this.myLineHeight;
    }

    @Override
    public int getAscent(@NotNull FontMetrics fontMetrics) {
        return this.myLineHeight - this.myDescent;
    }

    private class MockGlyphVector
    extends AbstractMockGlyphVector {
        private final char[] myChars;
        private final boolean myIsRtl;

        private MockGlyphVector(char[] chars, boolean isRtl) {
            this.myChars = chars;
            this.myIsRtl = isRtl;
        }

        @Override
        public int getNumGlyphs() {
            return this.myChars.length;
        }

        @Override
        public int getGlyphCharIndex(int glyphIndex) {
            return this.myIsRtl ? this.myChars.length - 1 - glyphIndex : glyphIndex;
        }

        @Override
        public Point2D getGlyphPosition(int glyphIndex) {
            return new Point(glyphIndex * MockFontLayoutService.this.myCharWidth, 0);
        }

        @Override
        public Shape getGlyphLogicalBounds(int glyphIndex) {
            return new Rectangle(glyphIndex * MockFontLayoutService.this.myCharWidth, -MockFontLayoutService.this.myDescent, MockFontLayoutService.this.myCharWidth, MockFontLayoutService.this.myLineHeight);
        }

        @Override
        public int getGlyphCode(int glyphIndex) {
            return this.myChars[glyphIndex];
        }
    }
}

