/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class LoggedErrorProcessor {
    private static final LoggedErrorProcessor DEFAULT;
    private static LoggedErrorProcessor ourInstance;

    @NotNull
    public static LoggedErrorProcessor getInstance() {
        return ourInstance;
    }

    public static void setNewInstance(@NotNull LoggedErrorProcessor newInstance) {
        ourInstance = newInstance;
    }

    public static void restoreDefaultProcessor() {
        ourInstance = DEFAULT;
    }

    public void processWarn(String message, Throwable t, @NotNull Logger logger) {
        logger.warn((Object)message, t);
    }

    public void processError(String message, Throwable t, String[] details, @NotNull Logger logger) {
        logger.info((Object)message, t);
        System.err.println("ERROR: " + message);
        if (t != null) {
            t.printStackTrace(System.err);
        }
        if (details != null && details.length > 0) {
            System.out.println("details: ");
            for (String detail : details) {
                System.out.println(detail);
            }
        }
        throw new AssertionError((Object)message);
    }

    static {
        ourInstance = DEFAULT = new LoggedErrorProcessor();
    }
}

