/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.EmptyModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.ex.temp.TempFileSystem;
import com.intellij.util.Consumer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.IndexableFileSet;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightProjectDescriptor {
    public static final LightProjectDescriptor EMPTY_PROJECT_DESCRIPTOR = new LightProjectDescriptor();

    public void setUpProject(final @NotNull Project project2, final @NotNull SetupHandler handler2) throws Exception {
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                Module module2 = LightProjectDescriptor.this.createMainModule(project2);
                handler2.moduleCreated(module2);
                VirtualFile sourceRoot = LightProjectDescriptor.this.createSourcesRoot(module2);
                if (sourceRoot != null) {
                    handler2.sourceRootCreated(sourceRoot);
                    LightProjectDescriptor.this.createContentEntry(module2, sourceRoot);
                }
            }
        });
    }

    @NotNull
    public Module createMainModule(final @NotNull Project project2) {
        return (Module)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<Module>(){

            public Module compute() {
                String moduleFilePath = "light_idea_test_case.iml";
                File imlFile = new File(moduleFilePath);
                if (imlFile.exists()) {
                    FileUtil.delete((File)imlFile);
                }
                return ModuleManager.getInstance((Project)project2).newModule(moduleFilePath, LightProjectDescriptor.this.getModuleType().getId());
            }
        });
    }

    @NotNull
    public ModuleType getModuleType() {
        return EmptyModuleType.getInstance();
    }

    @Nullable
    public VirtualFile createSourcesRoot(final @NotNull Module module2) {
        VirtualFile srcRoot;
        VirtualFile dummyRoot = VirtualFileManager.getInstance().findFileByUrl("temp:///");
        assert (dummyRoot != null);
        dummyRoot.refresh(false, false);
        try {
            srcRoot = dummyRoot.createChildDirectory((Object)this, "src");
            this.cleanSourceRoot(srcRoot);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        final IndexableFileSet indexableFileSet = new IndexableFileSet(){

            public boolean isInSet(@NotNull VirtualFile file2) {
                return file2.getFileSystem() == srcRoot.getFileSystem() && module2.getProject().isOpen();
            }

            public void iterateIndexableFilesIn(@NotNull VirtualFile file2, final @NotNull ContentIterator iterator) {
                VfsUtilCore.visitChildrenRecursively((VirtualFile)file2, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

                    public boolean visitFile(@NotNull VirtualFile file2) {
                        iterator.processFile(file2);
                        return true;
                    }
                });
            }
        };
        FileBasedIndex.getInstance().registerIndexableSet(indexableFileSet, null);
        Disposer.register((Disposable)module2.getProject(), (Disposable)new Disposable(){

            public void dispose() {
                FileBasedIndex.getInstance().removeIndexableSet(indexableFileSet);
            }
        });
        return srcRoot;
    }

    protected void createContentEntry(final @NotNull Module module2, final @NotNull VirtualFile srcRoot) {
        ModuleRootModificationUtil.updateModel((Module)module2, (Consumer)new Consumer<ModifiableRootModel>(){

            public void consume(ModifiableRootModel model) {
                Sdk sdk = LightProjectDescriptor.this.getSdk();
                if (sdk != null) {
                    model.setSdk(sdk);
                }
                ContentEntry contentEntry = model.addContentEntry(srcRoot);
                contentEntry.addSourceFolder(srcRoot, false);
                LightProjectDescriptor.this.configureModule(module2, model, contentEntry);
            }
        });
    }

    @Nullable
    public Sdk getSdk() {
        return null;
    }

    private void cleanSourceRoot(@NotNull VirtualFile contentRoot) throws IOException {
        TempFileSystem tempFs = (TempFileSystem)contentRoot.getFileSystem();
        for (VirtualFile child : contentRoot.getChildren()) {
            if (!tempFs.exists(child)) {
                tempFs.createChildFile(this, contentRoot, child.getName());
            }
            child.delete((Object)this);
        }
    }

    protected void configureModule(@NotNull Module module2, @NotNull ModifiableRootModel model, @NotNull ContentEntry contentEntry) {
    }

    public static interface SetupHandler {
        public void moduleCreated(@NotNull Module var1);

        public void sourceRootCreated(@NotNull VirtualFile var1);
    }
}

