/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.testFramework.fixtures.impl.GlobalInspectionContextForTests;
import com.intellij.util.ui.UIUtil;
import java.io.CharArrayReader;
import java.io.File;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import org.jdom.Document;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;

public class InspectionTestUtil {
    private InspectionTestUtil() {
    }

    protected static void compareWithExpected(Document expectedDoc, Document doc, boolean checkRange) throws Exception {
        ArrayList expectedProblems = new ArrayList(expectedDoc.getRootElement().getChildren("problem"));
        ArrayList reportedProblems = new ArrayList(doc.getRootElement().getChildren("problem"));
        Element[] expectedArray = expectedProblems.toArray(new Element[expectedProblems.size()]);
        boolean failed = false;
        block0: for (Element expectedProblem : expectedArray) {
            Element[] reportedArrayed;
            for (Element reportedProblem : reportedArrayed = reportedProblems.toArray(new Element[reportedProblems.size()])) {
                if (!InspectionTestUtil.compareProblemWithExpected(reportedProblem, expectedProblem, checkRange)) continue;
                expectedProblems.remove(expectedProblem);
                reportedProblems.remove(reportedProblem);
                continue block0;
            }
            Document missing = new Document(expectedProblem.clone());
            System.out.println("The following haven't been reported as expected: " + new String(JDOMUtil.printDocument((Document)missing, (String)"\n")));
            failed = true;
        }
        for (Element reportedProblem : reportedProblems) {
            Document extra = new Document(reportedProblem.clone());
            System.out.println("The following has been unexpectedly reported: " + new String(JDOMUtil.printDocument((Document)extra, (String)"\n")));
            failed = true;
        }
        Assert.assertFalse((boolean)failed);
    }

    static boolean compareProblemWithExpected(Element reportedProblem, Element expectedProblem, boolean checkRange) throws Exception {
        if (!InspectionTestUtil.compareFiles(reportedProblem, expectedProblem)) {
            return false;
        }
        if (!InspectionTestUtil.compareLines(reportedProblem, expectedProblem)) {
            return false;
        }
        if (!InspectionTestUtil.compareDescriptions(reportedProblem, expectedProblem)) {
            return false;
        }
        return !checkRange || InspectionTestUtil.compareTextRange(reportedProblem, expectedProblem);
    }

    static boolean compareTextRange(Element reportedProblem, Element expectedProblem) {
        Element reportedTextRange = reportedProblem.getChild("entry_point");
        if (reportedTextRange == null) {
            return false;
        }
        Element expectedTextRange = expectedProblem.getChild("entry_point");
        return Comparing.equal((String)reportedTextRange.getAttributeValue("TYPE"), (String)expectedTextRange.getAttributeValue("TYPE")) && Comparing.equal((String)reportedTextRange.getAttributeValue("FQNAME"), (String)expectedTextRange.getAttributeValue("FQNAME"));
    }

    /*
     * WARNING - void declaration
     */
    static boolean compareDescriptions(Element reportedProblem, Element expectedProblem) throws Exception {
        String reportedDescription;
        String expectedDescription = expectedProblem.getChildText("description");
        if (expectedDescription.equals(reportedDescription = reportedProblem.getChildText("description"))) {
            return true;
        }
        StreamTokenizer tokenizer = new StreamTokenizer(new CharArrayReader(expectedDescription.toCharArray()));
        tokenizer.quoteChar(39);
        int idx = 0;
        while (tokenizer.nextToken() != -1) {
            void var6_6;
            String word;
            if (tokenizer.sval != null) {
                word = tokenizer.sval;
            } else {
                if (tokenizer.ttype != -2) continue;
                word = Double.toString(tokenizer.nval);
            }
            idx = reportedDescription.indexOf((String)var6_6, idx);
            if (idx == -1) {
                return false;
            }
            idx += var6_6.length();
        }
        return true;
    }

    static boolean compareLines(Element reportedProblem, Element expectedProblem) {
        return Comparing.equal((String)reportedProblem.getChildText("line"), (String)expectedProblem.getChildText("line"));
    }

    static boolean compareFiles(Element reportedProblem, Element expectedProblem) {
        String reportedFileName = reportedProblem.getChildText("file");
        if (reportedFileName == null) {
            return true;
        }
        File reportedFile = new File(reportedFileName);
        return Comparing.equal((String)reportedFile.getName(), (String)expectedProblem.getChildText("file"));
    }

    public static void compareToolResults(@NotNull GlobalInspectionContextImpl context, @NotNull InspectionToolWrapper toolWrapper, boolean checkRange, String testDir) {
        Element root = new Element("problems");
        Document doc = new Document(root);
        InspectionToolPresentation presentation = context.getPresentation(toolWrapper);
        presentation.updateContent();
        presentation.exportResults(root);
        File file2 = new File(testDir + "/expected.xml");
        try {
            Document expectedDocument = JDOMUtil.loadDocument((File)file2);
            InspectionTestUtil.compareWithExpected(expectedDocument, doc, checkRange);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void runTool(@NotNull InspectionToolWrapper toolWrapper, @NotNull AnalysisScope scope, @NotNull GlobalInspectionContextForTests globalContext) {
        String shortName = toolWrapper.getShortName();
        HighlightDisplayKey key = HighlightDisplayKey.find((String)shortName);
        if (key == null) {
            HighlightDisplayKey.register((String)shortName);
        }
        globalContext.doInspections(scope);
        do {
            UIUtil.dispatchAllInvocationEvents();
        } while (!globalContext.isFinished());
    }
}

