/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.iterators;

import com.intellij.dupLocator.iterators.NodeIterator;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.javadoc.PsiDocToken;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;

public class DocValuesIterator
extends NodeIterator {
    private int index;
    private final ArrayList<PsiElement> tokens = new ArrayList(2);
    private static final IElementType tokenType = JavaDocTokenType.DOC_COMMENT_DATA;

    public DocValuesIterator(PsiElement start) {
        for (PsiElement e = start; e != null; e = e.getNextSibling()) {
            if (e instanceof PsiDocTagValue) {
                this.tokens.add(e);
                continue;
            }
            if (!(e instanceof PsiDocToken) || ((PsiDocToken)e).getTokenType() != tokenType) continue;
            this.tokens.add(e);
            e = DocValuesIterator.advanceToNext(e);
        }
    }

    static PsiElement advanceToNext(PsiElement e) {
        PsiElement nextSibling = e.getNextSibling();
        if (nextSibling instanceof PsiDocTagValue) {
            e = nextSibling;
        }
        if ((nextSibling = e.getNextSibling()) instanceof PsiDocToken && ((PsiDocToken)nextSibling).getTokenType() == tokenType) {
            e = nextSibling;
        }
        return e;
    }

    @Override
    public boolean hasNext() {
        return this.index >= 0 && this.index < this.tokens.size();
    }

    @Override
    public PsiElement current() {
        return this.hasNext() ? this.tokens.get(this.index) : null;
    }

    @Override
    public void advance() {
        if (this.index < this.tokens.size()) {
            ++this.index;
        }
    }

    @Override
    public void rewind() {
        if (this.index >= 0) {
            --this.index;
        }
    }

    @Override
    public void reset() {
        this.index = 0;
    }
}

