/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher;

import com.intellij.dupLocator.iterators.ArrayBackedNodeIterator;
import com.intellij.dupLocator.iterators.NodeIterator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaReference;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceListElement;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.GlobalMatchingVisitor;
import com.intellij.structuralsearch.impl.matcher.JavaCompiledPattern;
import com.intellij.structuralsearch.impl.matcher.MatchContext;
import com.intellij.structuralsearch.impl.matcher.MatchResultImpl;
import com.intellij.structuralsearch.impl.matcher.MatchUtils;
import com.intellij.structuralsearch.impl.matcher.filters.LexicalNodesFilter;
import com.intellij.structuralsearch.impl.matcher.handlers.MatchPredicate;
import com.intellij.structuralsearch.impl.matcher.handlers.MatchingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.SubstitutionHandler;
import com.intellij.structuralsearch.impl.matcher.iterators.DocValuesIterator;
import com.intellij.structuralsearch.impl.matcher.iterators.HierarchyNodeIterator;
import com.intellij.structuralsearch.impl.matcher.predicates.NotPredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.RegExpPredicate;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class JavaMatchingVisitor
extends JavaElementVisitor {
    public static final String[] MODIFIERS = new String[]{"public", "protected", "private", "static", "abstract", "final", "native", "synchronized", "strictfp", "transient", "volatile", "default"};
    private final GlobalMatchingVisitor myMatchingVisitor;
    private PsiClass myClazz;

    public JavaMatchingVisitor(GlobalMatchingVisitor matchingVisitor) {
        this.myMatchingVisitor = matchingVisitor;
    }

    public void visitComment(PsiComment comment) {
        PsiComment comment2 = null;
        if (!(this.myMatchingVisitor.getElement() instanceof PsiComment)) {
            PsiElement[] children2;
            if (this.myMatchingVisitor.getElement() instanceof PsiMember && (children2 = this.myMatchingVisitor.getElement().getChildren())[0] instanceof PsiComment) {
                comment2 = (PsiComment)children2[0];
            }
        } else {
            comment2 = (PsiComment)this.myMatchingVisitor.getElement();
        }
        if (comment2 == null) {
            this.myMatchingVisitor.setResult(false);
            return;
        }
        Object userData = comment.getUserData(CompiledPattern.HANDLER_KEY);
        if (userData instanceof String) {
            String str = (String)userData;
            int end = comment2.getTextLength();
            if (comment2.getTokenType() == JavaTokenType.C_STYLE_COMMENT) {
                end -= 2;
            }
            this.myMatchingVisitor.setResult(((SubstitutionHandler)this.myMatchingVisitor.getMatchContext().getPattern().getHandler(str)).handle((PsiElement)comment2, 2, end, this.myMatchingVisitor.getMatchContext()));
        } else if (userData instanceof MatchingHandler) {
            this.myMatchingVisitor.setResult(((MatchingHandler)userData).match((PsiElement)comment, (PsiElement)comment2, this.myMatchingVisitor.getMatchContext()));
        } else {
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchText((PsiElement)comment, (PsiElement)comment2));
        }
    }

    private static boolean isNotInstanceModifier(PsiModifierList list2) {
        return list2.hasModifierProperty("static") || list2.hasModifierProperty("abstract");
    }

    public final void visitModifierList(PsiModifierList list) {
        PsiModifierList list2 = (PsiModifierList)this.myMatchingVisitor.getElement();
        for (String modifier : MODIFIERS) {
            if (!list.hasModifierProperty(modifier) || list2.hasModifierProperty(modifier)) continue;
            this.myMatchingVisitor.setResult(false);
            return;
        }
        PsiAnnotation[] annotations = list.getAnnotations();
        if (annotations.length > 0) {
            HashSet<PsiAnnotation> set = new HashSet<PsiAnnotation>(Arrays.asList(annotations));
            for (PsiAnnotation annotation : annotations) {
                PsiNameValuePair[] attributes;
                PsiJavaCodeReferenceElement nameReferenceElement = annotation.getNameReferenceElement();
                if (nameReferenceElement == null || !"Modifier".equals(nameReferenceElement.getText())) continue;
                PsiAnnotationParameterList parameterList = annotation.getParameterList();
                for (PsiNameValuePair pair : attributes = parameterList.getAttributes()) {
                    PsiAnnotationMemberValue value = pair.getValue();
                    if (value == null) continue;
                    if (value instanceof PsiArrayInitializerMemberValue) {
                        boolean matchedOne = false;
                        for (PsiAnnotationMemberValue v : ((PsiArrayInitializerMemberValue)value).getInitializers()) {
                            String name = StringUtil.stripQuotesAroundValue((String)v.getText());
                            if ("Instance".equals(name)) {
                                if (JavaMatchingVisitor.isNotInstanceModifier(list2)) {
                                    this.myMatchingVisitor.setResult(false);
                                    return;
                                }
                                matchedOne = true;
                                continue;
                            }
                            if (!list2.hasModifierProperty(name)) continue;
                            matchedOne = true;
                            break;
                        }
                        if (matchedOne) continue;
                        this.myMatchingVisitor.setResult(false);
                        return;
                    }
                    String name = StringUtil.stripQuotesAroundValue((String)value.getText());
                    if ("Instance".equals(name)) {
                        if (!JavaMatchingVisitor.isNotInstanceModifier(list2)) continue;
                        this.myMatchingVisitor.setResult(false);
                        return;
                    }
                    if (list2.hasModifierProperty(name)) continue;
                    this.myMatchingVisitor.setResult(false);
                    return;
                }
                set.remove(annotation);
            }
            this.myMatchingVisitor.setResult(set.isEmpty() || this.myMatchingVisitor.matchInAnyOrder((PsiElement[])set.toArray(new PsiAnnotation[set.size()]), (PsiElement[])list2.getAnnotations()));
        } else {
            this.myMatchingVisitor.setResult(true);
        }
    }

    public void visitDocTag(PsiDocTag tag) {
        PsiDocTag tag2 = (PsiDocTag)this.myMatchingVisitor.getElement();
        boolean isTypedVar = this.myMatchingVisitor.getMatchContext().getPattern().isTypedVar(tag.getNameElement());
        this.myMatchingVisitor.setResult(isTypedVar || tag.getName().equals(tag2.getName()));
        PsiDocTagValue psiDocTagValue = tag.getValueElement();
        boolean isTypedValue = false;
        if (this.myMatchingVisitor.getResult() && psiDocTagValue != null) {
            PsiElement[] children2 = psiDocTagValue.getChildren();
            if (children2.length == 1) {
                psiDocTagValue = children2[0];
            }
            if (isTypedValue = this.myMatchingVisitor.getMatchContext().getPattern().isTypedVar((PsiElement)psiDocTagValue)) {
                if (tag2.getValueElement() != null) {
                    this.myMatchingVisitor.setResult(this.myMatchingVisitor.handleTypedElement((PsiElement)psiDocTagValue, (PsiElement)tag2.getValueElement()));
                } else {
                    this.myMatchingVisitor.setResult(this.myMatchingVisitor.allowsAbsenceOfMatch((PsiElement)psiDocTagValue));
                }
            }
        }
        if (this.myMatchingVisitor.getResult() && !isTypedValue) {
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchInAnyOrder(new DocValuesIterator(tag.getFirstChild()), new DocValuesIterator(tag2.getFirstChild())));
        }
        if (this.myMatchingVisitor.getResult() && isTypedVar) {
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.handleTypedElement(tag.getNameElement(), tag2.getNameElement()));
        }
    }

    public void visitDocComment(PsiDocComment comment) {
        PsiDocComment comment2;
        if (this.myMatchingVisitor.getElement() instanceof PsiDocCommentOwner) {
            comment2 = ((PsiDocCommentOwner)this.myMatchingVisitor.getElement()).getDocComment();
            if (comment2 == null) {
                this.myMatchingVisitor.setResult(false);
                return;
            }
        } else {
            comment2 = (PsiDocComment)this.myMatchingVisitor.getElement();
            if (this.myMatchingVisitor.getElement().getParent() instanceof PsiDocCommentOwner) {
                this.myMatchingVisitor.setResult(false);
                return;
            }
        }
        if (comment.getTags().length > 0) {
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchInAnyOrder((PsiElement[])comment.getTags(), (PsiElement[])comment2.getTags()));
        } else {
            this.visitComment((PsiComment)comment);
        }
    }

    public void visitElement(PsiElement el) {
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchText(el, this.myMatchingVisitor.getElement()));
    }

    public void visitArrayInitializerExpression(PsiArrayInitializerExpression expression) {
        PsiArrayInitializerExpression expr2 = (PsiArrayInitializerExpression)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSequentially(new ArrayBackedNodeIterator((PsiElement[])expression.getInitializers()), new ArrayBackedNodeIterator((PsiElement[])expr2.getInitializers())));
    }

    public void visitClassInitializer(PsiClassInitializer initializer) {
        PsiClassInitializer initializer2 = (PsiClassInitializer)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)initializer.getModifierList(), (PsiElement)initializer2.getModifierList()) && this.myMatchingVisitor.match((PsiElement)initializer.getBody(), (PsiElement)initializer2.getBody()));
    }

    public void visitCodeBlock(PsiCodeBlock block) {
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSons((PsiElement)block, this.myMatchingVisitor.getElement()));
    }

    public void visitJavaToken(PsiJavaToken token) {
        boolean result;
        PsiElement element = this.myMatchingVisitor.getElement();
        if (!(element instanceof PsiJavaToken)) {
            result = this.myMatchingVisitor.matchText((PsiElement)token, element);
        } else {
            PsiJavaToken anotherToken = (PsiJavaToken)element;
            result = token.getTokenType() == anotherToken.getTokenType() && this.myMatchingVisitor.matchText((PsiElement)token, (PsiElement)anotherToken);
        }
        this.myMatchingVisitor.setResult(result);
    }

    public void visitAnnotation(PsiAnnotation annotation) {
        PsiAnnotation psiAnnotation = (PsiAnnotation)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)annotation.getNameReferenceElement(), (PsiElement)psiAnnotation.getNameReferenceElement()) && this.myMatchingVisitor.matchInAnyOrder((PsiElement[])annotation.getParameterList().getAttributes(), (PsiElement[])psiAnnotation.getParameterList().getAttributes()));
    }

    public void visitNameValuePair(PsiNameValuePair pair) {
        PsiNameValuePair elementNameValuePair = (PsiNameValuePair)this.myMatchingVisitor.getElement();
        PsiAnnotationMemberValue annotationInitializer = pair.getValue();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)annotationInitializer, (PsiElement)elementNameValuePair.getValue()));
        if (this.myMatchingVisitor.getResult()) {
            PsiIdentifier nameIdentifier = pair.getNameIdentifier();
            PsiIdentifier otherIdentifier = elementNameValuePair.getNameIdentifier();
            if (nameIdentifier == null) {
                this.myMatchingVisitor.setResult(otherIdentifier == null || otherIdentifier.getText().equals("value"));
            } else {
                MatchingHandler handler2 = this.myMatchingVisitor.getMatchContext().getPattern().getHandler((PsiElement)nameIdentifier);
                if (handler2 instanceof SubstitutionHandler) {
                    this.myMatchingVisitor.setResult(((SubstitutionHandler)handler2).handle((PsiElement)otherIdentifier, this.myMatchingVisitor.getMatchContext()));
                } else {
                    this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)nameIdentifier, (PsiElement)otherIdentifier));
                }
            }
        }
    }

    private boolean checkHierarchy(PsiMember element, PsiMember patternElement) {
        MatchingHandler handler2 = this.myMatchingVisitor.getMatchContext().getPattern().getHandler((PsiElement)patternElement);
        if (handler2 instanceof SubstitutionHandler) {
            SubstitutionHandler handler22 = (SubstitutionHandler)handler2;
            if (!handler22.isSubtype()) {
                if (handler22.isStrictSubtype()) {
                    return element.getContainingClass() != this.myClazz;
                }
            } else {
                return true;
            }
        }
        return this.myClazz == null || element.getContainingClass() == this.myClazz;
    }

    public void visitField(PsiField psiField) {
        PsiDocComment comment = psiField.getDocComment();
        PsiField other = (PsiField)this.myMatchingVisitor.getElement();
        if (comment != null) {
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)comment, (PsiElement)other));
            if (!this.myMatchingVisitor.getResult()) {
                return;
            }
        }
        if (!this.checkHierarchy((PsiMember)other, (PsiMember)psiField)) {
            this.myMatchingVisitor.setResult(false);
            return;
        }
        super.visitField(psiField);
    }

    public void visitAnonymousClass(PsiAnonymousClass clazz) {
        PsiAnonymousClass clazz2 = (PsiAnonymousClass)this.myMatchingVisitor.getElement();
        boolean isTypedVar = this.myMatchingVisitor.getMatchContext().getPattern().isTypedVar(clazz.getFirstChild());
        this.myMatchingVisitor.setResult((this.myMatchingVisitor.match((PsiElement)clazz.getBaseClassReference(), (PsiElement)clazz2.getBaseClassReference()) || isTypedVar) && this.myMatchingVisitor.matchSons((PsiElement)clazz.getArgumentList(), (PsiElement)clazz2.getArgumentList()) && this.compareClasses((PsiClass)clazz, (PsiClass)clazz2));
        if (this.myMatchingVisitor.getResult() && isTypedVar) {
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.handleTypedElement(clazz.getFirstChild(), clazz2.getFirstChild()));
        }
    }

    public void visitLambdaExpression(PsiLambdaExpression expression) {
        PsiElement other = this.myMatchingVisitor.getElement();
        if (other instanceof PsiLambdaExpression) {
            PsiElement body1;
            PsiLambdaExpression expression2 = (PsiLambdaExpression)other;
            boolean result = true;
            PsiParameterList parameterList1 = expression.getParameterList();
            if (parameterList1.getParametersCount() != 0) {
                result = this.myMatchingVisitor.matchSons((PsiElement)parameterList1, (PsiElement)expression2.getParameterList());
            }
            if ((body1 = JavaMatchingVisitor.getElementToMatch(expression.getBody())) != null && result) {
                result = this.myMatchingVisitor.matchSequentially(body1, JavaMatchingVisitor.getElementToMatch(expression2.getBody()));
            }
            this.myMatchingVisitor.setResult(result);
        } else {
            this.myMatchingVisitor.setResult(false);
        }
    }

    private static PsiElement getElementToMatch(PsiElement element) {
        if (element instanceof PsiCodeBlock) {
            element = PsiTreeUtil.getChildOfAnyType((PsiElement)element, (Class[])new Class[]{PsiStatement.class, PsiComment.class});
        }
        if (element instanceof PsiExpressionStatement) {
            element = ((PsiExpressionStatement)element).getExpression();
        }
        if (element instanceof PsiReturnStatement) {
            element = ((PsiReturnStatement)element).getReturnValue();
        }
        return element;
    }

    private boolean matchInAnyOrder(PsiReferenceList elements, PsiReferenceList elements2) {
        if (elements == null && this.myMatchingVisitor.isLeftLooseMatching() || elements == elements2) {
            return true;
        }
        return this.myMatchingVisitor.matchInAnyOrder((PsiElement[])elements.getReferenceElements(), (PsiElement[])(elements2 != null ? elements2.getReferenceElements() : PsiElement.EMPTY_ARRAY));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean compareClasses(PsiClass clazz, final PsiClass clazz2) {
        PsiClass saveClazz = this.myClazz;
        MatchContext.MatchedElementsListener oldListener = this.myMatchingVisitor.getMatchContext().getMatchedElementsListener();
        this.myClazz = clazz2;
        CompiledPattern pattern = this.myMatchingVisitor.getMatchContext().getPattern();
        assert (pattern instanceof JavaCompiledPattern);
        JavaCompiledPattern javaPattern = (JavaCompiledPattern)pattern;
        String unmatchedHandlerName = (String)clazz.getUserData(JavaCompiledPattern.ALL_CLASS_CONTENT_VAR_NAME_KEY);
        final MatchingHandler allRemainingClassContentElementHandler = unmatchedHandlerName != null ? pattern.getHandler(unmatchedHandlerName) : null;
        MatchContext.MatchedElementsListener newListener = null;
        if (allRemainingClassContentElementHandler != null) {
            newListener = new MatchContext.MatchedElementsListener(){
                private Set<PsiElement> myMatchedElements;

                @Override
                public void matchedElements(Collection<PsiElement> matchedElements) {
                    if (matchedElements == null) {
                        return;
                    }
                    if (this.myMatchedElements == null) {
                        this.myMatchedElements = new HashSet<PsiElement>(matchedElements);
                    } else {
                        this.myMatchedElements.addAll(matchedElements);
                    }
                }

                @Override
                public void commitUnmatched() {
                    SubstitutionHandler handler2 = (SubstitutionHandler)allRemainingClassContentElementHandler;
                    for (PsiElement el = clazz2.getFirstChild(); el != null; el = el.getNextSibling()) {
                        if (!(el instanceof PsiMember) || this.myMatchedElements != null && this.myMatchedElements.contains(el)) continue;
                        handler2.handle(el, JavaMatchingVisitor.this.myMatchingVisitor.getMatchContext());
                    }
                }
            };
            this.myMatchingVisitor.getMatchContext().setMatchedElementsListener(newListener);
        }
        boolean result = false;
        try {
            PsiClassInitializer[] initializers2;
            PsiClassInitializer[] initializers;
            PsiClass[] nestedClasses;
            PsiMethod[] methods;
            PsiField[] fields;
            boolean accepted;
            boolean templateIsInterface = clazz.isInterface();
            if (templateIsInterface != clazz2.isInterface()) {
                boolean bl = false;
                return bl;
            }
            if (templateIsInterface && clazz.isAnnotationType() && !clazz2.isAnnotationType()) {
                boolean bl = false;
                return bl;
            }
            if (clazz.isEnum() && !clazz2.isEnum()) {
                boolean bl = false;
                return bl;
            }
            if (!this.matchInAnyOrder(clazz.getExtendsList(), clazz2.getExtendsList())) {
                boolean bl = false;
                return bl;
            }
            PsiReferenceList implementsList = clazz.getImplementsList();
            if (implementsList != null && !this.matchInAnyOrder(implementsList, clazz2.getImplementsList())) {
                PsiReferenceList anotherExtendsList = clazz2.getExtendsList();
                PsiJavaCodeReferenceElement[] referenceElements = implementsList.getReferenceElements();
                accepted = false;
                if (referenceElements.length > 0 && anotherExtendsList != null) {
                    HierarchyNodeIterator iterator = new HierarchyNodeIterator((PsiElement)clazz2, true, true, false);
                    accepted = this.myMatchingVisitor.matchInAnyOrder(new ArrayBackedNodeIterator((PsiElement[])referenceElements), iterator);
                }
                if (!accepted) {
                    boolean iterator = false;
                    return iterator;
                }
            }
            if ((fields = clazz.getFields()).length > 0) {
                PsiField[] fields2;
                PsiField[] psiFieldArray = fields2 = javaPattern.isRequestsSuperFields() ? clazz2.getAllFields() : clazz2.getFields();
                if (!this.myMatchingVisitor.matchInAnyOrder((PsiElement[])fields, (PsiElement[])fields2)) {
                    accepted = false;
                    return accepted;
                }
            }
            if ((methods = clazz.getMethods()).length > 0) {
                PsiMethod[] methods2;
                PsiMethod[] psiMethodArray = methods2 = javaPattern.isRequestsSuperMethods() ? clazz2.getAllMethods() : clazz2.getMethods();
                if (!this.myMatchingVisitor.matchInAnyOrder((PsiElement[])methods, (PsiElement[])methods2)) {
                    boolean iterator = false;
                    return iterator;
                }
            }
            if ((nestedClasses = clazz.getInnerClasses()).length > 0) {
                PsiClass[] nestedClasses2;
                PsiClass[] psiClassArray = nestedClasses2 = javaPattern.isRequestsSuperInners() ? clazz2.getAllInnerClasses() : clazz2.getInnerClasses();
                if (!this.myMatchingVisitor.matchInAnyOrder((PsiElement[])nestedClasses, (PsiElement[])nestedClasses2)) {
                    boolean bl = false;
                    return bl;
                }
            }
            if ((initializers = clazz.getInitializers()).length > 0 && !this.myMatchingVisitor.matchInAnyOrder((PsiElement[])initializers, (PsiElement[])(initializers2 = clazz2.getInitializers()))) {
                boolean bl = false;
                return bl;
            }
            boolean bl = result = true;
            return bl;
        }
        finally {
            if (result && newListener != null) {
                newListener.commitUnmatched();
            }
            this.myClazz = saveClazz;
            this.myMatchingVisitor.getMatchContext().setMatchedElementsListener(oldListener);
        }
    }

    private boolean compareBody(PsiElement el1, PsiElement el2) {
        PsiElement compareElement1 = el1;
        PsiElement compareElement2 = el2;
        if (this.myMatchingVisitor.getMatchContext().getOptions().isLooseMatching()) {
            if (el1 instanceof PsiBlockStatement) {
                compareElement1 = ((PsiBlockStatement)el1).getCodeBlock().getFirstChild();
            }
            if (el2 instanceof PsiBlockStatement) {
                compareElement2 = ((PsiBlockStatement)el2).getCodeBlock().getFirstChild();
            }
        }
        return this.myMatchingVisitor.matchSequentially(compareElement1, compareElement2);
    }

    public void visitArrayAccessExpression(PsiArrayAccessExpression slice) {
        PsiElement other = this.myMatchingVisitor.getElement();
        if (other instanceof PsiArrayAccessExpression) {
            PsiArrayAccessExpression slice2 = (PsiArrayAccessExpression)other;
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)slice.getArrayExpression(), (PsiElement)slice2.getArrayExpression()) && this.myMatchingVisitor.match((PsiElement)slice.getIndexExpression(), (PsiElement)slice2.getIndexExpression()));
        } else {
            this.myMatchingVisitor.setResult(false);
        }
    }

    public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression) {
        PsiElement element = this.myMatchingVisitor.getElement();
        if (!(element instanceof PsiMethodReferenceExpression)) {
            this.myMatchingVisitor.setResult(false);
            return;
        }
        super.visitMethodReferenceExpression(expression);
    }

    public void visitReferenceExpression(PsiReferenceExpression reference) {
        PsiElement element;
        PsiElement other;
        MatchingHandler _handler;
        PsiExpression qualifier = reference.getQualifierExpression();
        PsiElement nameElement = reference.getReferenceNameElement();
        MatchContext context = this.myMatchingVisitor.getMatchContext();
        MatchingHandler matchingHandler = _handler = nameElement != null ? context.getPattern().getHandlerSimple(nameElement) : null;
        if (!(_handler instanceof SubstitutionHandler)) {
            _handler = context.getPattern().getHandlerSimple((PsiElement)reference);
        }
        Object object = other = (element = this.myMatchingVisitor.getElement()) instanceof PsiExpression && context.getOptions().isLooseMatching() ? PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiExpression)element)) : element;
        if (_handler instanceof SubstitutionHandler && !(context.getPattern().getHandlerSimple((PsiElement)qualifier) instanceof SubstitutionHandler) && !(qualifier instanceof PsiThisExpression)) {
            SubstitutionHandler handler2;
            PsiReferenceExpression psiReferenceExpression;
            PsiExpression qualifier2;
            if (other instanceof PsiReferenceExpression && ((qualifier2 = (psiReferenceExpression = (PsiReferenceExpression)other).getQualifierExpression()) == null || context.getOptions().isLooseMatching() && qualifier2 instanceof PsiThisExpression)) {
                other = psiReferenceExpression.getReferenceNameElement();
            }
            if ((handler2 = (SubstitutionHandler)_handler).isSubtype() || handler2.isStrictSubtype()) {
                this.myMatchingVisitor.setResult(this.checkMatchWithingHierarchy(other, handler2, (PsiElement)reference));
            } else {
                this.myMatchingVisitor.setResult(handler2.handle(other, context));
            }
            return;
        }
        if (!(other instanceof PsiReferenceExpression)) {
            this.myMatchingVisitor.setResult(false);
            return;
        }
        PsiReferenceExpression reference2 = (PsiReferenceExpression)other;
        PsiExpression reference2Qualifier = reference2.getQualifierExpression();
        if (qualifier == null && reference2Qualifier == null) {
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchText(reference.getReferenceNameElement(), reference2.getReferenceNameElement()));
            return;
        }
        if (!(other.getParent() instanceof PsiMethodCallExpression) && qualifier != null) {
            PsiElement referenceElement = reference.getReferenceNameElement();
            PsiElement referenceElement2 = reference2.getReferenceNameElement();
            if (context.getPattern().isTypedVar(referenceElement)) {
                this.myMatchingVisitor.setResult(this.myMatchingVisitor.handleTypedElement(referenceElement, referenceElement2));
            } else {
                this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchText(referenceElement, referenceElement2));
            }
            if (!this.myMatchingVisitor.getResult()) {
                return;
            }
            if (reference2Qualifier != null) {
                this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)qualifier, (PsiElement)reference2Qualifier));
            } else {
                PsiElement referencedElement = MatchUtils.getReferencedElement(other);
                if (referencedElement instanceof PsiField) {
                    PsiField field = (PsiField)referencedElement;
                    if (qualifier instanceof PsiThisExpression) {
                        this.myMatchingVisitor.setResult(!field.hasModifierProperty("static"));
                        return;
                    }
                }
                MatchingHandler handler3 = context.getPattern().getHandler((PsiElement)qualifier);
                this.matchImplicitQualifier(handler3, referencedElement, context);
            }
            return;
        }
        this.myMatchingVisitor.setResult(false);
    }

    private static int getArrayDimensions(PsiElement element) {
        if (element == null) {
            return 0;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof PsiVariable) {
            PsiVariable variable = (PsiVariable)parent;
            PsiType type = variable.getType();
            return type.getArrayDimensions();
        }
        if (parent instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)parent;
            PsiType type = method.getReturnType();
            return type == null ? 0 : type.getArrayDimensions();
        }
        if (element instanceof PsiTypeElement) {
            PsiTypeElement typeElement = (PsiTypeElement)element;
            PsiType type = typeElement.getType();
            return type.getArrayDimensions();
        }
        return 0;
    }

    private static PsiTypeElement getInnermostComponentTypeElement(PsiTypeElement typeElement) {
        PsiElement child = typeElement.getFirstChild();
        while (child instanceof PsiTypeElement) {
            typeElement = (PsiTypeElement)child;
            child = typeElement.getFirstChild();
        }
        return typeElement;
    }

    private static PsiElement getInnermostComponent(PsiElement element) {
        if (!(element instanceof PsiTypeElement)) {
            return element;
        }
        PsiTypeElement typeElement = (PsiTypeElement)element;
        PsiJavaCodeReferenceElement referenceElement = typeElement.getInnermostComponentReferenceElement();
        return referenceElement != null ? referenceElement : JavaMatchingVisitor.getInnermostComponentTypeElement(typeElement);
    }

    private void copyResults(MatchResultImpl ourResult) {
        if (ourResult.hasSons()) {
            for (MatchResult son : ourResult.getAllSons()) {
                this.myMatchingVisitor.getMatchContext().getResult().addSon((MatchResultImpl)son);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean matchType(PsiElement patternType, PsiElement matchedType) {
        boolean caseSensitive;
        String text2;
        String text;
        boolean equalsIgnorePackage;
        PsiElement parent;
        PsiElement patternElement = JavaMatchingVisitor.getInnermostComponent(patternType);
        PsiElement matchedElement = JavaMatchingVisitor.getInnermostComponent(matchedType);
        PsiTypeElement[] typeParameters = null;
        if (matchedElement instanceof PsiJavaCodeReferenceElement) {
            PsiReferenceParameterList parameterList = ((PsiJavaCodeReferenceElement)matchedElement).getParameterList();
            if (parameterList != null) {
                typeParameters = parameterList.getTypeParameterElements();
            }
        } else if (matchedElement instanceof PsiTypeParameter) {
            matchedElement = ((PsiTypeParameter)matchedElement).getNameIdentifier();
        } else if (matchedElement instanceof PsiClass && ((PsiClass)matchedElement).hasTypeParameters()) {
            typeParameters = ((PsiClass)matchedElement).getTypeParameters();
            matchedElement = ((PsiClass)matchedElement).getNameIdentifier();
        } else if (matchedElement instanceof PsiMethod && ((PsiMethod)matchedElement).hasTypeParameters()) {
            typeParameters = ((PsiMethod)matchedType).getTypeParameters();
            matchedElement = ((PsiMethod)matchedType).getNameIdentifier();
        }
        if (patternElement instanceof PsiJavaCodeReferenceElement) {
            PsiTypeElement[] elements;
            PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)patternElement;
            PsiReferenceParameterList list = referenceElement.getParameterList();
            if (!(list == null || (elements = list.getTypeParameterElements()).length <= 0 || typeParameters != null && this.myMatchingVisitor.matchSequentially((PsiElement[])elements, (PsiElement[])typeParameters))) {
                return false;
            }
            patternElement = referenceElement.getReferenceNameElement();
        }
        final int matchedArrayDimensions = JavaMatchingVisitor.getArrayDimensions(matchedType);
        int patternArrayDimensions = JavaMatchingVisitor.getArrayDimensions(patternType);
        if (this.myMatchingVisitor.getMatchContext().getPattern().isTypedVar(patternElement)) {
            SubstitutionHandler handler2 = (SubstitutionHandler)this.myMatchingVisitor.getMatchContext().getPattern().getHandler(patternElement);
            RegExpPredicate regExpPredicate = null;
            if (patternArrayDimensions != 0) {
                if (patternArrayDimensions != matchedArrayDimensions) {
                    return false;
                }
            } else if (matchedArrayDimensions != 0 && (regExpPredicate = MatchingHandler.getSimpleRegExpPredicate(handler2)) != null) {
                regExpPredicate.setNodeTextGenerator(new RegExpPredicate.NodeTextGenerator(){

                    @Override
                    public String getText(PsiElement element) {
                        StringBuilder builder = new StringBuilder(RegExpPredicate.getMeaningfulText(element));
                        for (int i = 0; i < matchedArrayDimensions; ++i) {
                            builder.append("[]");
                        }
                        return builder.toString();
                    }
                });
            }
            try {
                if (handler2.isSubtype() || handler2.isStrictSubtype()) {
                    boolean bl = this.checkMatchWithingHierarchy(matchedElement, handler2, patternElement);
                    return bl;
                }
                boolean bl = handler2.handle(matchedElement, this.myMatchingVisitor.getMatchContext());
                return bl;
            }
            finally {
                if (regExpPredicate != null) {
                    regExpPredicate.setNodeTextGenerator(null);
                }
            }
        }
        if (matchedArrayDimensions != patternArrayDimensions) {
            return false;
        }
        if (patternElement instanceof PsiIdentifier && (parent = patternElement.getParent()) instanceof PsiJavaCodeReferenceElement) {
            patternElement = parent;
        }
        if (matchedElement instanceof PsiIdentifier && (parent = matchedElement.getParent()) instanceof PsiJavaCodeReferenceElement) {
            matchedElement = parent;
        }
        if ((equalsIgnorePackage = MatchUtils.compareWithNoDifferenceToPackage(text = JavaMatchingVisitor.getText(patternElement), text2 = JavaMatchingVisitor.getText(matchedElement), !(caseSensitive = this.myMatchingVisitor.getMatchContext().getOptions().isCaseSensitiveMatch()))) || !(matchedElement instanceof PsiJavaReference)) {
            return equalsIgnorePackage;
        }
        PsiElement element2 = ((PsiJavaReference)matchedElement).resolve();
        if (element2 instanceof PsiClass) {
            String name = ((PsiClass)element2).getQualifiedName();
            return caseSensitive ? text.equals(name) : text.equalsIgnoreCase(name);
        }
        return MatchUtils.compareWithNoDifferenceToPackage(text, text2, !caseSensitive);
    }

    @Contract(pure=true)
    private static String getText(@NotNull PsiElement element) {
        int index;
        int whitespace;
        String result;
        if (element instanceof PsiClass) {
            result = ((PsiClass)element).getQualifiedName();
            if (result == null) {
                result = element.getText();
            }
        } else {
            result = element.getText();
        }
        if ((whitespace = JavaMatchingVisitor.lastIndexOfWhitespace(result)) >= 0) {
            result = result.substring(whitespace + 1);
        }
        if ((index = result.indexOf(60)) == -1) {
            return result;
        }
        return result.substring(0, index);
    }

    @Contract(pure=true)
    private static int lastIndexOfWhitespace(@NotNull CharSequence s) {
        for (int i = s.length() - 1; i >= 0; --i) {
            if (!Character.isWhitespace(s.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    private boolean checkMatchWithingHierarchy(PsiElement el2, SubstitutionHandler handler2, PsiElement context) {
        PsiElement grandParentContext;
        boolean includeInterfaces = true;
        boolean includeClasses = true;
        PsiElement contextParent = context.getParent();
        if (contextParent instanceof PsiReferenceList && (grandParentContext = contextParent.getParent()) instanceof PsiClass) {
            PsiClass psiClass = (PsiClass)grandParentContext;
            if (contextParent == psiClass.getExtendsList()) {
                includeInterfaces = psiClass.isInterface();
            } else if (contextParent == psiClass.getImplementsList()) {
                includeClasses = false;
            }
        }
        HierarchyNodeIterator node = new HierarchyNodeIterator(el2, includeClasses, includeInterfaces);
        if (handler2.isStrictSubtype()) {
            ((NodeIterator)node).advance();
        }
        boolean notPredicate = handler2.getPredicate() instanceof NotPredicate;
        while (((NodeIterator)node).hasNext() && !handler2.validate(((NodeIterator)node).current(), 0, -1, this.myMatchingVisitor.getMatchContext())) {
            if (notPredicate) {
                return false;
            }
            ((NodeIterator)node).advance();
        }
        if (((NodeIterator)node).hasNext()) {
            handler2.addResult(el2, 0, -1, this.myMatchingVisitor.getMatchContext());
            return true;
        }
        return false;
    }

    public void visitConditionalExpression(PsiConditionalExpression cond) {
        PsiConditionalExpression cond2 = (PsiConditionalExpression)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)cond.getCondition(), (PsiElement)cond2.getCondition()) && this.myMatchingVisitor.matchSons((PsiElement)cond, (PsiElement)cond2));
    }

    public void visitPolyadicExpression(PsiPolyadicExpression expression) {
        PsiPolyadicExpression expr2 = (PsiPolyadicExpression)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(expression.getOperationTokenType().equals(expr2.getOperationTokenType()));
        if (this.myMatchingVisitor.getResult()) {
            PsiExpression[] operands1 = expression.getOperands();
            PsiExpression[] operands2 = expr2.getOperands();
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSequentially(new ArrayBackedNodeIterator((PsiElement[])operands1), new ArrayBackedNodeIterator((PsiElement[])operands2)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitVariable(PsiVariable var) {
        this.myMatchingVisitor.getMatchContext().pushResult();
        PsiIdentifier nameIdentifier = var.getNameIdentifier();
        boolean isTypedVar = this.myMatchingVisitor.getMatchContext().getPattern().isTypedVar((PsiElement)nameIdentifier);
        PsiVariable var2 = (PsiVariable)this.myMatchingVisitor.getElement();
        try {
            PsiTypeElement typeElement1;
            this.myMatchingVisitor.setResult((this.myMatchingVisitor.matchText((PsiElement)var.getNameIdentifier(), (PsiElement)var2.getNameIdentifier()) || isTypedVar) && this.myMatchingVisitor.match((PsiElement)var.getModifierList(), (PsiElement)var2.getModifierList()));
            if (this.myMatchingVisitor.getResult() && (typeElement1 = var.getTypeElement()) != null) {
                PsiTypeElement typeElement2 = var2.getTypeElement();
                if (typeElement2 == null) {
                    typeElement2 = JavaPsiFacade.getElementFactory((Project)var2.getProject()).createTypeElement(var2.getType());
                }
                this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)typeElement1, (PsiElement)typeElement2));
            }
            if (this.myMatchingVisitor.getResult()) {
                PsiExpression initializer = var.getInitializer();
                PsiExpression var2Initializer = var2.getInitializer();
                this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)initializer, (PsiElement)var2Initializer));
            }
            if (this.myMatchingVisitor.getResult() && var instanceof PsiParameter && var.getParent() instanceof PsiCatchSection) {
                this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)((PsiCatchSection)var.getParent()).getCatchBlock(), (PsiElement)((PsiCatchSection)var2.getParent()).getCatchBlock()));
            }
        }
        finally {
            this.saveOrDropResult(nameIdentifier, isTypedVar, var2.getNameIdentifier());
        }
    }

    private void matchArrayDims(PsiNewExpression new1, PsiNewExpression new2) {
        PsiExpression[] arrayDims2;
        PsiExpression[] arrayDims = new1.getArrayDimensions();
        if (arrayDims.length == (arrayDims2 = new2.getArrayDimensions()).length && arrayDims.length != 0) {
            for (int i = 0; i < arrayDims.length; ++i) {
                this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)arrayDims[i], (PsiElement)arrayDims2[i]));
                if (this.myMatchingVisitor.getResult()) continue;
                return;
            }
        } else {
            this.myMatchingVisitor.setResult(arrayDims == arrayDims2 && this.myMatchingVisitor.matchSons((PsiElement)new1.getArgumentList(), (PsiElement)new2.getArgumentList()));
        }
    }

    private void saveOrDropResult(PsiIdentifier methodNameNode, boolean typedVar, PsiIdentifier methodNameNode2) {
        MatchResultImpl ourResult = this.myMatchingVisitor.getMatchContext().hasResult() ? this.myMatchingVisitor.getMatchContext().getResult() : null;
        this.myMatchingVisitor.getMatchContext().popResult();
        if (this.myMatchingVisitor.getResult()) {
            if (typedVar) {
                SubstitutionHandler handler2 = (SubstitutionHandler)this.myMatchingVisitor.getMatchContext().getPattern().getHandler((PsiElement)methodNameNode);
                if (ourResult != null) {
                    ourResult.setScopeMatch(true);
                }
                handler2.setNestedResult(ourResult);
                this.myMatchingVisitor.setResult(handler2.handle((PsiElement)methodNameNode2, this.myMatchingVisitor.getMatchContext()));
                if (handler2.getNestedResult() != null) {
                    handler2.setNestedResult(null);
                    this.copyResults(ourResult);
                }
            } else if (ourResult != null) {
                this.copyResults(ourResult);
            }
        }
    }

    private void matchImplicitQualifier(MatchingHandler matchingHandler, PsiElement target, MatchContext context) {
        if (!(matchingHandler instanceof SubstitutionHandler)) {
            this.myMatchingVisitor.setResult(false);
            return;
        }
        SubstitutionHandler substitutionHandler = (SubstitutionHandler)matchingHandler;
        MatchPredicate predicate = substitutionHandler.getPredicate();
        if (substitutionHandler.getMinOccurs() != 0) {
            this.myMatchingVisitor.setResult(false);
            return;
        }
        if (predicate == null) {
            this.myMatchingVisitor.setResult(true);
            return;
        }
        if (target == null) {
            this.myMatchingVisitor.setResult(false);
            return;
        }
        if (target instanceof PsiModifierListOwner && ((PsiModifierListOwner)target).hasModifierProperty("static")) {
            this.myMatchingVisitor.setResult(predicate.match(null, PsiTreeUtil.getParentOfType((PsiElement)target, PsiClass.class), context));
        } else {
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)target.getProject());
            PsiExpression implicitReference = factory.createExpressionFromText("this", target);
            this.myMatchingVisitor.setResult(predicate.match(null, (PsiElement)implicitReference, context));
        }
    }

    public void visitMethodCallExpression(PsiMethodCallExpression mcall) {
        PsiElement element = this.myMatchingVisitor.getElement();
        if (!(element instanceof PsiMethodCallExpression)) {
            this.myMatchingVisitor.setResult(false);
            return;
        }
        PsiMethodCallExpression mcall2 = (PsiMethodCallExpression)element;
        PsiReferenceExpression mcallRef1 = mcall.getMethodExpression();
        PsiReferenceExpression mcallRef2 = mcall2.getMethodExpression();
        boolean isTypedVar = this.myMatchingVisitor.getMatchContext().getPattern().isTypedVar(mcallRef1.getReferenceNameElement());
        if (!this.myMatchingVisitor.matchText(mcallRef1.getReferenceNameElement(), mcallRef2.getReferenceNameElement()) && !isTypedVar) {
            this.myMatchingVisitor.setResult(false);
            return;
        }
        PsiExpression qualifier = mcallRef1.getQualifierExpression();
        PsiExpression elementQualifier = mcallRef2.getQualifierExpression();
        if (qualifier != null) {
            if (elementQualifier != null) {
                this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)qualifier, (PsiElement)elementQualifier));
                if (!this.myMatchingVisitor.getResult()) {
                    return;
                }
            } else {
                PsiMethod method = mcall2.resolveMethod();
                if (method != null && qualifier instanceof PsiThisExpression) {
                    this.myMatchingVisitor.setResult(!method.hasModifierProperty("static"));
                    return;
                }
                MatchingHandler handler2 = this.myMatchingVisitor.getMatchContext().getPattern().getHandler((PsiElement)qualifier);
                this.matchImplicitQualifier(handler2, (PsiElement)method, this.myMatchingVisitor.getMatchContext());
                if (!this.myMatchingVisitor.getResult()) {
                    return;
                }
            }
        } else if (elementQualifier != null) {
            this.myMatchingVisitor.setResult(false);
            return;
        }
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSons((PsiElement)mcall.getArgumentList(), (PsiElement)mcall2.getArgumentList()));
        if (this.myMatchingVisitor.getResult() && isTypedVar) {
            boolean res = this.myMatchingVisitor.getResult();
            this.myMatchingVisitor.setResult(res &= this.myMatchingVisitor.handleTypedElement(mcallRef1.getReferenceNameElement(), mcallRef2.getReferenceNameElement()));
        }
    }

    public void visitExpressionStatement(PsiExpressionStatement expr) {
        PsiElement other = this.myMatchingVisitor.getElement();
        if (other instanceof PsiExpressionStatement) {
            PsiExpressionStatement expr2 = (PsiExpressionStatement)other;
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)expr.getExpression(), (PsiElement)expr2.getExpression()));
        } else {
            this.myMatchingVisitor.setResult(false);
        }
    }

    public void visitLiteralExpression(PsiLiteralExpression const1) {
        PsiLiteralExpression const2 = (PsiLiteralExpression)this.myMatchingVisitor.getElement();
        MatchingHandler handler2 = (MatchingHandler)const1.getUserData(CompiledPattern.HANDLER_KEY);
        if (handler2 instanceof SubstitutionHandler) {
            PsiType type1 = const1.getType();
            if (type1 != null && !type1.equals(const2.getType())) {
                this.myMatchingVisitor.setResult(false);
            } else {
                int offset = 0;
                int length = const2.getTextLength();
                String text = const2.getText();
                if (length > 2 && text.charAt(0) == '\"' && text.charAt(length - 1) == '\"') {
                    --length;
                    ++offset;
                }
                this.myMatchingVisitor.setResult(((SubstitutionHandler)handler2).handle((PsiElement)const2, offset, length, this.myMatchingVisitor.getMatchContext()));
            }
        } else if (handler2 != null) {
            this.myMatchingVisitor.setResult(handler2.match((PsiElement)const1, (PsiElement)const2, this.myMatchingVisitor.getMatchContext()));
        } else {
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchText((PsiElement)const1, (PsiElement)const2));
        }
    }

    public void visitAssignmentExpression(PsiAssignmentExpression assign) {
        PsiElement other = this.myMatchingVisitor.getElement();
        if (other instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assign2 = (PsiAssignmentExpression)other;
            this.myMatchingVisitor.setResult(assign.getOperationTokenType().equals(assign2.getOperationTokenType()) && this.myMatchingVisitor.match((PsiElement)assign.getLExpression(), (PsiElement)assign2.getLExpression()) && this.myMatchingVisitor.match((PsiElement)assign.getRExpression(), (PsiElement)assign2.getRExpression()));
        } else {
            this.myMatchingVisitor.setResult(false);
        }
    }

    public void visitIfStatement(PsiIfStatement if1) {
        PsiIfStatement if2 = (PsiIfStatement)this.myMatchingVisitor.getElement();
        PsiStatement elseBranch = if1.getElseBranch();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)if1.getCondition(), (PsiElement)if2.getCondition()) && this.compareBody((PsiElement)if1.getThenBranch(), (PsiElement)if2.getThenBranch()) && (elseBranch == null || this.compareBody((PsiElement)elseBranch, (PsiElement)if2.getElseBranch())));
    }

    public void visitSwitchStatement(PsiSwitchStatement switch1) {
        PsiSwitchStatement switch2 = (PsiSwitchStatement)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)switch1.getExpression(), (PsiElement)switch2.getExpression()) && this.myMatchingVisitor.matchSons((PsiElement)switch1.getBody(), (PsiElement)switch2.getBody()));
    }

    public void visitForStatement(PsiForStatement for1) {
        PsiForStatement for2 = (PsiForStatement)this.myMatchingVisitor.getElement();
        PsiStatement initialization = for1.getInitialization();
        MatchingHandler handler2 = this.myMatchingVisitor.getMatchContext().getPattern().getHandler((PsiElement)initialization);
        this.myMatchingVisitor.setResult(handler2.match((PsiElement)initialization, (PsiElement)for2.getInitialization(), this.myMatchingVisitor.getMatchContext()) && this.myMatchingVisitor.match((PsiElement)for1.getCondition(), (PsiElement)for2.getCondition()) && this.myMatchingVisitor.match((PsiElement)for1.getUpdate(), (PsiElement)for2.getUpdate()) && this.compareBody((PsiElement)for1.getBody(), (PsiElement)for2.getBody()));
    }

    public void visitForeachStatement(PsiForeachStatement for1) {
        PsiForeachStatement for2 = (PsiForeachStatement)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)for1.getIterationParameter(), (PsiElement)for2.getIterationParameter()) && this.myMatchingVisitor.match((PsiElement)for1.getIteratedValue(), (PsiElement)for2.getIteratedValue()) && this.compareBody((PsiElement)for1.getBody(), (PsiElement)for2.getBody()));
    }

    public void visitWhileStatement(PsiWhileStatement while1) {
        PsiWhileStatement while2 = (PsiWhileStatement)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)while1.getCondition(), (PsiElement)while2.getCondition()) && this.compareBody((PsiElement)while1.getBody(), (PsiElement)while2.getBody()));
    }

    public void visitBlockStatement(PsiBlockStatement block) {
        PsiElement other = this.myMatchingVisitor.getElement();
        if (other instanceof PsiCodeBlock) {
            this.myMatchingVisitor.setResult(!(other.getParent() instanceof PsiBlockStatement) && this.myMatchingVisitor.matchSons((PsiElement)block.getCodeBlock(), other));
        } else {
            PsiBlockStatement block2 = (PsiBlockStatement)other;
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSons((PsiElement)block, (PsiElement)block2));
        }
    }

    public void visitDeclarationStatement(PsiDeclarationStatement dcl) {
        PsiDeclarationStatement declaration = (PsiDeclarationStatement)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchInAnyOrder(dcl.getDeclaredElements(), declaration.getDeclaredElements()));
    }

    public void visitDoWhileStatement(PsiDoWhileStatement while1) {
        PsiDoWhileStatement while2 = (PsiDoWhileStatement)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)while1.getCondition(), (PsiElement)while2.getCondition()) && this.compareBody((PsiElement)while1.getBody(), (PsiElement)while2.getBody()));
    }

    public void visitReturnStatement(PsiReturnStatement return1) {
        PsiReturnStatement return2 = (PsiReturnStatement)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)return1.getReturnValue(), (PsiElement)return2.getReturnValue()));
    }

    public void visitPostfixExpression(PsiPostfixExpression postfix) {
        PsiPostfixExpression postfix2 = (PsiPostfixExpression)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(postfix.getOperationTokenType().equals(postfix2.getOperationTokenType()) && this.myMatchingVisitor.match((PsiElement)postfix.getOperand(), (PsiElement)postfix2.getOperand()));
    }

    public void visitPrefixExpression(PsiPrefixExpression prefix) {
        PsiPrefixExpression prefix2 = (PsiPrefixExpression)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(prefix.getOperationTokenType().equals(prefix2.getOperationTokenType()) && this.myMatchingVisitor.match((PsiElement)prefix.getOperand(), (PsiElement)prefix2.getOperand()));
    }

    public void visitAssertStatement(PsiAssertStatement assert1) {
        PsiAssertStatement assert2 = (PsiAssertStatement)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)assert1.getAssertCondition(), (PsiElement)assert2.getAssertCondition()) && this.myMatchingVisitor.match((PsiElement)assert1.getAssertDescription(), (PsiElement)assert2.getAssertDescription()));
    }

    public void visitBreakStatement(PsiBreakStatement break1) {
        PsiBreakStatement break2 = (PsiBreakStatement)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)break1.getLabelIdentifier(), (PsiElement)break2.getLabelIdentifier()));
    }

    public void visitContinueStatement(PsiContinueStatement continue1) {
        PsiContinueStatement continue2 = (PsiContinueStatement)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)continue1.getLabelIdentifier(), (PsiElement)continue2.getLabelIdentifier()));
    }

    public void visitSuperExpression(PsiSuperExpression super1) {
        this.myMatchingVisitor.setResult(true);
    }

    public void visitThisExpression(PsiThisExpression this1) {
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.getElement() instanceof PsiThisExpression);
    }

    public void visitSynchronizedStatement(PsiSynchronizedStatement synchronized1) {
        PsiSynchronizedStatement synchronized2 = (PsiSynchronizedStatement)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)synchronized1.getLockExpression(), (PsiElement)synchronized2.getLockExpression()) && this.myMatchingVisitor.matchSons((PsiElement)synchronized1.getBody(), (PsiElement)synchronized2.getBody()));
    }

    public void visitThrowStatement(PsiThrowStatement throw1) {
        PsiThrowStatement throw2 = (PsiThrowStatement)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)throw1.getException(), (PsiElement)throw2.getException()));
    }

    public void visitParenthesizedExpression(PsiParenthesizedExpression expr) {
        if (this.myMatchingVisitor.getElement() instanceof PsiParenthesizedExpression) {
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSons((PsiElement)expr, this.myMatchingVisitor.getElement()));
        } else {
            this.myMatchingVisitor.setResult(false);
        }
    }

    public void visitCatchSection(PsiCatchSection section) {
        PsiCatchSection section2 = (PsiCatchSection)this.myMatchingVisitor.getElement();
        PsiParameter parameter = section.getParameter();
        if (parameter != null) {
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)parameter, (PsiElement)section2.getParameter()));
        } else {
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)section.getCatchBlock(), (PsiElement)section2.getCatchBlock()));
        }
    }

    public void visitTryStatement(PsiTryStatement try1) {
        PsiTryStatement try2 = (PsiTryStatement)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSons((PsiElement)try1.getTryBlock(), (PsiElement)try2.getTryBlock()));
        if (!this.myMatchingVisitor.getResult()) {
            return;
        }
        PsiResourceList resourceList1 = try1.getResourceList();
        PsiCatchSection[] catches1 = try1.getCatchSections();
        PsiCodeBlock finally1 = try1.getFinallyBlock();
        PsiResourceList resourceList2 = try2.getResourceList();
        Object[] catches2 = try2.getCatchSections();
        PsiCodeBlock finally2 = try2.getFinallyBlock();
        if (!this.myMatchingVisitor.getMatchContext().getOptions().isLooseMatching() && (catches1.length == 0 && catches2.length != 0 || finally1 == null && finally2 != null || resourceList1 == null && resourceList2 != null) || catches2.length < catches1.length) {
            this.myMatchingVisitor.setResult(false);
        } else {
            ArrayList<Object> unmatchedElements = new ArrayList<Object>();
            if (resourceList1 != null) {
                if (resourceList2 == null) {
                    this.myMatchingVisitor.setResult(false);
                    return;
                }
                List resources1 = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)resourceList1, PsiResourceListElement.class);
                List resources2 = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)resourceList2, PsiResourceListElement.class);
                this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchInAnyOrder((PsiElement[])resources1.toArray(new PsiResourceListElement[resources1.size()]), (PsiElement[])resources2.toArray(new PsiResourceListElement[resources2.size()])));
                if (!this.myMatchingVisitor.getResult()) {
                    return;
                }
            } else if (resourceList2 != null) {
                unmatchedElements.add(resourceList2);
            }
            ContainerUtil.addAll(unmatchedElements, (Object[])catches2);
            for (PsiCatchSection catchSection : catches1) {
                MatchingHandler handler2 = this.myMatchingVisitor.getMatchContext().getPattern().getHandler((PsiElement)catchSection);
                PsiElement pinnedNode = handler2.getPinnedNode(null);
                if (pinnedNode != null) {
                    this.myMatchingVisitor.setResult(handler2.match((PsiElement)catchSection, pinnedNode, this.myMatchingVisitor.getMatchContext()));
                    if (this.myMatchingVisitor.getResult()) continue;
                    return;
                }
                boolean matched = false;
                for (int j = 0; j < unmatchedElements.size(); ++j) {
                    if (!handler2.match((PsiElement)catchSection, (PsiElement)unmatchedElements.get(j), this.myMatchingVisitor.getMatchContext())) continue;
                    unmatchedElements.remove(j);
                    matched = true;
                    break;
                }
                if (matched) continue;
                this.myMatchingVisitor.setResult(false);
                return;
            }
            if (finally1 != null) {
                this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSons((PsiElement)finally1, (PsiElement)finally2));
            } else if (finally2 != null) {
                unmatchedElements.add(finally2);
            }
            if (this.myMatchingVisitor.getResult() && unmatchedElements.size() > 0) {
                try2.putUserData(GlobalMatchingVisitor.UNMATCHED_ELEMENTS_KEY, unmatchedElements);
            }
        }
    }

    public void visitSwitchLabelStatement(PsiSwitchLabelStatement case1) {
        PsiSwitchLabelStatement case2 = (PsiSwitchLabelStatement)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(case1.isDefaultCase() == case2.isDefaultCase() && this.myMatchingVisitor.match((PsiElement)case1.getCaseValue(), (PsiElement)case2.getCaseValue()));
    }

    public void visitInstanceOfExpression(PsiInstanceOfExpression instanceOf) {
        PsiElement other = this.myMatchingVisitor.getElement();
        if (other instanceof PsiInstanceOfExpression) {
            PsiTypeElement checkType;
            PsiInstanceOfExpression instanceOf2 = (PsiInstanceOfExpression)other;
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)instanceOf.getOperand(), (PsiElement)instanceOf2.getOperand()));
            if (this.myMatchingVisitor.getResult() && (checkType = instanceOf.getCheckType()) != null) {
                this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)checkType, (PsiElement)instanceOf2.getCheckType()));
            }
        } else {
            this.myMatchingVisitor.setResult(false);
        }
    }

    public void visitNewExpression(PsiNewExpression new1) {
        PsiElement other = this.myMatchingVisitor.getElement();
        PsiJavaCodeReferenceElement classReference = new1.getClassReference();
        if (other instanceof PsiArrayInitializerExpression && other.getParent() instanceof PsiVariable && new1.getArrayDimensions().length == 0 && new1.getArrayInitializer() != null) {
            MatchContext matchContext = this.myMatchingVisitor.getMatchContext();
            MatchingHandler handler2 = matchContext.getPattern().getHandler((PsiElement)classReference);
            boolean looseMatching = this.myMatchingVisitor.getMatchContext().getOptions().isLooseMatching();
            if (handler2 instanceof SubstitutionHandler && ((SubstitutionHandler)handler2).getMinOccurs() != 0 || !looseMatching) {
                this.myMatchingVisitor.setResult(false);
                return;
            }
            PsiType otherType = ((PsiArrayInitializerExpression)other).getType();
            if (handler2 instanceof SubstitutionHandler && otherType != null) {
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)other.getProject());
                PsiTypeElement otherTypeElement = factory.createTypeElement(otherType.getDeepComponentType());
                SubstitutionHandler substitutionHandler = (SubstitutionHandler)handler2;
                MatchPredicate predicate = substitutionHandler.getPredicate();
                this.myMatchingVisitor.setResult(predicate == null || predicate.match(null, (PsiElement)otherTypeElement, matchContext));
            } else {
                PsiType type = new1.getType();
                this.myMatchingVisitor.setResult(type != null && type.equals(otherType));
            }
            if (this.myMatchingVisitor.getResult()) {
                this.myMatchingVisitor.matchSons((PsiElement)new1.getArrayInitializer(), other);
            }
            return;
        }
        if (!(other instanceof PsiNewExpression)) {
            this.myMatchingVisitor.setResult(false);
            return;
        }
        PsiNewExpression new2 = (PsiNewExpression)other;
        if (classReference != null) {
            if (new2.getClassReference() != null) {
                this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)classReference, (PsiElement)new2.getClassReference()) && this.myMatchingVisitor.matchSons((PsiElement)new1.getArrayInitializer(), (PsiElement)new2.getArrayInitializer()));
                if (this.myMatchingVisitor.getResult()) {
                    this.matchArrayDims(new1, new2);
                }
                return;
            }
            PsiKeyword newKeyword = (PsiKeyword)PsiTreeUtil.getChildOfType((PsiElement)new2, PsiKeyword.class);
            PsiElement element = PsiTreeUtil.getNextSiblingOfType((PsiElement)newKeyword, PsiWhiteSpace.class);
            if (element != null && element.getNextSibling() instanceof PsiKeyword) {
                ((LexicalNodesFilter)LexicalNodesFilter.getInstance()).setCareKeyWords(true);
                this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)classReference, element.getNextSibling()) && this.myMatchingVisitor.matchSons((PsiElement)new1.getArrayInitializer(), (PsiElement)new2.getArrayInitializer()));
                ((LexicalNodesFilter)LexicalNodesFilter.getInstance()).setCareKeyWords(false);
                if (this.myMatchingVisitor.getResult()) {
                    this.matchArrayDims(new1, new2);
                }
                return;
            }
        }
        if (classReference == new2.getClassReference()) {
            ((LexicalNodesFilter)LexicalNodesFilter.getInstance()).setCareKeyWords(true);
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSons((PsiElement)new1, (PsiElement)new2));
            ((LexicalNodesFilter)LexicalNodesFilter.getInstance()).setCareKeyWords(false);
        } else if (new1.getAnonymousClass() == null && classReference != null && new2.getAnonymousClass() != null) {
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)classReference, (PsiElement)new2.getAnonymousClass().getBaseClassReference()) && this.myMatchingVisitor.matchSons((PsiElement)new1.getArgumentList(), (PsiElement)new2.getArgumentList()));
        } else {
            this.myMatchingVisitor.setResult(false);
        }
    }

    public void visitKeyword(PsiKeyword keyword) {
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchText((PsiElement)keyword, this.myMatchingVisitor.getElement()));
    }

    public void visitTypeCastExpression(PsiTypeCastExpression cast) {
        PsiElement other = this.myMatchingVisitor.getElement();
        if (other instanceof PsiTypeCastExpression) {
            PsiTypeCastExpression cast2 = (PsiTypeCastExpression)other;
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)cast.getCastType(), (PsiElement)cast2.getCastType()) && this.myMatchingVisitor.match((PsiElement)cast.getOperand(), (PsiElement)cast2.getOperand()));
        } else {
            this.myMatchingVisitor.setResult(false);
        }
    }

    public void visitClassObjectAccessExpression(PsiClassObjectAccessExpression expr) {
        PsiElement other = this.myMatchingVisitor.getElement();
        if (other instanceof PsiClassObjectAccessExpression) {
            PsiClassObjectAccessExpression expr2 = (PsiClassObjectAccessExpression)other;
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)expr.getOperand(), (PsiElement)expr2.getOperand()));
        } else {
            this.myMatchingVisitor.setResult(false);
        }
    }

    public void visitReferenceElement(PsiJavaCodeReferenceElement ref) {
        PsiElement other = this.myMatchingVisitor.getElement();
        PsiAnnotation[] annotations = (PsiAnnotation[])PsiTreeUtil.getChildrenOfType((PsiElement)ref, PsiAnnotation.class);
        if (annotations != null) {
            PsiAnnotation[] otherAnnotations = (PsiAnnotation[])PsiTreeUtil.getChildrenOfType((PsiElement)other, PsiAnnotation.class);
            this.myMatchingVisitor.setResult(otherAnnotations != null && this.myMatchingVisitor.matchInAnyOrder((PsiElement[])annotations, (PsiElement[])otherAnnotations));
            if (!this.myMatchingVisitor.getResult()) {
                return;
            }
        }
        this.myMatchingVisitor.setResult(this.matchType((PsiElement)ref, other));
    }

    public void visitTypeElement(PsiTypeElement typeElement) {
        PsiTypeElement[] typeElementChildren;
        PsiElement other = this.myMatchingVisitor.getElement();
        PsiAnnotation[] annotations = (PsiAnnotation[])PsiTreeUtil.getChildrenOfType((PsiElement)typeElement, PsiAnnotation.class);
        PsiAnnotation[] annotations2 = (PsiAnnotation[])PsiTreeUtil.getChildrenOfType((PsiElement)other, PsiAnnotation.class);
        if (annotations != null) {
            this.myMatchingVisitor.setResult(annotations2 != null && this.myMatchingVisitor.matchInAnyOrder((PsiElement[])annotations, (PsiElement[])annotations2));
            if (!this.myMatchingVisitor.getResult()) {
                return;
            }
        }
        if ((typeElementChildren = (PsiTypeElement[])PsiTreeUtil.getChildrenOfType((PsiElement)typeElement, PsiTypeElement.class)) != null && typeElementChildren.length > 1) {
            PsiTypeElement[] typeElementChildren2 = (PsiTypeElement[])PsiTreeUtil.getChildrenOfType((PsiElement)other, PsiTypeElement.class);
            this.myMatchingVisitor.setResult(typeElementChildren2 != null && this.myMatchingVisitor.matchInAnyOrder((PsiElement[])typeElementChildren, (PsiElement[])typeElementChildren2));
        } else {
            this.myMatchingVisitor.setResult(this.matchType((PsiElement)typeElement, other));
        }
    }

    public void visitTypeParameter(PsiTypeParameter psiTypeParameter) {
        PsiTypeParameter parameter = (PsiTypeParameter)this.myMatchingVisitor.getElement();
        PsiIdentifier identifier = psiTypeParameter.getNameIdentifier();
        PsiIdentifier identifier2 = parameter.getNameIdentifier();
        MatchingHandler handler2 = this.myMatchingVisitor.getMatchContext().getPattern().getHandler((PsiElement)identifier);
        if (handler2 instanceof SubstitutionHandler) {
            this.myMatchingVisitor.setResult(((SubstitutionHandler)handler2).handle((PsiElement)identifier2, this.myMatchingVisitor.getMatchContext()));
        } else {
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchText((PsiElement)identifier, (PsiElement)identifier2));
        }
        if (this.myMatchingVisitor.getResult()) {
            this.myMatchingVisitor.setResult(this.matchInAnyOrder(psiTypeParameter.getExtendsList(), parameter.getExtendsList()));
        }
        if (this.myMatchingVisitor.getResult()) {
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchInAnyOrder((PsiElement[])psiTypeParameter.getAnnotations(), (PsiElement[])parameter.getAnnotations()));
        }
    }

    public void visitClass(PsiClass clazz) {
        if (clazz.hasTypeParameters()) {
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)clazz.getTypeParameterList(), (PsiElement)((PsiClass)this.myMatchingVisitor.getElement()).getTypeParameterList()));
            if (!this.myMatchingVisitor.getResult()) {
                return;
            }
        }
        PsiClass clazz2 = this.myMatchingVisitor.getElement() instanceof PsiDeclarationStatement && this.myMatchingVisitor.getElement().getFirstChild() instanceof PsiClass ? (PsiClass)this.myMatchingVisitor.getElement().getFirstChild() : (PsiClass)this.myMatchingVisitor.getElement();
        boolean isTypedVar = this.myMatchingVisitor.getMatchContext().getPattern().isTypedVar((PsiElement)clazz.getNameIdentifier());
        if (clazz.getModifierList().getTextLength() > 0 && !this.myMatchingVisitor.match((PsiElement)clazz.getModifierList(), (PsiElement)clazz2.getModifierList())) {
            this.myMatchingVisitor.setResult(false);
            return;
        }
        this.myMatchingVisitor.setResult((this.myMatchingVisitor.matchText((PsiElement)clazz.getNameIdentifier(), (PsiElement)clazz2.getNameIdentifier()) || isTypedVar) && this.compareClasses(clazz, clazz2));
        if (this.myMatchingVisitor.getResult() && isTypedVar) {
            PsiIdentifier id = clazz2.getNameIdentifier();
            if (id == null) {
                id = clazz2;
            }
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.handleTypedElement((PsiElement)clazz.getNameIdentifier(), (PsiElement)id));
        }
    }

    public void visitTypeParameterList(PsiTypeParameterList psiTypeParameterList) {
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSequentially(psiTypeParameterList.getFirstChild(), this.myMatchingVisitor.getElement().getFirstChild()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitMethod(PsiMethod method) {
        PsiIdentifier methodNameNode = method.getNameIdentifier();
        boolean isTypedVar = this.myMatchingVisitor.getMatchContext().getPattern().isTypedVar((PsiElement)methodNameNode);
        PsiMethod method2 = (PsiMethod)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.getMatchContext().pushResult();
        try {
            PsiDocComment docComment = method.getDocComment();
            if (docComment != null) {
                this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)docComment, (PsiElement)method2));
                if (!this.myMatchingVisitor.getResult()) {
                    return;
                }
            }
            if (method.hasTypeParameters()) {
                this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)method.getTypeParameterList(), (PsiElement)((PsiMethod)this.myMatchingVisitor.getElement()).getTypeParameterList()));
                if (!this.myMatchingVisitor.getResult()) {
                    return;
                }
            }
            if (!this.checkHierarchy((PsiMember)method2, (PsiMember)method)) {
                this.myMatchingVisitor.setResult(false);
                return;
            }
            this.myMatchingVisitor.setResult((this.myMatchingVisitor.matchText((PsiElement)method.getNameIdentifier(), (PsiElement)method2.getNameIdentifier()) || isTypedVar) && this.myMatchingVisitor.match((PsiElement)method.getModifierList(), (PsiElement)method2.getModifierList()) && this.myMatchingVisitor.matchSons((PsiElement)method.getParameterList(), (PsiElement)method2.getParameterList()) && this.myMatchingVisitor.match((PsiElement)method.getReturnTypeElement(), (PsiElement)method2.getReturnTypeElement()) && this.matchInAnyOrder(method.getThrowsList(), method2.getThrowsList()) && this.myMatchingVisitor.matchSonsOptionally((PsiElement)method.getBody(), (PsiElement)method2.getBody()));
        }
        finally {
            this.saveOrDropResult(methodNameNode, isTypedVar, method2.getNameIdentifier());
        }
    }

    static {
        Arrays.sort(MODIFIERS);
    }
}

