/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spi.psi;

import com.intellij.extapi.psi.PsiFileBase;
import com.intellij.lang.Language;
import com.intellij.lang.spi.SPILanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.ClassUtil;
import com.intellij.spi.SPIFileType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SPIFile
extends PsiFileBase {
    public SPIFile(@NotNull FileViewProvider viewProvider) {
        super(viewProvider, (Language)SPILanguage.INSTANCE);
    }

    @Override
    @NotNull
    public PsiReference getReference() {
        return new SPIFileName2ClassReference(this, (PsiClass)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiClass>(){

            public PsiClass compute() {
                return ClassUtil.findPsiClass((PsiManager)SPIFile.this.getManager(), (String)SPIFile.this.getName(), null, (boolean)true, (GlobalSearchScope)SPIFile.this.getResolveScope());
            }
        }));
    }

    @Override
    @NotNull
    public PsiReference[] getReferences() {
        return (PsiReference[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiReference[]>(){

            public PsiReference[] compute() {
                int d;
                ArrayList<SPIFileName2PackageReference> refs = new ArrayList<SPIFileName2PackageReference>();
                int idx = 0;
                String fileName = SPIFile.this.getName();
                while ((d = fileName.indexOf(".", idx)) > -1) {
                    PsiPackage aPackage = JavaPsiFacade.getInstance((Project)SPIFile.this.getProject()).findPackage(fileName.substring(0, d));
                    if (aPackage != null) {
                        refs.add(new SPIFileName2PackageReference(SPIFile.this, (PsiElement)aPackage));
                    }
                    idx = d + 1;
                }
                PsiReference reference = SPIFile.this.getReference();
                PsiElement resolve = reference.resolve();
                while (resolve instanceof PsiClass) {
                    String jvmClassName;
                    if ((resolve = ((PsiClass)resolve).getContainingClass()) == null || (jvmClassName = ClassUtil.getJVMClassName((PsiClass)((PsiClass)resolve))) == null) continue;
                    refs.add(new SPIFileName2PackageReference(SPIFile.this, resolve));
                }
                refs.add((SPIFileName2PackageReference)reference);
                return refs.toArray(new PsiReference[refs.size()]);
            }
        });
    }

    @NotNull
    public FileType getFileType() {
        return SPIFileType.INSTANCE;
    }

    private static class SPIFileName2PackageReference
    extends PsiReferenceBase<PsiFile> {
        private final PsiElement myPackageOrContainingClass;

        public SPIFileName2PackageReference(PsiFile file2, @NotNull PsiElement psiPackage) {
            super((PsiElement)file2, new TextRange(0, 0), false);
            this.myPackageOrContainingClass = psiPackage;
        }

        @NotNull
        public String getCanonicalText() {
            return this.myPackageOrContainingClass instanceof PsiPackage ? ((PsiPackage)this.myPackageOrContainingClass).getQualifiedName() : ClassUtil.getJVMClassName((PsiClass)((PsiClass)this.myPackageOrContainingClass));
        }

        @Nullable
        public PsiElement resolve() {
            return this.myPackageOrContainingClass;
        }

        public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
            return ((PsiFile)this.getElement()).setName(newElementName + ((PsiFile)this.getElement()).getName().substring(this.getCanonicalText().length()));
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            String className;
            if (element instanceof PsiPackage) {
                return this.handleElementRename(((PsiPackage)element).getQualifiedName());
            }
            if (element instanceof PsiClass && (className = ClassUtil.getJVMClassName((PsiClass)((PsiClass)element))) != null) {
                return this.handleElementRename(className);
            }
            return this.getElement();
        }

        @NotNull
        public Object[] getVariants() {
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
    }

    private static class SPIFileName2ClassReference
    extends PsiReferenceBase<PsiFile> {
        private final PsiClass myClass;

        public SPIFileName2ClassReference(PsiFile file2, PsiClass aClass) {
            super((PsiElement)file2, new TextRange(0, 0), false);
            this.myClass = aClass;
        }

        @Nullable
        public PsiElement resolve() {
            return this.myClass;
        }

        public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
            String className;
            if (this.myClass != null && (className = ClassUtil.getJVMClassName((PsiClass)this.myClass)) != null) {
                String newFileName = className.substring(0, className.lastIndexOf(this.myClass.getName())) + newElementName;
                return ((PsiFile)this.getElement()).setName(newFileName);
            }
            return this.getElement();
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            String className;
            if (element instanceof PsiClass && (className = ClassUtil.getJVMClassName((PsiClass)((PsiClass)element))) != null) {
                return ((PsiFile)this.getElement()).setName(className);
            }
            return this.getElement();
        }

        @NotNull
        public Object[] getVariants() {
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
    }
}

