/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spi;

import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.lang.spi.SPILanguage;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.ex.FileTypeIdentifiableByVirtualFile;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SPIFileType
extends LanguageFileType
implements FileTypeIdentifiableByVirtualFile {
    public static final SPIFileType INSTANCE = new SPIFileType();

    private SPIFileType() {
        super((Language)SPILanguage.INSTANCE);
    }

    @Override
    public boolean isMyFileType(@NotNull VirtualFile file2) {
        VirtualFile gParent;
        VirtualFile parent = file2.getParent();
        if (parent != null && Comparing.equal((CharSequence)"services", (CharSequence)parent.getNameSequence()) && (gParent = parent.getParent()) != null && Comparing.equal((CharSequence)"META-INF", (CharSequence)gParent.getNameSequence())) {
            String fileName = file2.getName();
            for (Object condition : Extensions.getExtensions((String)"com.intellij.vetoSPICondition")) {
                if (!((Condition)condition).value((Object)fileName)) continue;
                return false;
            }
            return FileTypeRegistry.getInstance().getFileTypeByFileName(fileName) == FileTypes.UNKNOWN;
        }
        return false;
    }

    @NotNull
    public String getName() {
        return "SPI";
    }

    @NotNull
    public String getDescription() {
        return "Service Provider Interface";
    }

    @NotNull
    public String getDefaultExtension() {
        return "";
    }

    @Nullable
    public Icon getIcon() {
        return AllIcons.FileTypes.Text;
    }

    public boolean isReadOnly() {
        return false;
    }

    @Nullable
    public String getCharset(@NotNull VirtualFile file2, @NotNull byte[] content) {
        return "UTF-8";
    }
}

