/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.util;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import java.text.StringCharacterIterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class Strings {
    private Strings() {
    }

    public static boolean isCapitalized(String word) {
        if (word.length() == 0) {
            return false;
        }
        boolean lowCase = true;
        for (int i = 1; i < word.length() && lowCase; ++i) {
            lowCase = Character.isLowerCase(word.charAt(i));
        }
        return Character.isUpperCase(word.charAt(0)) && lowCase;
    }

    public static boolean isCapitalized(@NotNull String text, @NotNull TextRange range) {
        if (range.getLength() == 0) {
            return false;
        }
        StringCharacterIterator it = new StringCharacterIterator(text, range.getStartOffset() + 1, range.getEndOffset(), range.getStartOffset() + 1);
        boolean lowCase = true;
        char c = it.first();
        while (c != '\uffff') {
            lowCase = Character.isLowerCase(c);
            c = it.next();
        }
        return Character.isUpperCase(text.charAt(range.getStartOffset())) && lowCase;
    }

    public static boolean isUpperCased(@NotNull String text, @NotNull TextRange range) {
        if (range.getLength() == 0) {
            return false;
        }
        StringCharacterIterator it = new StringCharacterIterator(text, range.getStartOffset(), range.getEndOffset(), range.getStartOffset());
        char c = it.first();
        while (c != '\uffff') {
            if (!Character.isUpperCase(c)) {
                return false;
            }
            c = it.next();
        }
        return true;
    }

    public static boolean isUpperCase(String word) {
        boolean upperCase = true;
        for (int i = 0; i < word.length() && upperCase; ++i) {
            upperCase = Character.isUpperCase(word.charAt(i));
        }
        return upperCase;
    }

    public static boolean isMixedCase(String word) {
        String lowerCase;
        if (word.length() < 2) {
            return false;
        }
        String tail = word.substring(1);
        return !tail.equals(lowerCase = tail.toLowerCase()) && !Strings.isUpperCase(word);
    }

    public static void capitalize(List<String> words) {
        for (int i = 0; i < words.size(); ++i) {
            words.set(i, StringUtil.capitalize((String)words.get(i)));
        }
    }

    public static void upperCase(List<String> words) {
        for (int i = 0; i < words.size(); ++i) {
            words.set(i, words.get(i).toUpperCase());
        }
    }
}

