/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.tokenizer;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.spellchecker.inspections.PlainTextSplitter;
import com.intellij.spellchecker.tokenizer.TokenConsumer;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import org.jetbrains.annotations.NotNull;

public abstract class EscapeSequenceTokenizer<T extends PsiElement>
extends Tokenizer<T> {
    private static Key<int[]> ESCAPE_OFFSETS = Key.create((String)"escape.tokenizer.offsets");

    public static void processTextWithOffsets(PsiElement element, TokenConsumer consumer, StringBuilder unescapedText, int[] offsets, int startOffset) {
        if (element != null) {
            element.putUserData(ESCAPE_OFFSETS, (Object)offsets);
        }
        String text = unescapedText.toString();
        consumer.consumeToken(element, text, false, startOffset, TextRange.allOf((String)text), PlainTextSplitter.getInstance());
        if (element != null) {
            element.putUserData(ESCAPE_OFFSETS, null);
        }
    }

    @Override
    @NotNull
    public TextRange getHighlightingRange(PsiElement element, int offset, TextRange range) {
        int[] offsets = (int[])element.getUserData(ESCAPE_OFFSETS);
        if (offsets != null) {
            int start = offsets[range.getStartOffset()];
            int end = offsets[range.getEndOffset()];
            return new TextRange(offset + start, offset + end);
        }
        return super.getHighlightingRange(element, offset, range);
    }
}

