/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.inspections;

import com.intellij.openapi.util.TextRange;
import com.intellij.spellchecker.inspections.BaseSplitter;
import com.intellij.spellchecker.inspections.IdentifierSplitter;
import com.intellij.util.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WordSplitter
extends BaseSplitter {
    private static final WordSplitter INSTANCE = new WordSplitter();
    @NonNls
    private static final Pattern SPECIAL = Pattern.compile("&\\p{Alnum}{2};?|#\\p{Alnum}{3,6}|0x\\p{Alnum}?");

    public static WordSplitter getInstance() {
        return INSTANCE;
    }

    @Override
    public void split(@Nullable String text, @NotNull TextRange range, Consumer<TextRange> consumer) {
        if (text == null || range.getLength() <= 1) {
            return;
        }
        Matcher specialMatcher = SPECIAL.matcher(text);
        specialMatcher.region(range.getStartOffset(), range.getEndOffset());
        if (specialMatcher.find()) {
            TextRange found = new TextRange(specialMatcher.start(), specialMatcher.end());
            WordSplitter.addWord(consumer, true, found);
        } else {
            IdentifierSplitter.getInstance().split(text, range, consumer);
        }
    }
}

