/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.inspections;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spellchecker.inspections.BaseSplitter;
import com.intellij.spellchecker.inspections.IdentifierSplitter;
import com.intellij.util.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropertiesSplitter
extends BaseSplitter {
    private static final PropertiesSplitter INSTANCE = new PropertiesSplitter();
    @NonNls
    private static final Pattern WORD = Pattern.compile("\\p{L}*");

    public static PropertiesSplitter getInstance() {
        return INSTANCE;
    }

    @Override
    public void split(@Nullable String text, @NotNull TextRange range, Consumer<TextRange> consumer) {
        if (text == null || StringUtil.isEmpty((String)text)) {
            return;
        }
        IdentifierSplitter splitter = IdentifierSplitter.getInstance();
        Matcher matcher = WORD.matcher(range.substring(text));
        while (matcher.find()) {
            if (matcher.end() - matcher.start() < 3) continue;
            TextRange found = PropertiesSplitter.matcherRange(range, matcher);
            splitter.split(text, found, consumer);
        }
    }
}

