/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.inspections;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spellchecker.inspections.BaseSplitter;
import com.intellij.spellchecker.inspections.TextSplitter;
import com.intellij.util.Consumer;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom.Verifier;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlainTextSplitter
extends BaseSplitter {
    private static final PlainTextSplitter INSTANCE = new PlainTextSplitter();
    @NonNls
    private static final Pattern SPLIT_PATTERN = Pattern.compile("(\\s|\b)");
    @NonNls
    private static final Pattern MAIL = Pattern.compile("([\\p{L}0-9\\.\\-\\_]+@([\\p{L}0-9\\-\\_]+\\.)+(com|net|[a-z]{2}))");
    @NonNls
    private static final Pattern URL = Pattern.compile("((ftp|http|file|https)://([^/]+)(/\\w*)?(/\\w*))");

    public static PlainTextSplitter getInstance() {
        return INSTANCE;
    }

    @Override
    public void split(@Nullable String text, @NotNull TextRange range, Consumer<TextRange> consumer) {
        if (text == null || StringUtil.isEmpty((String)text)) {
            return;
        }
        String substring = StringUtil.replaceChar((String)StringUtil.replaceChar((String)range.substring(text), (char)'\b', (char)'\n'), (char)'\f', (char)'\n');
        if (Verifier.checkCharacterData((String)SPLIT_PATTERN.matcher(substring).replaceAll("")) != null) {
            return;
        }
        TextSplitter ws = TextSplitter.getInstance();
        int from = range.getStartOffset();
        Matcher matcher = SPLIT_PATTERN.matcher(range.substring(text));
        while (true) {
            String word;
            TextRange wRange;
            PlainTextSplitter.checkCancelled();
            if (matcher.find()) {
                TextRange found = PlainTextSplitter.matcherRange(range, matcher);
                int till = found.getStartOffset();
                if (PlainTextSplitter.badSize(from, till)) continue;
                wRange = new TextRange(from, till);
                word = wRange.substring(text);
                from = found.getEndOffset();
            } else {
                wRange = new TextRange(from, range.getEndOffset());
                word = wRange.substring(text);
            }
            List<TextRange> toCheck = word.contains("@") ? PlainTextSplitter.excludeByPattern(text, wRange, MAIL, 0) : (word.contains("://") ? PlainTextSplitter.excludeByPattern(text, wRange, URL, 0) : Collections.singletonList(wRange));
            for (TextRange r : toCheck) {
                ws.split(text, r, consumer);
            }
            if (matcher.hitEnd()) break;
        }
    }
}

