/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.compress;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.spellchecker.compress.Alphabet;
import com.intellij.spellchecker.compress.UnitBitSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Encoder {
    private final Alphabet alphabet;
    private static final int offset = 0;
    static final UnitBitSet WORD_OF_ENTIRELY_UNKNOWN_LETTERS = new UnitBitSet(new byte[1], new Alphabet());
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.spellchecker.compress");

    public Encoder() {
        this(new Alphabet());
    }

    public Encoder(@NotNull Alphabet alphabet) {
        this.alphabet = alphabet;
    }

    public Alphabet getAlphabet() {
        return this.alphabet;
    }

    @Nullable
    public UnitBitSet encode(@NotNull CharSequence letters, boolean force) {
        if (64 <= letters.length() + 0) {
            return null;
        }
        int unknownLetters = 0;
        byte[] indices = new byte[letters.length()];
        for (int i = 0; i < letters.length(); ++i) {
            char letter = letters.charAt(i);
            int index = this.alphabet.getIndex(letter, force);
            if (index < 0) {
                ++unknownLetters;
                continue;
            }
            indices[i] = (byte)index;
        }
        if (unknownLetters == letters.length()) {
            return WORD_OF_ENTIRELY_UNKNOWN_LETTERS;
        }
        if (unknownLetters > 0) {
            return null;
        }
        return new UnitBitSet(indices, this.alphabet);
    }

    @NotNull
    public String decode(@NotNull byte[] compressed) {
        return UnitBitSet.decode(compressed, this.alphabet);
    }

    public int getFirstLetterIndex(byte firstPackedByte) {
        return UnitBitSet.getFirstLetterIndex(firstPackedByte, this.alphabet);
    }
}

