/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import com.intellij.spellchecker.BaseSuggestionProvider;
import com.intellij.spellchecker.BundledDictionaryProvider;
import com.intellij.spellchecker.FileLoader;
import com.intellij.spellchecker.SpellCheckerSeveritiesProvider;
import com.intellij.spellchecker.StreamLoader;
import com.intellij.spellchecker.dictionary.EditableDictionary;
import com.intellij.spellchecker.dictionary.Loader;
import com.intellij.spellchecker.engine.SpellCheckerEngine;
import com.intellij.spellchecker.engine.SpellCheckerFactory;
import com.intellij.spellchecker.engine.SuggestionProvider;
import com.intellij.spellchecker.settings.SpellCheckerSettings;
import com.intellij.spellchecker.state.StateLoader;
import com.intellij.spellchecker.util.SPFileUtil;
import com.intellij.spellchecker.util.Strings;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpellCheckerManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.spellchecker.SpellCheckerManager");
    private static final int MAX_SUGGESTIONS_THRESHOLD = 5;
    private static final int MAX_METRICS = 1;
    private final Project project;
    private SpellCheckerEngine spellChecker;
    private EditableDictionary userDictionary;
    private final SuggestionProvider suggestionProvider = new BaseSuggestionProvider(this);
    private final SpellCheckerSettings settings;

    public static SpellCheckerManager getInstance(Project project2) {
        return (SpellCheckerManager)ServiceManager.getService((Project)project2, SpellCheckerManager.class);
    }

    public SpellCheckerManager(Project project2, SpellCheckerSettings settings) {
        this.project = project2;
        this.settings = settings;
        this.fullConfigurationReload();
    }

    public void fullConfigurationReload() {
        this.spellChecker = SpellCheckerFactory.create(this.project);
        this.fillEngineDictionary();
    }

    public void updateBundledDictionaries(List<String> removedDictionaries) {
        for (BundledDictionaryProvider provider : (BundledDictionaryProvider[])Extensions.getExtensions(BundledDictionaryProvider.EP_NAME)) {
            for (String dictionary : provider.getBundledDictionaries()) {
                boolean dictionaryShouldBeLoad = this.settings == null || !this.settings.getBundledDisabledDictionariesPaths().contains(dictionary);
                boolean dictionaryIsLoad = this.spellChecker.isDictionaryLoad(dictionary);
                if (dictionaryIsLoad && !dictionaryShouldBeLoad) {
                    this.spellChecker.removeDictionary(dictionary);
                    continue;
                }
                if (dictionaryIsLoad || !dictionaryShouldBeLoad) continue;
                Class<?> loaderClass = provider.getClass();
                InputStream stream = loaderClass.getResourceAsStream(dictionary);
                if (stream != null) {
                    this.spellChecker.loadDictionary(new StreamLoader(stream, dictionary));
                    continue;
                }
                LOG.warn("Couldn't load dictionary '" + dictionary + "' with loader '" + loaderClass + "'");
            }
        }
        if (this.settings != null && this.settings.getDictionaryFoldersPaths() != null) {
            final Set<String> disabledDictionaries = this.settings.getDisabledDictionariesPaths();
            for (String folder : this.settings.getDictionaryFoldersPaths()) {
                SPFileUtil.processFilesRecursively(folder, new Consumer<String>(){

                    public void consume(String s) {
                        boolean dictionaryShouldBeLoad = !disabledDictionaries.contains(s);
                        boolean dictionaryIsLoad = SpellCheckerManager.this.spellChecker.isDictionaryLoad(s);
                        if (dictionaryIsLoad && !dictionaryShouldBeLoad) {
                            SpellCheckerManager.this.spellChecker.removeDictionary(s);
                        } else if (!dictionaryIsLoad && dictionaryShouldBeLoad) {
                            SpellCheckerManager.this.spellChecker.loadDictionary(new FileLoader(s, s));
                        }
                    }
                });
            }
        }
        if (removedDictionaries != null && !removedDictionaries.isEmpty()) {
            for (String name : removedDictionaries) {
                this.spellChecker.removeDictionary(name);
            }
        }
        SpellCheckerManager.restartInspections();
    }

    public Project getProject() {
        return this.project;
    }

    public EditableDictionary getUserDictionary() {
        return this.userDictionary;
    }

    private void fillEngineDictionary() {
        this.spellChecker.reset();
        StateLoader stateLoader = new StateLoader(this.project);
        stateLoader.load(new Consumer<String>(){

            public void consume(String s) {
            }
        });
        final ArrayList<Loader> loaders = new ArrayList<Loader>();
        for (BundledDictionaryProvider provider : (BundledDictionaryProvider[])Extensions.getExtensions(BundledDictionaryProvider.EP_NAME)) {
            for (String dictionary : provider.getBundledDictionaries()) {
                if (this.settings != null && this.settings.getBundledDisabledDictionariesPaths().contains(dictionary)) continue;
                Class<?> loaderClass = provider.getClass();
                InputStream stream = loaderClass.getResourceAsStream(dictionary);
                if (stream != null) {
                    loaders.add(new StreamLoader(stream, dictionary));
                    continue;
                }
                LOG.warn("Couldn't load dictionary '" + dictionary + "' with loader '" + loaderClass + "'");
            }
        }
        if (this.settings != null && this.settings.getDictionaryFoldersPaths() != null) {
            final Set<String> disabledDictionaries = this.settings.getDisabledDictionariesPaths();
            for (String folder : this.settings.getDictionaryFoldersPaths()) {
                SPFileUtil.processFilesRecursively(folder, new Consumer<String>(){

                    public void consume(String s) {
                        if (!disabledDictionaries.contains(s)) {
                            loaders.add(new FileLoader(s, s));
                        }
                    }
                });
            }
        }
        loaders.add(stateLoader);
        for (Loader loader : loaders) {
            this.spellChecker.loadDictionary(loader);
        }
        this.userDictionary = stateLoader.getDictionary();
    }

    public boolean hasProblem(@NotNull String word) {
        return !this.spellChecker.isCorrect(word);
    }

    public void acceptWordAsCorrect(@NotNull String word, Project project2) {
        String transformed = this.spellChecker.getTransformation().transform(word);
        if (transformed != null) {
            this.userDictionary.addToDictionary(transformed);
            PsiModificationTrackerImpl modificationTracker = (PsiModificationTrackerImpl)PsiManager.getInstance((Project)project2).getModificationTracker();
            modificationTracker.incCounter();
        }
    }

    public void updateUserDictionary(@Nullable Collection<String> words) {
        this.userDictionary.replaceAll(words);
        SpellCheckerManager.restartInspections();
    }

    @NotNull
    public static List<String> getBundledDictionaries() {
        ArrayList<String> dictionaries = new ArrayList<String>();
        for (BundledDictionaryProvider provider : (BundledDictionaryProvider[])Extensions.getExtensions(BundledDictionaryProvider.EP_NAME)) {
            ContainerUtil.addAll(dictionaries, (Object[])provider.getBundledDictionaries());
        }
        return dictionaries;
    }

    @NotNull
    public static HighlightDisplayLevel getHighlightDisplayLevel() {
        return HighlightDisplayLevel.find((HighlightSeverity)SpellCheckerSeveritiesProvider.TYPO);
    }

    @NotNull
    public List<String> getSuggestions(@NotNull String text) {
        return this.suggestionProvider.getSuggestions(text);
    }

    @NotNull
    protected List<String> getRawSuggestions(@NotNull String word) {
        ArrayList<String> suggestions;
        if (!this.spellChecker.isCorrect(word) && !(suggestions = this.spellChecker.getSuggestions(word, 5, 1)).isEmpty()) {
            if (Strings.isCapitalized(word)) {
                Strings.capitalize(suggestions);
            } else if (Strings.isUpperCase(word)) {
                Strings.upperCase(suggestions);
            }
            LinkedHashSet<String> unique = new LinkedHashSet<String>(suggestions);
            return unique.size() < suggestions.size() ? new ArrayList<String>(unique) : suggestions;
        }
        return Collections.emptyList();
    }

    public static void restartInspections() {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                Project[] projects;
                for (Project project2 : projects = ProjectManager.getInstance().getOpenProjects()) {
                    if (!project2.isInitialized() || !project2.isOpen() || project2.isDefault()) continue;
                    DaemonCodeAnalyzer.getInstance((Project)project2).restart();
                }
            }
        });
    }
}

