/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.impl.source.tree.java.PsiLiteralExpressionImpl;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spellchecker.inspections.PlainTextSplitter;
import com.intellij.spellchecker.tokenizer.EscapeSequenceTokenizer;
import com.intellij.spellchecker.tokenizer.TokenConsumer;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class LiteralExpressionTokenizer
extends EscapeSequenceTokenizer<PsiLiteralExpression> {
    @Override
    public void tokenize(@NotNull PsiLiteralExpression element, TokenConsumer consumer) {
        PsiLiteralExpressionImpl literalExpression = (PsiLiteralExpressionImpl)element;
        if (literalExpression.getLiteralElementType() != JavaTokenType.STRING_LITERAL) {
            return;
        }
        String text = literalExpression.getInnerText();
        if (StringUtil.isEmpty((String)text) || text.length() <= 2) {
            return;
        }
        if (InjectedLanguageUtil.hasInjections(literalExpression)) {
            return;
        }
        PsiModifierListOwner listOwner = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)element, PsiModifierListOwner.class);
        if (listOwner != null && AnnotationUtil.isAnnotated((PsiModifierListOwner)listOwner, Collections.singleton("org.jetbrains.annotations.NonNls"), (boolean)false, (boolean)false)) {
            return;
        }
        if (!text.contains("\\")) {
            consumer.consumeToken((PsiElement)element, PlainTextSplitter.getInstance());
        } else {
            LiteralExpressionTokenizer.processTextWithEscapeSequences(element, text, consumer);
        }
    }

    public static void processTextWithEscapeSequences(PsiLiteralExpression element, String text, TokenConsumer consumer) {
        StringBuilder unescapedText = new StringBuilder();
        int[] offsets = new int[text.length() + 1];
        PsiLiteralExpressionImpl.parseStringCharacters(text, unescapedText, offsets);
        LiteralExpressionTokenizer.processTextWithOffsets((PsiElement)element, consumer, unescapedText, offsets, 1);
    }
}

