/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.slicer;

import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.slicer.JavaSliceDereferenceUsage;
import com.intellij.slicer.JavaSliceUsage;
import com.intellij.slicer.SliceUsage;
import com.intellij.slicer.SliceUsageCellRendererBase;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.usages.TextChunk;
import com.intellij.util.FontUtil;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import java.awt.Color;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SliceUsageCellRenderer
extends SliceUsageCellRendererBase {
    @Override
    public void customizeCellRendererFor(@NotNull SliceUsage sliceUsage) {
        String location;
        PsiMethod method;
        PsiClass aClass;
        int i;
        boolean isForcedLeaf = sliceUsage instanceof JavaSliceDereferenceUsage;
        JavaSliceUsage javaSliceUsage = sliceUsage instanceof JavaSliceUsage ? (JavaSliceUsage)sliceUsage : null;
        TextChunk[] text = sliceUsage.getText();
        SmartList usageRanges = new SmartList();
        sliceUsage.processRangeMarkers((Processor)new Processor<Segment>((List)usageRanges){
            final /* synthetic */ List val$usageRanges;
            {
                this.val$usageRanges = list;
            }

            public boolean process(Segment segment) {
                this.val$usageRanges.add(TextRange.create((Segment)segment));
                return true;
            }
        });
        boolean isInsideContainer = javaSliceUsage != null && javaSliceUsage.indexNesting != 0;
        int length = text.length;
        for (i = 0; i < length; ++i) {
            boolean inUsage;
            TextChunk textChunk = text[i];
            SimpleTextAttributes attributes = textChunk.getSimpleAttributesIgnoreBackground();
            if (isForcedLeaf) {
                attributes = attributes.derive(attributes.getStyle(), (Color)JBColor.LIGHT_GRAY, attributes.getBgColor(), attributes.getWaveColor());
            }
            boolean bl = inUsage = (attributes.getFontStyle() & 1) != 0;
            if (!isInsideContainer || inUsage) {
                // empty if block
            }
            this.append(textChunk.getText(), attributes);
            if (i != 0) continue;
            this.append(FontUtil.spaceAndThinSpace());
        }
        if (javaSliceUsage != null) {
            for (i = 0; i < javaSliceUsage.indexNesting; ++i) {
                this.append(" (Tracking container contents" + (javaSliceUsage.syntheticField.isEmpty() ? "" : " '" + javaSliceUsage.syntheticField + "'") + ")", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            }
        }
        PsiElement element = sliceUsage.getElement();
        while (true) {
            PsiClass psiClass = aClass = (method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class)) == null ? (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class) : method.getContainingClass();
            if (!(aClass instanceof PsiAnonymousClass)) break;
            element = aClass;
        }
        int methodOptions = 4353;
        String string = method != null ? PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)methodOptions, (int)2, (int)2) : (location = aClass != null ? PsiFormatUtil.formatClass((PsiClass)aClass, (int)1) : null);
        if (location != null) {
            SimpleTextAttributes attributes = SimpleTextAttributes.GRAY_ATTRIBUTES;
            this.append(" in " + location, attributes);
        }
    }
}

