/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.slicer;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaReference;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.impl.source.tree.AstBufferUtil;
import com.intellij.slicer.JavaSliceUsage;
import com.intellij.slicer.SliceLeafValueRootNode;
import com.intellij.slicer.SliceManager;
import com.intellij.slicer.SliceNode;
import com.intellij.slicer.SliceRootNode;
import com.intellij.slicer.SliceUsage;
import com.intellij.util.NullableFunction;
import com.intellij.util.PairProcessor;
import com.intellij.util.WalkingState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class SliceLeafAnalyzer {
    public static final TObjectHashingStrategy<PsiElement> LEAF_ELEMENT_EQUALITY = new TObjectHashingStrategy<PsiElement>(){

        public int computeHashCode(final PsiElement element) {
            if (element == null) {
                return 0;
            }
            String text = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

                public String compute() {
                    PsiElement resolved;
                    PsiElement elementToCompare = element;
                    if (element instanceof PsiJavaReference && (resolved = ((PsiJavaReference)element).resolve()) != null) {
                        elementToCompare = resolved;
                    }
                    return elementToCompare instanceof PsiNamedElement ? ((PsiNamedElement)elementToCompare).getName() : AstBufferUtil.getTextSkippingWhitespaceComments(elementToCompare.getNode());
                }
            });
            return Comparing.hashcode((Object)text);
        }

        public boolean equals(final PsiElement o1, final PsiElement o2) {
            return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

                public Boolean compute() {
                    return o1 != null && o2 != null && PsiEquivalenceUtil.areElementsEquivalent((PsiElement)o1, (PsiElement)o2);
                }
            });
        }
    };

    static SliceNode filterTree(SliceNode oldRoot, NullableFunction<SliceNode, SliceNode> filter, PairProcessor<SliceNode, List<SliceNode>> postProcessor) {
        boolean success;
        SliceNode filtered = (SliceNode)filter.fun((Object)oldRoot);
        if (filtered == null) {
            return null;
        }
        ArrayList<SliceNode> childrenFiltered = new ArrayList<SliceNode>();
        if (oldRoot.myCachedChildren != null) {
            for (SliceNode child : oldRoot.myCachedChildren) {
                SliceNode childFiltered = SliceLeafAnalyzer.filterTree(child, filter, postProcessor);
                if (childFiltered == null) continue;
                childrenFiltered.add(childFiltered);
            }
        }
        boolean bl = success = postProcessor == null || postProcessor.process((Object)filtered, childrenFiltered);
        if (!success) {
            return null;
        }
        filtered.myCachedChildren = new ArrayList<SliceNode>(childrenFiltered);
        return filtered;
    }

    private static void groupByValues(@NotNull Collection<PsiElement> leaves, @NotNull SliceRootNode oldRoot, @NotNull Map<SliceNode, Collection<PsiElement>> map) {
        assert (oldRoot.myCachedChildren.size() == 1);
        SliceRootNode root = SliceLeafAnalyzer.createTreeGroupedByValues(leaves, oldRoot, map);
        SliceNode oldRootStart = (SliceNode)oldRoot.myCachedChildren.get(0);
        SliceUsage rootUsage = (SliceUsage)((Object)oldRootStart.getValue());
        String description = SliceManager.getElementDescription(null, rootUsage.getElement(), " (grouped by value)");
        SliceManager.getInstance(root.getProject()).createToolWindow(true, root, true, description);
    }

    @NotNull
    public static SliceRootNode createTreeGroupedByValues(Collection<PsiElement> leaves, SliceRootNode oldRoot, final Map<SliceNode, Collection<PsiElement>> map) {
        SliceNode oldRootStart = (SliceNode)oldRoot.myCachedChildren.get(0);
        SliceRootNode root = oldRoot.copy();
        root.setChanged();
        root.targetEqualUsages.clear();
        root.myCachedChildren = new ArrayList(leaves.size());
        for (final PsiElement leafExpression : leaves) {
            SliceNode newNode = SliceLeafAnalyzer.filterTree(oldRootStart, new NullableFunction<SliceNode, SliceNode>(){

                public SliceNode fun(SliceNode oldNode) {
                    if (oldNode.getDuplicate() != null) {
                        return null;
                    }
                    if (!SliceLeafAnalyzer.node(oldNode, map).contains(leafExpression)) {
                        return null;
                    }
                    return oldNode.copy();
                }
            }, new PairProcessor<SliceNode, List<SliceNode>>(){

                public boolean process(SliceNode node, List<SliceNode> children2) {
                    if (!children2.isEmpty()) {
                        return true;
                    }
                    PsiElement element = ((SliceUsage)((Object)node.getValue())).getElement();
                    if (element == null) {
                        return false;
                    }
                    return element.getManager().areElementsEquivalent(element, leafExpression);
                }
            });
            SliceLeafValueRootNode lvNode = new SliceLeafValueRootNode(root.getProject(), leafExpression, root, Collections.singletonList(newNode), ((SliceUsage)((Object)oldRoot.getValue())).params);
            root.myCachedChildren.add(lvNode);
        }
        return root;
    }

    public static void startAnalyzeValues(final @NotNull AbstractTreeStructure treeStructure, final @NotNull Runnable finish) {
        final SliceRootNode root = (SliceRootNode)treeStructure.getRootElement();
        final Ref leafExpressions = Ref.create(null);
        final Map<SliceNode, Collection<PsiElement>> map = SliceLeafAnalyzer.createMap();
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(root.getProject(), "Expanding all nodes... (may very well take the whole day)", true){

            public void run(@NotNull ProgressIndicator indicator) {
                Collection<PsiElement> l = SliceLeafAnalyzer.calcLeafExpressions(root, treeStructure, map);
                leafExpressions.set(l);
            }

            public void onCancel() {
                finish.run();
            }

            public void onSuccess() {
                try {
                    Collection leaves = (Collection)leafExpressions.get();
                    if (leaves == null) {
                        return;
                    }
                    if (leaves.isEmpty()) {
                        Messages.showErrorDialog((String)"Unable to find leaf expressions to group by", (String)"Cannot Group");
                        return;
                    }
                    SliceLeafAnalyzer.groupByValues(leaves, root, map);
                }
                finally {
                    finish.run();
                }
            }
        });
    }

    public static Map<SliceNode, Collection<PsiElement>> createMap() {
        return new FactoryMap<SliceNode, Collection<PsiElement>>(){

            protected Map<SliceNode, Collection<PsiElement>> createMap() {
                return ContainerUtil.newConcurrentMap((TObjectHashingStrategy)ContainerUtil.identityStrategy());
            }

            protected Collection<PsiElement> create(SliceNode key) {
                return ContainerUtil.newConcurrentSet(LEAF_ELEMENT_EQUALITY);
            }
        };
    }

    private static Collection<PsiElement> node(SliceNode node, Map<SliceNode, Collection<PsiElement>> map) {
        return map.get(node);
    }

    @NotNull
    public static Collection<PsiElement> calcLeafExpressions(@NotNull SliceNode root, @NotNull AbstractTreeStructure treeStructure, final @NotNull Map<SliceNode, Collection<PsiElement>> map) {
        final SliceNodeGuide guide = new SliceNodeGuide(treeStructure);
        WalkingState<SliceNode> walkingState = new WalkingState<SliceNode>((WalkingState.TreeGuide)guide){

            public void visit(final @NotNull SliceNode element) {
                element.calculateDupNode();
                SliceLeafAnalyzer.node(element, map).clear();
                SliceNode duplicate = element.getDuplicate();
                if (duplicate != null) {
                    SliceLeafAnalyzer.node(element, map).addAll(SliceLeafAnalyzer.node(duplicate, map));
                } else {
                    ApplicationManager.getApplication().runReadAction(new Runnable(){

                        @Override
                        public void run() {
                            SliceUsage sliceUsage = (SliceUsage)((Object)element.getValue());
                            Collection<? extends AbstractTreeNode> children2 = element.getChildren();
                            if (children2.isEmpty() && sliceUsage instanceof JavaSliceUsage) {
                                PsiElement value;
                                PsiElement psiElement = value = ((JavaSliceUsage)sliceUsage).indexNesting == 0 ? sliceUsage.getElement() : null;
                                if (value != null) {
                                    SliceLeafAnalyzer.node(element, map).addAll(ContainerUtil.singleton((Object)value, LEAF_ELEMENT_EQUALITY));
                                }
                            }
                        }
                    });
                    super.visit((Object)element);
                }
            }

            public void elementFinished(@NotNull SliceNode element) {
                SliceNode parent = guide.getParent(element);
                if (parent != null) {
                    SliceLeafAnalyzer.node(parent, map).addAll(SliceLeafAnalyzer.node(element, map));
                }
            }
        };
        walkingState.visit((Object)root);
        return SliceLeafAnalyzer.node(root, map);
    }

    static class SliceNodeGuide
    implements WalkingState.TreeGuide<SliceNode> {
        private final AbstractTreeStructure myTreeStructure;

        SliceNodeGuide(@NotNull AbstractTreeStructure treeStructure) {
            this.myTreeStructure = treeStructure;
        }

        public SliceNode getNextSibling(@NotNull SliceNode element) {
            AbstractTreeNode parent = element.getParent();
            if (parent == null) {
                return null;
            }
            return element.getNext((List)parent.getChildren());
        }

        public SliceNode getPrevSibling(@NotNull SliceNode element) {
            AbstractTreeNode parent = element.getParent();
            if (parent == null) {
                return null;
            }
            return element.getPrev((List)parent.getChildren());
        }

        public SliceNode getFirstChild(@NotNull SliceNode element) {
            Object[] children2 = this.myTreeStructure.getChildElements((Object)element);
            return children2.length == 0 ? null : (SliceNode)children2[0];
        }

        public SliceNode getParent(@NotNull SliceNode element) {
            AbstractTreeNode parent = element.getParent();
            return parent instanceof SliceNode ? (SliceNode)parent : null;
        }
    }
}

