/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.slicer;

import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.slicer.CanItBeNullAction;
import com.intellij.slicer.GroupByLeavesAction;
import com.intellij.slicer.JavaSliceUsage;
import com.intellij.slicer.SliceAnalysisParams;
import com.intellij.slicer.SliceLanguageSupportProvider;
import com.intellij.slicer.SliceLeafAnalyzer;
import com.intellij.slicer.SliceNullnessAnalyzer;
import com.intellij.slicer.SliceTreeBuilder;
import com.intellij.slicer.SliceUsage;
import com.intellij.slicer.SliceUsageCellRenderer;
import com.intellij.slicer.SliceUsageCellRendererBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaSliceProvider
implements SliceLanguageSupportProvider {
    @Override
    @NotNull
    public SliceUsage createRootUsage(@NotNull PsiElement element, @NotNull SliceAnalysisParams params) {
        return JavaSliceUsage.createRootUsage(element, params);
    }

    @Override
    @Nullable
    public PsiElement getExpressionAtCaret(PsiElement atCaret, boolean dataFlowToThis) {
        PsiElement element = PsiTreeUtil.getParentOfType((PsiElement)atCaret, (Class[])new Class[]{PsiExpression.class, PsiVariable.class});
        if (dataFlowToThis && element instanceof PsiLiteralExpression) {
            return null;
        }
        return element;
    }

    @Override
    @NotNull
    public PsiElement getElementForDescription(@NotNull PsiElement element) {
        PsiElement elementToSlice;
        if (element instanceof PsiReferenceExpression && (elementToSlice = ((PsiReferenceExpression)element).resolve()) != null) {
            return elementToSlice;
        }
        return element;
    }

    @Override
    @NotNull
    public SliceUsageCellRendererBase getRenderer() {
        return new SliceUsageCellRenderer();
    }

    @Override
    public void startAnalyzeLeafValues(AbstractTreeStructure structure, Runnable finalRunnable) {
        SliceLeafAnalyzer.startAnalyzeValues(structure, finalRunnable);
    }

    @Override
    public void startAnalyzeNullness(AbstractTreeStructure structure, Runnable finalRunnable) {
        SliceNullnessAnalyzer.startAnalyzeNullness(structure, finalRunnable);
    }

    @Override
    public void registerExtraPanelActions(DefaultActionGroup actionGroup, SliceTreeBuilder sliceTreeBuilder) {
        if (sliceTreeBuilder.dataFlowToThis) {
            actionGroup.add((AnAction)new GroupByLeavesAction(sliceTreeBuilder));
            actionGroup.add((AnAction)new CanItBeNullAction(sliceTreeBuilder));
        }
    }
}

