/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.slicer;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.slicer.SliceNode;
import com.intellij.slicer.SliceUsage;
import com.intellij.usageView.UsageInfo;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class DuplicateMap {
    private static final TObjectHashingStrategy<SliceUsage> USAGE_INFO_EQUALITY = new TObjectHashingStrategy<SliceUsage>(){

        public int computeHashCode(SliceUsage object) {
            UsageInfo info = object.getUsageInfo();
            ProperTextRange range = info.getRangeInElement();
            return range == null ? 0 : range.hashCode();
        }

        public boolean equals(SliceUsage o1, SliceUsage o2) {
            return o1.getUsageInfo().equals((Object)o2.getUsageInfo());
        }
    };
    private final Map<SliceUsage, SliceNode> myDuplicates = new THashMap(USAGE_INFO_EQUALITY);

    public SliceNode putNodeCheckDupe(final @NotNull SliceNode node) {
        return (SliceNode)ApplicationManager.getApplication().runReadAction((Computable)new Computable<SliceNode>(){

            public SliceNode compute() {
                SliceUsage usage = (SliceUsage)((Object)node.getValue());
                SliceNode eq = (SliceNode)DuplicateMap.this.myDuplicates.get((Object)usage);
                if (eq == null) {
                    DuplicateMap.this.myDuplicates.put(usage, node);
                }
                return eq;
            }
        });
    }

    public void clear() {
        this.myDuplicates.clear();
    }
}

