/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.runtime.ui;

import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServerListener;
import com.intellij.remoteServer.impl.runtime.ui.ServersToolWindowFactory;
import icons.RemoteServersIcons;
import org.jetbrains.annotations.NotNull;

public abstract class ServersToolWindowManager
extends AbstractProjectComponent {
    private final String myWindowId;

    public ServersToolWindowManager(Project project2, String windowId) {
        super(project2);
        this.myWindowId = windowId;
    }

    public void projectOpened() {
        StartupManager.getInstance((Project)this.myProject).registerPostStartupActivity(new Runnable(){

            @Override
            public void run() {
                ServersToolWindowManager.this.setupListeners();
            }
        });
    }

    public void setupListeners() {
        this.getFactory().getContribution().setupAvailabilityListener(this.myProject, new Runnable(){

            @Override
            public void run() {
                ServersToolWindowManager.this.updateWindowAvailable(true);
            }
        });
        this.myProject.getMessageBus().connect().subscribe(RemoteServerListener.TOPIC, (Object)new RemoteServerListener(){

            public void serverAdded(@NotNull RemoteServer<?> server) {
                ServersToolWindowManager.this.updateWindowAvailable(true);
            }

            public void serverRemoved(@NotNull RemoteServer<?> server) {
                ServersToolWindowManager.this.updateWindowAvailable(false);
            }
        });
    }

    private void updateWindowAvailable(final boolean showIfAvailable) {
        final ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)this.myProject);
        toolWindowManager.invokeLater(new Runnable(){

            @Override
            public void run() {
                boolean doShow;
                boolean available = ServersToolWindowManager.this.getFactory().getContribution().canContribute(ServersToolWindowManager.this.myProject);
                ToolWindow toolWindow = toolWindowManager.getToolWindow(ServersToolWindowManager.this.myWindowId);
                if (toolWindow == null) {
                    if (available) {
                        ServersToolWindowManager.this.createToolWindow(ServersToolWindowManager.this.myProject, toolWindowManager).show(null);
                    }
                    return;
                }
                boolean bl = doShow = !toolWindow.isAvailable() && available;
                if (toolWindow.isAvailable() && !available) {
                    toolWindow.hide(null);
                }
                toolWindow.setAvailable(available, null);
                if (showIfAvailable && doShow) {
                    toolWindow.show(null);
                }
            }
        });
    }

    private ToolWindow createToolWindow(Project project2, ToolWindowManager toolWindowManager) {
        ToolWindow toolWindow = toolWindowManager.registerToolWindow(this.myWindowId, false, ToolWindowAnchor.BOTTOM);
        toolWindow.setIcon(RemoteServersIcons.ServersToolWindow);
        this.getFactory().createToolWindowContent(project2, toolWindow);
        return toolWindow;
    }

    @NotNull
    protected abstract ServersToolWindowFactory getFactory();
}

