/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.runtime.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.remoteServer.impl.runtime.ui.ServersToolWindowContent;
import com.intellij.remoteServer.runtime.ServerConnection;
import com.intellij.remoteServer.runtime.ui.RemoteServersView;
import com.intellij.util.ui.UIUtil;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class RemoteServersViewImpl
extends RemoteServersView {
    @NotNull
    private final Project myProject;

    public RemoteServersViewImpl(@NotNull Project project2) {
        this.myProject = project2;
    }

    @Override
    public void showServerConnection(final @NotNull ServerConnection<?> connection) {
        final ToolWindow toolWindow = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(RemoteServersViewImpl.getToolWindowId(connection));
        if (toolWindow != null) {
            toolWindow.activate(new Runnable(){

                @Override
                public void run() {
                    ServersToolWindowContent content = RemoteServersViewImpl.getServersViewComponent(toolWindow);
                    if (content != null) {
                        content.select(connection);
                    }
                }
            });
        }
    }

    private static ServersToolWindowContent getServersViewComponent(ToolWindow toolWindow) {
        return (ServersToolWindowContent)UIUtil.findComponentOfType((JComponent)toolWindow.getComponent(), ServersToolWindowContent.class);
    }

    @Override
    public void showDeployment(final @NotNull ServerConnection<?> connection, final @NotNull String deploymentName) {
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)this.myProject);
        final ToolWindow toolWindow = toolWindowManager.getToolWindow(RemoteServersViewImpl.getToolWindowId(connection));
        if (toolWindow != null) {
            toolWindowManager.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ServersToolWindowContent component = RemoteServersViewImpl.getServersViewComponent(toolWindow);
                    if (component != null) {
                        component.select(connection, deploymentName);
                    }
                }
            });
        }
    }

    private static String getToolWindowId(ServerConnection<?> connection) {
        String customToolWindowId = connection.getServer().getType().getCustomToolWindowId();
        return StringUtil.notNullize((String)customToolWindowId, (String)"Application Servers");
    }
}

