/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.configuration.deployment;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModulePointer;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remoteServer.configuration.deployment.DeploymentSourceType;
import com.intellij.remoteServer.configuration.deployment.ModuleDeploymentSource;
import com.intellij.remoteServer.impl.configuration.deployment.ModuleDeploymentSourceType;
import com.intellij.util.ArrayUtil;
import java.io.File;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleDeploymentSourceImpl
implements ModuleDeploymentSource {
    private final ModulePointer myPointer;

    public ModuleDeploymentSourceImpl(@NotNull ModulePointer pointer) {
        this.myPointer = pointer;
    }

    @NotNull
    public ModulePointer getModulePointer() {
        return this.myPointer;
    }

    @Nullable
    public Module getModule() {
        return this.myPointer.getModule();
    }

    @Nullable
    public VirtualFile getContentRoot() {
        Module module2 = this.myPointer.getModule();
        if (module2 == null) {
            return null;
        }
        return ModuleDeploymentSourceImpl.getContentRoot(module2);
    }

    public static VirtualFile getContentRoot(Module module2) {
        return (VirtualFile)ArrayUtil.getFirstElement((Object[])ModuleRootManager.getInstance((Module)module2).getContentRoots());
    }

    @Nullable
    public File getFile() {
        VirtualFile contentRoot = this.getContentRoot();
        if (contentRoot == null) {
            return null;
        }
        return VfsUtilCore.virtualToIoFile((VirtualFile)contentRoot);
    }

    @Nullable
    public String getFilePath() {
        File file2 = this.getFile();
        if (file2 == null) {
            return null;
        }
        return file2.getAbsolutePath();
    }

    @NotNull
    public String getPresentableName() {
        return this.myPointer.getModuleName();
    }

    @Nullable
    public Icon getIcon() {
        return AllIcons.Nodes.Module;
    }

    public boolean isValid() {
        return this.getModule() != null;
    }

    public boolean isArchive() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModuleDeploymentSource)) {
            return false;
        }
        return this.myPointer.equals(((ModuleDeploymentSource)o).getModulePointer());
    }

    public int hashCode() {
        return this.myPointer.hashCode();
    }

    @NotNull
    public DeploymentSourceType<?> getType() {
        return (DeploymentSourceType)DeploymentSourceType.EP_NAME.findExtension(ModuleDeploymentSourceType.class);
    }
}

