/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.configuration.deployment;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import com.intellij.remoteServer.configuration.ServerConfiguration;
import com.intellij.remoteServer.configuration.deployment.DeploymentConfiguration;
import com.intellij.remoteServer.configuration.deployment.DeploymentConfigurator;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.configuration.deployment.DeploymentSourceType;
import com.intellij.remoteServer.impl.configuration.RemoteServerListConfigurable;
import com.intellij.remoteServer.impl.configuration.deployment.DeployToServerRunConfiguration;
import com.intellij.ui.ColoredListCellRendererWrapper;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SortedComboBoxModel;
import com.intellij.util.ui.FormBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Comparator;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeployToServerSettingsEditor<S extends ServerConfiguration, D extends DeploymentConfiguration>
extends SettingsEditor<DeployToServerRunConfiguration<S, D>> {
    private final ServerType<S> myServerType;
    private final DeploymentConfigurator<D, S> myDeploymentConfigurator;
    private final Project myProject;
    private final ComboboxWithBrowseButton myServerComboBox;
    private final ComboBox mySourceComboBox;
    private final SortedComboBoxModel<String> myServerListModel;
    private final SortedComboBoxModel<DeploymentSource> mySourceListModel;
    private final JPanel myDeploymentSettingsComponent;
    private SettingsEditor<D> myDeploymentSettingsEditor;
    private DeploymentSource myLastSelectedSource;
    private RemoteServer<S> myLastSelectedServer;

    public DeployToServerSettingsEditor(final ServerType<S> type, DeploymentConfigurator<D, S> deploymentConfigurator, Project project2) {
        this.myServerType = type;
        this.myDeploymentConfigurator = deploymentConfigurator;
        this.myProject = project2;
        this.myServerListModel = new SortedComboBoxModel(String.CASE_INSENSITIVE_ORDER);
        this.myServerComboBox = new ComboboxWithBrowseButton((JComboBox)new ComboBox(this.myServerListModel));
        this.fillApplicationServersList(null);
        this.myServerComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RemoteServerListConfigurable configurable = RemoteServerListConfigurable.createConfigurable(type);
                if (ShowSettingsUtil.getInstance().editConfigurable((Component)DeployToServerSettingsEditor.this.myServerComboBox, (Configurable)configurable)) {
                    DeployToServerSettingsEditor.this.fillApplicationServersList(configurable.getLastSelectedServer());
                }
            }
        });
        this.myServerComboBox.getComboBox().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeployToServerSettingsEditor.this.updateDeploymentSettingsEditor();
            }
        });
        this.myServerComboBox.getComboBox().setRenderer(new ColoredListCellRendererWrapper<String>(){

            protected void doCustomize(JList list, String value, int index, boolean selected, boolean hasFocus) {
                if (value == null) {
                    return;
                }
                RemoteServer server = RemoteServersManager.getInstance().findByName(value, type);
                SimpleTextAttributes attributes = server == null ? SimpleTextAttributes.ERROR_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES;
                this.setIcon(server != null ? server.getType().getIcon() : null);
                this.append(value, attributes);
            }
        });
        this.mySourceListModel = new SortedComboBoxModel((Comparator)new Comparator<DeploymentSource>(){

            @Override
            public int compare(DeploymentSource o1, DeploymentSource o2) {
                return o1.getPresentableName().compareToIgnoreCase(o2.getPresentableName());
            }
        });
        this.mySourceListModel.addAll((Collection)deploymentConfigurator.getAvailableDeploymentSources());
        this.mySourceComboBox = new ComboBox(this.mySourceListModel);
        this.mySourceComboBox.setRenderer((ListCellRenderer)new ListCellRendererWrapper<DeploymentSource>(){

            public void customize(JList list, DeploymentSource value, int index, boolean selected, boolean hasFocus) {
                if (value == null) {
                    return;
                }
                this.setIcon(value.getIcon());
                this.setText(value.getPresentableName());
            }
        });
        this.myDeploymentSettingsComponent = new JPanel(new BorderLayout());
        this.mySourceComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeployToServerSettingsEditor.this.updateDeploymentSettingsEditor();
            }
        });
    }

    private void fillApplicationServersList(@Nullable RemoteServer<?> newSelection) {
        String oldSelection = (String)this.myServerListModel.getSelectedItem();
        this.myServerListModel.clear();
        for (RemoteServer server : RemoteServersManager.getInstance().getServers(this.myServerType)) {
            this.myServerListModel.add((Object)server.getName());
        }
        this.myServerComboBox.getComboBox().setSelectedItem(newSelection != null ? newSelection.getName() : oldSelection);
    }

    private void updateDeploymentSettingsEditor() {
        String serverName = (String)this.myServerListModel.getSelectedItem();
        RemoteServer selectedServer = serverName != null ? RemoteServersManager.getInstance().findByName(serverName, this.myServerType) : null;
        DeploymentSource selectedSource = (DeploymentSource)this.mySourceListModel.getSelectedItem();
        if (Comparing.equal((Object)selectedSource, (Object)this.myLastSelectedSource) && Comparing.equal((Object)selectedServer, this.myLastSelectedServer)) {
            return;
        }
        if (!Comparing.equal((Object)selectedSource, (Object)this.myLastSelectedSource)) {
            this.updateBeforeRunOptions(this.myLastSelectedSource, false);
            this.updateBeforeRunOptions(selectedSource, true);
        }
        if (selectedSource != null && selectedServer != null) {
            this.myDeploymentSettingsComponent.removeAll();
            this.myDeploymentSettingsEditor = this.myDeploymentConfigurator.createEditor(selectedSource, selectedServer);
            if (this.myDeploymentSettingsEditor != null) {
                Disposer.register((Disposable)this, this.myDeploymentSettingsEditor);
                this.myDeploymentSettingsComponent.add("Center", this.myDeploymentSettingsEditor.getComponent());
            }
        }
        this.myLastSelectedSource = selectedSource;
        this.myLastSelectedServer = selectedServer;
    }

    private void updateBeforeRunOptions(@Nullable DeploymentSource source, boolean selected) {
        if (source != null) {
            DeploymentSourceType type = source.getType();
            type.updateBuildBeforeRunOption((JComponent)this.myServerComboBox, this.myProject, source, selected);
        }
    }

    protected void resetEditorFrom(DeployToServerRunConfiguration<S, D> configuration) {
        String serverName = configuration.getServerName();
        if (serverName != null && !this.myServerListModel.getItems().contains(serverName)) {
            this.myServerListModel.add((Object)serverName);
        }
        this.myServerComboBox.getComboBox().setSelectedItem(serverName);
        this.mySourceComboBox.setSelectedItem((Object)configuration.getDeploymentSource());
        D deploymentConfiguration = configuration.getDeploymentConfiguration();
        this.updateDeploymentSettingsEditor();
        if (deploymentConfiguration != null && this.myDeploymentSettingsEditor != null) {
            this.myDeploymentSettingsEditor.resetFrom(deploymentConfiguration);
        }
    }

    protected void applyEditorTo(DeployToServerRunConfiguration<S, D> configuration) throws ConfigurationException {
        this.updateDeploymentSettingsEditor();
        configuration.setServerName((String)this.myServerListModel.getSelectedItem());
        DeploymentSource deploymentSource = (DeploymentSource)this.mySourceListModel.getSelectedItem();
        configuration.setDeploymentSource(deploymentSource);
        if (deploymentSource != null) {
            Object deployment = configuration.getDeploymentConfiguration();
            if (deployment == null) {
                deployment = this.myDeploymentConfigurator.createDefaultConfiguration(deploymentSource);
                configuration.setDeploymentConfiguration(deployment);
            }
            if (this.myDeploymentSettingsEditor != null) {
                this.myDeploymentSettingsEditor.applyTo(deployment);
            }
        } else {
            configuration.setDeploymentConfiguration(null);
        }
    }

    @NotNull
    protected JComponent createEditor() {
        return FormBuilder.createFormBuilder().addLabeledComponent("Server:", (JComponent)this.myServerComboBox).addLabeledComponent("Deployment:", (JComponent)this.mySourceComboBox).addComponentFillVertically((JComponent)this.myDeploymentSettingsComponent, 4).getPanel();
    }
}

