/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.configuration.deployment;

import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.impl.configuration.deployment.DeployToServerConfigurationType;
import org.jetbrains.annotations.NotNull;

public class DeployToServerConfigurationTypesRegistrar
implements ApplicationComponent {
    public void initComponent() {
        ExtensionPoint point = Extensions.getRootArea().getExtensionPoint(ConfigurationType.CONFIGURATION_TYPE_EP);
        for (ServerType serverType : (ServerType[])ServerType.EP_NAME.getExtensions()) {
            point.registerExtension((Object)new DeployToServerConfigurationType(serverType));
        }
    }

    @NotNull
    public static DeployToServerConfigurationType getDeployConfigurationType(@NotNull ServerType<?> serverType) {
        for (ConfigurationType type : (ConfigurationType[])ConfigurationType.CONFIGURATION_TYPE_EP.getExtensions()) {
            DeployToServerConfigurationType configurationType;
            if (!(type instanceof DeployToServerConfigurationType) || !(configurationType = (DeployToServerConfigurationType)type).getServerType().equals(serverType)) continue;
            return configurationType;
        }
        throw new IllegalArgumentException("Cannot find run configuration type for " + serverType.getClass());
    }

    public void disposeComponent() {
    }

    @NotNull
    public String getComponentName() {
        return "DeployToServerConfigurationTypesRegistrar";
    }
}

