/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.configuration.deployment;

import com.intellij.execution.configuration.ConfigurationFactoryEx;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ConfigurationTypeBase;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.project.Project;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import com.intellij.remoteServer.configuration.deployment.DeploymentConfigurator;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.configuration.deployment.DeploymentSourceType;
import com.intellij.remoteServer.impl.configuration.deployment.DeployToServerRunConfiguration;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DeployToServerConfigurationType
extends ConfigurationTypeBase {
    private final DeployToServerConfigurationFactory myFactory = new DeployToServerConfigurationFactory();
    private final ServerType<?> myServerType;

    public static String getId(ServerType<?> serverType) {
        return serverType.getId() + "-deploy";
    }

    public DeployToServerConfigurationType(@NotNull ServerType<?> serverType) {
        super(DeployToServerConfigurationType.getId(serverType), serverType.getPresentableName() + " Deployment", "Deploy to " + serverType.getPresentableName() + " run configuration", serverType.getIcon());
        this.addFactory(this.myFactory);
        this.myServerType = serverType;
    }

    public ConfigurationFactoryEx getFactory() {
        return this.myFactory;
    }

    @NotNull
    public ServerType<?> getServerType() {
        return this.myServerType;
    }

    public class DeployToServerConfigurationFactory
    extends ConfigurationFactoryEx {
        public DeployToServerConfigurationFactory() {
            super((ConfigurationType)DeployToServerConfigurationType.this);
        }

        public boolean isApplicable(@NotNull Project project2) {
            return !RemoteServersManager.getInstance().getServers(DeployToServerConfigurationType.this.myServerType).isEmpty();
        }

        public void onNewConfigurationCreated(@NotNull RunConfiguration configuration) {
            List sources;
            DeploymentSource source;
            RemoteServer server;
            DeployToServerRunConfiguration deployConfiguration = (DeployToServerRunConfiguration)configuration;
            if (deployConfiguration.getServerName() == null && (server = (RemoteServer)ContainerUtil.getFirstItem((List)RemoteServersManager.getInstance().getServers(DeployToServerConfigurationType.this.myServerType))) != null) {
                deployConfiguration.setServerName(server.getName());
            }
            if (deployConfiguration.getDeploymentSource() == null && (source = (DeploymentSource)ContainerUtil.getFirstItem((List)(sources = deployConfiguration.getDeploymentConfigurator().getAvailableDeploymentSources()))) != null) {
                deployConfiguration.setDeploymentSource(source);
                DeploymentSourceType type = source.getType();
                type.setBuildBeforeRunTask(configuration, source);
            }
        }

        public RunConfiguration createTemplateConfiguration(Project project2) {
            DeploymentConfigurator deploymentConfigurator = DeployToServerConfigurationType.this.myServerType.createDeploymentConfigurator(project2);
            return new DeployToServerRunConfiguration(project2, this, "", DeployToServerConfigurationType.this.myServerType, deploymentConfigurator);
        }
    }
}

