/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.configuration.deployment;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactPointer;
import com.intellij.packaging.elements.ArtifactRootElement;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.remoteServer.configuration.deployment.ArtifactDeploymentSource;
import com.intellij.remoteServer.configuration.deployment.DeploymentSourceType;
import com.intellij.remoteServer.impl.configuration.deployment.ArtifactDeploymentSourceType;
import java.io.File;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class ArtifactDeploymentSourceImpl
implements ArtifactDeploymentSource {
    private final ArtifactPointer myPointer;

    public ArtifactDeploymentSourceImpl(@NotNull ArtifactPointer pointer) {
        this.myPointer = pointer;
    }

    @NotNull
    public ArtifactPointer getArtifactPointer() {
        return this.myPointer;
    }

    public Artifact getArtifact() {
        return this.myPointer.getArtifact();
    }

    public File getFile() {
        String path = this.getFilePath();
        return path != null ? new File(path) : null;
    }

    public String getFilePath() {
        String outputPath;
        Artifact artifact = this.getArtifact();
        if (artifact != null && (outputPath = artifact.getOutputPath()) != null) {
            CompositePackagingElement rootElement = artifact.getRootElement();
            if (!(rootElement instanceof ArtifactRootElement)) {
                outputPath = outputPath + "/" + rootElement.getName();
            }
            return FileUtil.toSystemDependentName((String)outputPath);
        }
        return null;
    }

    @NotNull
    public String getPresentableName() {
        return this.myPointer.getArtifactName();
    }

    public Icon getIcon() {
        Artifact artifact = this.getArtifact();
        return artifact != null ? artifact.getArtifactType().getIcon() : null;
    }

    public boolean isValid() {
        return this.getArtifact() != null;
    }

    public boolean isArchive() {
        Artifact artifact = this.getArtifact();
        return artifact != null && !(artifact.getRootElement() instanceof ArtifactRootElement);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ArtifactDeploymentSourceImpl)) {
            return false;
        }
        return this.myPointer.equals(((ArtifactDeploymentSourceImpl)o).myPointer);
    }

    public int hashCode() {
        return this.myPointer.hashCode();
    }

    @NotNull
    public DeploymentSourceType<?> getType() {
        return (DeploymentSourceType)DeploymentSourceType.EP_NAME.findExtension(ArtifactDeploymentSourceType.class);
    }
}

